/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.recordSlowReq;

import com.kingdee.bos.dao.query.asistant.GetSqlPlanFileFactory;
import com.kingdee.bos.rpc.impl.RPCRequest;
import com.kingdee.bos.rpc.recordSlowReq.CallCloudSide;
import com.kingdee.bos.rpc.recordSlowReq.CallKDCloud;
import com.kingdee.bos.rpc.recordSlowReq.Constant;
import com.kingdee.bos.rpc.recordSlowReq.FileJsonInfo;
import com.kingdee.bos.rpc.recordSlowReq.NeedWriteIntoFile;
import com.kingdee.bos.rpc.recordSlowReq.SimpleRPCInfo;
import com.kingdee.bos.rpc.recordSlowReq.request.WriteFileInfoReq;
import com.kingdee.bos.rpc.recordSlowReq.response.GetFileUploadUrlResp;
import com.kingdee.bos.rpc.recordSlowReq.response.UploadFileResp;
import com.kingdee.bos.rpcrecorder.Utils;
import com.kingdee.util.LoggerItem;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;

public class RecordSlowReq {
    private static final Logger logger = Logger.getLogger(RecordSlowReq.class);
    private static BlockingQueue blockingQueue = new LinkedBlockingQueue();
    private static ExecutorService executorService = Executors.newFixedThreadPool(2);
    private static volatile boolean run = true;
    private static final String STARTJSON = "$$STARTJSON$$\r\n";
    private static final String ENDJSON = "\r\n$$ENDJSON$$\r\n";

    private static void start() {
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                while (run) {
                    logger.info((Object)("record size------------" + RecordSlowReq.getSlowReqQueueSize()));
                    try {
                        RecordSlowReq.saveRPCRequest(RecordSlowReq.takeSlowReq());
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                RecordSlowReq.stop();
            }
        }));
    }

    private static void stop() {
        run = false;
        executorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveRPCRequest(NeedWriteIntoFile needWriteIntoFile) throws Exception {
        if (needWriteIntoFile == null) {
            return;
        }
        Thread.sleep(System.getProperty("waitBeforeWriteLog") != null ? Long.valueOf(System.getProperty("waitBeforeWriteLog")) : 10000L);
        StringBuilder sb = new StringBuilder();
        ZipInputStream zipInputStream = null;
        String fileUIName = needWriteIntoFile.getUiName().substring("com.kingdee.".length(), needWriteIntoFile.getUiName().length()).replace(".", "_");
        String fileName = fileUIName + "_" + needWriteIntoFile.getActionName() + System.currentTimeMillis() + ".txt";
        try {
            RecordSlowReq.appendActionInfo(needWriteIntoFile, sb, null);
            RPCRequest rpcRequest = null;
            List<RPCRequest> rpcRequestList = needWriteIntoFile.getList();
            if (rpcRequestList != null && rpcRequestList.size() != 0) {
                byte[] sqlPlanZipBytes;
                List<String> sqlPlanIdList = RecordSlowReq.makeSqlPlanIdList(rpcRequestList);
                if (sqlPlanIdList.size() > 0 && (sqlPlanZipBytes = GetSqlPlanFileFactory.getRemoteInstance().getSqlPlanZipFile(sqlPlanIdList)) != null && sqlPlanZipBytes.length > 0) {
                    zipInputStream = new ZipInputStream(new ByteArrayInputStream(sqlPlanZipBytes));
                }
                for (int i = 0; i < rpcRequestList.size(); ++i) {
                    rpcRequest = rpcRequestList.get(i);
                    if (rpcRequest == null) continue;
                    sb.append("\r\n========================================rpcRequest");
                    sb.append("-" + i);
                    sb.append(" start========================================\r\n");
                    RecordSlowReq.appendRequestInfo(sb, rpcRequest, null);
                    RecordSlowReq.appendSqlPlanInfo(sb, rpcRequest, zipInputStream, null);
                    sb.append("\r\n========================================rpcRequest");
                    sb.append("-" + i);
                    sb.append("   end========================================\r\n\r\n\r\n\r\n");
                }
            }
            RecordSlowReq.uploadToCloudAndCallbackUrl(needWriteIntoFile, sb, fileName);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void uploadToCloudAndCallbackUrl(NeedWriteIntoFile needWriteIntoFile, StringBuilder sb, String fileName) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", fileName);
        byte[] bytes = sb.toString().getBytes();
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] digestedBytes = digest.digest(bytes);
        params.put("md5", RecordSlowReq.toHex(digestedBytes));
        params.put("folder_id", Constant.getFolderId());
        params.put("size", bytes.length);
        GetFileUploadUrlResp getUrlResp = CallCloudSide.getUrl(params);
        if (getUrlResp != null && getUrlResp.getErrcode() == 0) {
            String url = getUrlResp.getData();
            UploadFileResp uploadFileResp = CallKDCloud.uploadFile(url, bytes, fileName);
            RecordSlowReq.writeFileInfoToCloudSide(needWriteIntoFile, fileName, uploadFileResp);
        }
    }

    private static String toHex(byte[] bytes) {
        BigInteger bi = new BigInteger(1, bytes);
        return String.format("%0" + (bytes.length << 1) + "X", bi);
    }

    private static void writeFileInfoToCloudSide(NeedWriteIntoFile needWriteIntoFile, String fileName, UploadFileResp uploadFileResp) {
        if (uploadFileResp != null && uploadFileResp.getErrcode() == 0) {
            WriteFileInfoReq writeFileInfoReq = new WriteFileInfoReq();
            writeFileInfoReq.setAction(needWriteIntoFile.getUiName() + "$" + needWriteIntoFile.getActionName());
            writeFileInfoReq.setFileId(uploadFileResp.getData().getFile_id());
            writeFileInfoReq.setLogId(UUID.randomUUID().toString());
            writeFileInfoReq.setLogName(fileName);
            writeFileInfoReq.setSn(Constant.getSn());
            CallCloudSide.uploadFileInfo(writeFileInfoReq);
        }
    }

    private static List<String> makeSqlPlanIdList(List<RPCRequest> rpcRequestList) {
        ArrayList<String> sqlPlanIdList = new ArrayList<String>();
        for (int i = 0; i < rpcRequestList.size(); ++i) {
            List list;
            RPCRequest rpcRequest = rpcRequestList.get(i);
            if (rpcRequest.rpcResult == null || rpcRequest.rpcResult.analysisResult == null || (list = rpcRequest.rpcResult.analysisResult.getSQLExecuteResult()) == null || list.size() <= 0) continue;
            for (int j = 0; j < list.size(); ++j) {
                LoggerItem.ExecuteItem executeItem = (LoggerItem.ExecuteItem)list.get(j);
                if (executeItem.sqlPlanId == null || executeItem.sqlPlanId.trim().length() == 0) continue;
                sqlPlanIdList.add(executeItem.sqlPlanId);
            }
        }
        return sqlPlanIdList;
    }

    private static void appendActionInfo(NeedWriteIntoFile needWriteIntoFile, StringBuilder sb, FileJsonInfo fileJsonInfo) {
        sb.append("=================================================Action   Info==============================================================\r\n");
        sb.append("======    uiName:  ");
        sb.append(needWriteIntoFile.getUiName());
        sb.append("  actionName:  ");
        sb.append(needWriteIntoFile.getActionName());
        sb.append("         =========\r\n");
        sb.append("======    startTime:  ");
        sb.append(Utils.formatSimpleTime(needWriteIntoFile.getStartTime()));
        sb.append("  endTime:  ");
        sb.append(Utils.formatSimpleTime(needWriteIntoFile.getEndTime()));
        sb.append("  costTime(ms):  ");
        sb.append(needWriteIntoFile.getEndTime() - needWriteIntoFile.getStartTime());
        sb.append("  rpc count:  ");
        if (needWriteIntoFile.getList() != null && needWriteIntoFile.getList().size() != 0) {
            sb.append(needWriteIntoFile.getList().size());
        }
        sb.append("  considerTime(ms):  ");
        sb.append(needWriteIntoFile.getConsiderTime());
        sb.append("    =========\r\n");
        sb.append("=================================================Action   Info==============================================================\r\n\r\n");
    }

    private static void appendSqlPlanInfo(StringBuilder sb, RPCRequest rpcRequest, ZipInputStream zipInputStream, SimpleRPCInfo simpleRPCInfo) throws Exception {
        List list;
        if (rpcRequest.rpcResult != null && rpcRequest.rpcResult.analysisResult != null && (list = rpcRequest.rpcResult.analysisResult.getSQLExecuteResult()) != null && list.size() > 0) {
            sb.append("  sql count: " + list.size() + "\r\n\r\n");
            if (zipInputStream == null) {
                RecordSlowReq.makeKsqlInfo(sb, list);
            } else {
                RecordSlowReq.makeSqlPlanInfo(sb, zipInputStream, list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void makeSqlPlanInfo(StringBuilder sb, ZipInputStream zipInputStream, List list) throws IOException {
        for (int i = 0; i < list.size(); ++i) {
            sb.append("--------------------------sql-" + i + " info--------------------------\r\n");
            LoggerItem.ExecuteItem executeItem = (LoggerItem.ExecuteItem)list.get(i);
            if (executeItem.sqlPlanId != null && executeItem.sqlPlanId.trim().length() != 0) {
                ZipEntry entry;
                logger.info((Object)("sqlPlanID" + executeItem.sqlPlanId));
                boolean hasFound = false;
                while ((entry = zipInputStream.getNextEntry()) != null) {
                    if (!entry.getName().contains(executeItem.sqlPlanId)) continue;
                    hasFound = true;
                    BufferedReader in = null;
                    try {
                        in = new BufferedReader(new InputStreamReader(zipInputStream));
                        String aLine = null;
                        while ((aLine = in.readLine()) != null) {
                            aLine = aLine + "\r\n";
                            sb.append(aLine);
                        }
                        break;
                    }
                    finally {
                        zipInputStream.closeEntry();
                    }
                }
                if (!hasFound) {
                    RecordSlowReq.justAppendKsql(sb, executeItem);
                }
            } else {
                RecordSlowReq.justAppendKsql(sb, executeItem);
            }
            sb.append("--------------------------sql-" + i + " info--------------------------\r\n\r\n");
        }
    }

    private static void justAppendKsql(StringBuilder sb, LoggerItem.ExecuteItem executeItem) {
        sb.append("ksql: ");
        sb.append(executeItem.ksql);
        sb.append("\r\n");
        sb.append(" startTime: ");
        sb.append(Utils.formatSimpleTime(executeItem.startTime));
        sb.append(" endTime: ");
        sb.append(Utils.formatSimpleTime(executeItem.endTime));
        sb.append(" timespan(ms): ");
        sb.append(executeItem.endTime - executeItem.startTime);
        sb.append("\r\n");
    }

    private static void makeKsqlInfo(StringBuilder sb, List list) {
        for (int i = 0; i < list.size(); ++i) {
            sb.append("--------------------------sql-" + i + " info--------------------------\r\n");
            LoggerItem.ExecuteItem executeItem = (LoggerItem.ExecuteItem)list.get(i);
            sb.append("ksql: ");
            sb.append(executeItem.ksql);
            sb.append("\r\n");
            sb.append(" startTime: ");
            sb.append(Utils.formatSimpleTime(executeItem.startTime));
            sb.append(" endTime: ");
            sb.append(Utils.formatSimpleTime(executeItem.endTime));
            sb.append(" timespan(ms): ");
            sb.append(executeItem.endTime - executeItem.startTime);
            sb.append("\r\n");
            sb.append("--------------------------sql-" + i + " info--------------------------\r\n\r\n");
        }
    }

    private static void appendRequestInfo(StringBuilder sb, RPCRequest request, SimpleRPCInfo simpleRPCInfo) {
        sb.append("  model:  ");
        sb.append(request.model.getName());
        sb.append("  className:  ");
        sb.append(request.className);
        sb.append("\r\n");
        sb.append("  methodName:  ");
        sb.append(request.methodName);
        sb.append("\r\n");
        sb.append("  threadName:  ");
        sb.append(request.threadName);
        sb.append("  startTime:  ");
        sb.append(Utils.formatSimpleTime(request.startTime));
        sb.append("  costTime(ms):  ");
        sb.append(request.endTime - request.startTime);
    }

    public static NeedWriteIntoFile takeSlowReq() {
        try {
            return (NeedWriteIntoFile)blockingQueue.take();
        }
        catch (InterruptedException e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static void addSlowReqList(List list, String uiName, String actionName, long startTime, long endTime, long considerTime) {
        try {
            NeedWriteIntoFile needWriteIntoFile = new NeedWriteIntoFile(list, uiName, actionName, startTime, endTime, considerTime);
            blockingQueue.put(needWriteIntoFile);
        }
        catch (InterruptedException e) {
            logger.error((Object)e);
        }
    }

    public static int getSlowReqQueueSize() {
        return blockingQueue.size();
    }

    static {
        RecordSlowReq.start();
    }
}

