/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc.recordSlowReq;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.log4j.Logger;

public class UploadCloudUtil {
    private static final Logger logger = Logger.getLogger(UploadCloudUtil.class);
    private static final String LINE_FEED = "\r\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadFile(String requestURL, byte[] fileData, String fileName) {
        Object url = null;
        HttpURLConnection httpConn = null;
        PrintWriter writer = null;
        try {
            String boundary = System.currentTimeMillis() + "";
            httpConn = UploadCloudUtil.getHttpURLConnection(requestURL, null, boundary);
            OutputStream outputStream = httpConn.getOutputStream();
            writer = new PrintWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), true);
            UploadCloudUtil.addFilePart("newfile", fileName, fileData, writer, boundary, outputStream);
            writer.append("--" + boundary + "--").append(LINE_FEED);
            writer.close();
            String string = UploadCloudUtil.getResult(httpConn);
            return string;
        }
        catch (Exception e) {
            logger.error((Object)("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38: " + e));
            String string = null;
            return string;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            if (httpConn != null) {
                try {
                    httpConn.disconnect();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    private static String getResult(HttpURLConnection httpConn) throws IOException {
        StringBuilder result = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(httpConn.getInputStream()));
        String line = null;
        while ((line = reader.readLine()) != null) {
            result.append(line);
        }
        reader.close();
        httpConn.disconnect();
        return result.toString();
    }

    public static void addFormField(String name, String value, String boundary, PrintWriter writer) {
        writer.append("--" + boundary).append(LINE_FEED);
        writer.append("Content-Disposition: form-data; name=\"" + name + "\"").append(LINE_FEED);
        writer.append("Content-Type: text/plain; charset=UTF-8").append(LINE_FEED);
        writer.append(LINE_FEED);
        writer.append(value).append(LINE_FEED);
        writer.flush();
    }

    public static void addFilePart(String fieldName, String fileName, byte[] bytes, PrintWriter writer, String boundary, OutputStream outputStream) throws IOException {
        writer.append("--" + boundary).append(LINE_FEED);
        writer.append("Content-Disposition: form-data; name=\"" + fieldName + "\"; filename=\"" + fileName + "\"").append(LINE_FEED);
        writer.append("Content-Type: " + URLConnection.guessContentTypeFromName(fileName)).append(LINE_FEED);
        writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
        writer.append(LINE_FEED);
        writer.flush();
        outputStream.write(bytes);
        outputStream.flush();
        writer.append(LINE_FEED);
        writer.flush();
    }

    private static HttpURLConnection getHttpURLConnection(String requestURL, String access_token, String boundary) throws IOException {
        URL url = access_token != null ? new URL(requestURL + "?access_token=" + access_token) : new URL(requestURL);
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.setUseCaches(false);
        httpConn.setDoOutput(true);
        httpConn.setDoInput(true);
        httpConn.setRequestMethod("POST");
        httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        return httpConn;
    }
}

