/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpc_availability;

import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc_availability.AttemptException;
import com.kingdee.bos.rpc_availability.Attempter;
import com.kingdee.bos.rpc_availability.FinderConfiguratonException;
import com.kingdee.bos.rpc_availability.ServerFacede;
import com.kingdee.bos.rpc_availability.ServerListRepresent;
import com.kingdee.bos.rpc_availability.ServerStatisicList;
import com.kingdee.bos.rpc_availability.ServerStatistic;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class ServerFinder {
    private HashMap statisticCache = new HashMap();
    private static final Logger logger = Logger.getLogger(ServerFinder.class);
    private static ServerFinder instance;

    public static ServerFinder getInstance() throws FinderConfiguratonException {
        if (instance != null) {
            return instance;
        }
        String finderClassName = ORMRPConfig.getServerFinderClass();
        if (finderClassName == null) {
            throw new FinderConfiguratonException("finderClassName is null : not congfig finderClassName! ");
        }
        try {
            Class<?> finderClass = Class.forName(finderClassName);
            instance = (ServerFinder)finderClass.newInstance();
        }
        catch (Exception e) {
            throw new FinderConfiguratonException("finder config error! ", e);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerStatisicList getCurentStatistic(ServerListRepresent serverlist) {
        HashMap hashMap = this.statisticCache;
        synchronized (hashMap) {
            ServerStatisicList statisticList = (ServerStatisicList)this.statisticCache.get(serverlist);
            if (statisticList == null) {
                statisticList = this.initStatisticList(serverlist);
            }
            this.statisticCache.put(serverlist, statisticList);
            return statisticList;
        }
    }

    public ServerFacede hitOne(ServerListRepresent serverList) {
        ServerStatisicList statisticList = this.getCurentStatistic(serverList);
        ServerStatistic statistic = statisticList.hitOne();
        if (statistic == null) {
            return null;
        }
        statistic.increaseDynamicWeight();
        return statistic.getServer();
    }

    public void oneFailed(ServerListRepresent serverList, ServerFacede server) {
        ServerStatisicList statisticList = this.getCurentStatistic(serverList);
        statisticList.oneFailed(server);
    }

    private static InetSocketAddress getAddress(String url) throws UnknownHostException {
        int port;
        String host;
        int index = url.indexOf(47) + 2;
        int index1 = url.indexOf(47, index);
        String address = index1 < 0 ? url.substring(index) : url.substring(index, index1);
        index = address.indexOf(58);
        if (index < 0) {
            host = address;
            port = 11034;
        } else {
            host = address.substring(0, index);
            port = Integer.parseInt(address.substring(index + 1));
        }
        InetAddress addr = InetAddress.getByName(host);
        return new InetSocketAddress(addr, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object tryServerAttempt(ServerListRepresent serverList, Attempter att, Class[] argTypes, Object[] args) {
        Object re = null;
        ServerFacede server = null;
        boolean success = false;
        int serverCount = serverList.getServerFacedeList().size();
        ServerStatisicList statisticList = this.getCurentStatistic(serverList);
        while (!success && serverCount > 0) {
            server = this.hitOne(serverList);
            --serverCount;
            try {
                if (server == null) continue;
                re = att.tryIt(server, argTypes, args);
                logger.info((Object)("RPC Server[" + server.getIdentify() + "] hitted"));
                success = true;
            }
            catch (AttemptException e0) {
                throw new RPCException(e0);
            }
            catch (Exception e) {
                ServerStatisicList serverStatisicList = statisticList;
                synchronized (serverStatisicList) {
                    ServerFacede serverTmp = this.hitOne(serverList);
                    if (server.equals(serverTmp)) {
                        this.oneFailed(serverList, server);
                        logger.error((Object)("RPC Server[" + server.getIdentify() + "] failed,try anohter"), (Throwable)e);
                    }
                    success = false;
                }
            }
        }
        if (!success) {
            throw new RPCException(5001, "Cannot Connect To Any RPC ServerServer,All Server Are Unavailable!");
        }
        return re;
    }

    protected abstract ServerStatisicList initStatisticList(ServerListRepresent var1);

    protected abstract ServerFacede serverStatisticChanged(ServerFacede var1, ServerStatistic var2);
}

