/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder.command;

import com.kingdee.bos.rpcrecorder.Context;
import com.kingdee.bos.rpcrecorder.Policy;
import com.kingdee.bos.rpcrecorder.RecorderException;
import com.kingdee.bos.rpcrecorder.command.ICommand;
import com.kingdee.bos.rpcrecorder.command.ICommandParameter;
import com.kingdee.bos.rpcrecorder.command.ICommandResult;
import com.kingdee.bos.rpcrecorder.command.parameter.UnresolvedParameter;
import com.kingdee.bos.rpcrecorder.command.result.BooleanResult;
import com.kingdee.bos.rpcrecorder.command.result.ExceptionResult;
import java.util.HashMap;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;

public class CommandPutListToXpath2
implements ICommand {
    @Override
    public String getName() {
        return "putListToXpath2";
    }

    @Override
    public ICommandResult execute(Context ctx, ICommandParameter[] parameters) {
        String p;
        UnresolvedParameter unresolvedParameter = (UnresolvedParameter)parameters[0];
        String txt = unresolvedParameter.parameter;
        int pos = txt.indexOf(",");
        if (pos < 0) {
            throw new RecorderException("Illegal command 'putListToXpath' parameter need ','");
        }
        String v = txt.substring(0, pos);
        if (!(v = v.trim()).startsWith("$")) {
            v = "$" + v;
        }
        String r = txt.substring(pos + 1, txt.length());
        if ((r = r.trim()).startsWith("\"")) {
            p = "\"";
        } else if (r.startsWith("'")) {
            p = "'";
        } else {
            throw new RecorderException("Illegal command 'putListToXpath2' parameter need be String");
        }
        r = r.substring(1);
        pos = r.indexOf(p);
        String xpath1 = r.substring(0, pos);
        r = r.substring(pos + 1);
        r = r.trim();
        if (r.startsWith(",")) {
            r = r.substring(1);
        }
        if ((r = r.trim()).startsWith("\"")) {
            p = "\"";
        } else if (r.startsWith("'")) {
            p = "'";
        }
        r = r.substring(1);
        pos = r.indexOf(p);
        String xpath2 = r.substring(0, pos);
        String attr = null;
        if (r.length() > pos + 1) {
            r = r.substring(pos + 1);
            if ((r = r.trim()).startsWith(",")) {
                r = r.substring(1);
            }
            if (r.startsWith("\"") && r.endsWith("\"")) {
                r = r.substring(1, r.length() - 1);
            } else if (r.startsWith("'") && r.endsWith("'")) {
                r = r.substring(1, r.length() - 1);
            }
            attr = r;
        }
        return this.executeXpath(ctx, v, xpath1, xpath2, attr);
    }

    private ICommandResult executeXpath(Context ctx, String var, String xpath1, String xpath2, String attr) {
        boolean logOff = Policy.isOff(ctx, Policy.POLICY_LOGRPC);
        Element element = (Element)ctx.get("_rpcrequest_");
        HashMap restoreMap = (HashMap)ctx.get("_restoremap_");
        boolean found = false;
        try {
            List elist = XPath.selectNodes((Object)element, (String)xpath2);
            if (elist == null || elist.isEmpty()) {
                return new ExceptionResult(new RecorderException("Can't select by xpath:" + xpath2));
            }
            List data = (List)ctx.get(var);
            if (data == null) {
                return new ExceptionResult(new RecorderException(var + "Can't be null."));
            }
            if (elist.size() != data.size()) {
                return new ExceptionResult(new RecorderException("List size " + data.size() + " not equals to xpath element size " + elist.size()));
            }
            int index = 0;
            for (Element find : elist) {
                if (attr != null) {
                    Attribute att = find.getAttribute(attr);
                    String v = att.getValue();
                    String nv = (String)data.get(index);
                    att.setValue(nv);
                    restoreMap.put(att, v);
                    find.setAttribute("_hasVariable_", "true");
                    found = true;
                    if (!logOff) {
                        System.out.println("putListToXpath Replace " + v + " to " + nv + ",xpath is " + xpath2);
                    }
                } else {
                    return new ExceptionResult(new RecorderException("You must assign attribute"));
                }
                ++index;
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
            return new ExceptionResult(new RecorderException("Can't get by xpath:" + xpath2, e));
        }
        if (found) {
            try {
                Element cacheElement = (Element)XPath.selectSingleNode((Object)element, (String)xpath1);
                if (cacheElement == null) {
                    return new ExceptionResult(new RecorderException("Can't get by xpath:" + xpath1));
                }
                cacheElement.setAttribute("_hasVariable_", "true");
            }
            catch (JDOMException e) {
                e.printStackTrace();
                return new ExceptionResult(new RecorderException("Can't get by xpath:" + xpath1, e));
            }
        }
        return new BooleanResult(Boolean.TRUE);
    }

    @Override
    public boolean needResolveParameter() {
        return true;
    }

    @Override
    public boolean laterExecute() {
        return true;
    }
}

