/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder.command;

import com.kingdee.bos.rpc.impl.RPCRequest;
import com.kingdee.bos.rpcrecorder.Context;
import com.kingdee.bos.rpcrecorder.Policy;
import com.kingdee.bos.rpcrecorder.SerdeTool;
import com.kingdee.bos.rpcrecorder.Utils;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;

public class RPCRequestObjectLogger {
    public static void log(Context ctx, Object o) {
        if (Policy.isOff(ctx, Policy.POLICY_LOGRPC)) {
            return;
        }
        RPCRequest request = (RPCRequest)o;
        String scriptPath = (String)ctx.get("$scriptpath");
        String scriptName = (String)ctx.get("$scriptname");
        long scriptStartTime = Long.parseLong((String)ctx.get("_scriptstarttime_"));
        String rpcObjectFileName = (String)ctx.get("_rpcobjectfilename_");
        String requestName = rpcObjectFileName;
        if (requestName.endsWith(".xml") || requestName.endsWith(".rpc")) {
            requestName = requestName.substring(0, requestName.length() - 4);
        }
        File file = new File(scriptPath + "/" + scriptName + "_requestobject" + "/requestobject_" + Utils.formatSimpleTime(scriptStartTime));
        int tryindex = 0;
        while (tryindex++ < 20 && !file.exists() && !file.mkdirs()) {
            try {
                Thread.sleep(500 * tryindex);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        String fileName = file.getAbsolutePath() + "/" + rpcObjectFileName;
        fileName = StringUtils.replace((String)fileName, (String)"\\", (String)"/");
        try {
            SerdeTool.saveObjectAsXML(request, fileName);
            System.out.println("Save RPCRequest As XML:" + fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

