/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder.command;

import com.kingdee.bos.rpc.impl.RPCResult;
import com.kingdee.bos.rpcrecorder.Context;
import com.kingdee.bos.rpcrecorder.Policy;
import com.kingdee.bos.rpcrecorder.RecorderException;
import com.kingdee.bos.rpcrecorder.ReplayException;
import com.kingdee.bos.rpcrecorder.ResultHandlerManager;
import com.kingdee.bos.rpcrecorder.command.CommandInfo;
import com.kingdee.bos.rpcrecorder.command.ICommandResult;
import com.kingdee.bos.rpcrecorder.command.IExecutor;
import com.kingdee.bos.rpcrecorder.command.IResultHandler;
import com.kingdee.bos.rpcrecorder.command.LaterExecuteManager;
import com.kingdee.bos.rpcrecorder.command.ScriptResult;
import com.kingdee.bos.rpcrecorder.command.result.LaterExecuteResult;
import com.kingdee.bos.rpcrecorder.command.result.RPCResultResult;
import com.kingdee.bos.rpcrecorder.def.AbstractDef;
import com.kingdee.bos.rpcrecorder.def.ScriptDef;
import com.kingdee.bos.rpcrecorder.def.StatementDef;
import com.kingdee.bos.rpcrecorder.parser.Parser;

public class ScriptExecutor
implements IExecutor {
    private Context ctx;
    private ScriptDef script;

    public ScriptExecutor(Context ctx, ScriptDef script) {
        this.ctx = ctx;
        this.script = script;
    }

    @Override
    public Object execute() {
        if (this.script.scriptPath != null) {
            this.ctx.put("$scriptpath", this.script.scriptPath);
        }
        if (this.script.scriptName != null) {
            this.ctx.put("$scriptname", this.script.scriptName);
        }
        this.ctx.put("_scriptstarttime_", "" + System.currentTimeMillis());
        AbstractDef[] defs = this.script.defs;
        String[] commandTexts = new String[defs.length];
        ICommandResult[] results = new ICommandResult[defs.length];
        boolean hasBreak = false;
        for (int i = 0; i < defs.length; ++i) {
            String policy;
            block11: {
                AbstractDef def;
                if (hasBreak || !((def = defs[i]) instanceof StatementDef)) continue;
                CommandInfo commandInfo = Parser.parserStatement((StatementDef)def);
                commandTexts[i] = commandInfo.commandText;
                try {
                    if (commandInfo.command.laterExecute()) {
                        LaterExecuteManager.addCommand(this.ctx, commandInfo);
                        results[i] = new LaterExecuteResult();
                    } else {
                        results[i] = this.executeCommand(commandInfo);
                    }
                }
                catch (RecorderException e) {
                    System.out.println(e.getMessage());
                    policy = Policy.getOnException(this.ctx);
                    if (!"Stop".equalsIgnoreCase(policy)) break block11;
                    hasBreak = true;
                    throw e;
                }
            }
            if (results[i].getType() == 32) {
                ((Throwable)results[i].getValue()).printStackTrace();
                String policy2 = Policy.getOnException(this.ctx);
                if (!"Stop".equalsIgnoreCase(policy2)) continue;
                hasBreak = true;
                Throwable t = (Throwable)results[i].getValue();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new ReplayException(t);
            }
            if (results[i].getType() != 64) continue;
            RPCResult rpcResult = (RPCResult)((RPCResultResult)results[i]).getValue();
            if (!rpcResult.isException) continue;
            rpcResult.exception.printStackTrace();
            policy = Policy.getOnException(this.ctx);
            if (!"Stop".equalsIgnoreCase(policy)) continue;
            hasBreak = true;
            Throwable t = rpcResult.exception;
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new ReplayException(t);
        }
        this.ctx.put("_scriptendtime_", "" + System.currentTimeMillis());
        ScriptResult result = new ScriptResult(commandTexts, results);
        IResultHandler resultHandler = ResultHandlerManager.getScriptResultHandler(this.ctx);
        if (resultHandler != null) {
            resultHandler.handle(this.ctx, result);
        }
        return result;
    }

    private ICommandResult executeCommand(CommandInfo commandInfo) {
        return commandInfo.command.execute(this.ctx, commandInfo.params);
    }

    @Override
    public Context getContext() {
        return this.ctx;
    }
}

