/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder.command.asserts;

import com.kingdee.bos.rpc.impl.RPCResult;
import com.kingdee.bos.rpcrecorder.AssertException;
import com.kingdee.bos.rpcrecorder.Context;
import com.kingdee.bos.rpcrecorder.Policy;
import com.kingdee.bos.rpcrecorder.RecorderException;
import com.kingdee.bos.rpcrecorder.command.ICommand;
import com.kingdee.bos.rpcrecorder.command.ICommandParameter;
import com.kingdee.bos.rpcrecorder.command.ICommandResult;
import com.kingdee.bos.rpcrecorder.command.parameter.UnresolvedParameter;
import com.kingdee.bos.rpcrecorder.command.result.BooleanResult;
import com.kingdee.bos.rpcrecorder.command.result.ExceptionResult;
import com.kingdee.bos.rpcrecorder.serde.SerdeContext;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.DefaultJDOMFactory;
import org.jdom.xpath.XPath;

public class CommandAssertNotNullEmpty
implements ICommand {
    @Override
    public String getName() {
        return "AssertNotNullEmpty";
    }

    @Override
    public ICommandResult execute(Context ctx, ICommandParameter[] parameters) {
        String p;
        String txt;
        if (Policy.isOff(ctx, Policy.POLICY_ENABLE_ASSERT)) {
            return new BooleanResult(Boolean.TRUE);
        }
        UnresolvedParameter unresolvedParameter = (UnresolvedParameter)parameters[0];
        String r = txt = unresolvedParameter.parameter;
        if ((r = r.trim()).startsWith("\"")) {
            p = "\"";
        } else if (r.startsWith("'")) {
            p = "'";
        } else {
            throw new RecorderException("Illegal command 'AssertNotNullEmpty' parameter need be String");
        }
        r = r.substring(1);
        int pos = r.indexOf(p);
        String xpath = r.substring(0, pos);
        String attr = null;
        if (r.length() > pos + 1) {
            r = r.substring(pos + 1);
            if ((r = r.trim()).startsWith(",")) {
                r = r.substring(1);
            }
            if (r.startsWith("\"") && r.endsWith("\"")) {
                r = r.substring(1, r.length() - 1);
            } else if (r.startsWith("'") && r.endsWith("'")) {
                r = r.substring(1, r.length() - 1);
            }
            attr = r;
        }
        return this.executeXpath(ctx, xpath, attr);
    }

    private ICommandResult executeXpath(Context ctx, String xpath, String attr) {
        RPCResult result = (RPCResult)ctx.get("_rpcresult_");
        if (result == null) {
            return new ExceptionResult(new AssertException("AssertNotNullEmpty false, because result is null"));
        }
        if (result.isException) {
            return new ExceptionResult(new AssertException("AssertNotNullEmpty false, because result is Exception"));
        }
        DefaultJDOMFactory factory = new DefaultJDOMFactory();
        Element element2 = new SerdeContext(ctx).toXML(result);
        factory.document(element2);
        Element find = null;
        try {
            find = (Element)XPath.selectSingleNode((Object)element2, (String)xpath);
        }
        catch (JDOMException e) {
            e.printStackTrace();
            return new ExceptionResult(new AssertException("AssertNotNullEmpty false, exception on xpath:" + xpath));
        }
        if (find == null) {
            return new ExceptionResult(new AssertException("AssertNotNullEmpty false, can't find xpath:" + xpath));
        }
        String value = attr != null ? find.getAttributeValue(attr) : find.getTextNormalize();
        if (value == null) {
            return new ExceptionResult(new AssertException("AssertNotNullEmpty false, value is Null"));
        }
        if ("".equals(value)) {
            return new ExceptionResult(new AssertException("AssertNotNullEmpty false, value is Empty String"));
        }
        System.out.println("AssertNotNullEmpty true.value is " + value);
        return new BooleanResult(Boolean.TRUE);
    }

    @Override
    public boolean needResolveParameter() {
        return true;
    }

    @Override
    public boolean laterExecute() {
        return false;
    }
}

