/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder.command.resulthandler;

import com.kingdee.bos.rpcrecorder.Context;
import com.kingdee.bos.rpcrecorder.Policy;
import com.kingdee.bos.rpcrecorder.SerdeTool;
import com.kingdee.bos.rpcrecorder.Utils;
import com.kingdee.bos.rpcrecorder.command.ICommandResult;
import com.kingdee.bos.rpcrecorder.command.IResultHandler;
import com.kingdee.bos.rpcrecorder.command.ScriptResult;
import com.kingdee.bos.rpcrecorder.command.result.AllRPCResult;
import com.kingdee.bos.rpcrecorder.command.result.RPCResultResult;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;

public class ScriptResultHandler
implements IResultHandler {
    @Override
    public void handle(Context ctx, Object o) {
        if (Policy.isOff(ctx, Policy.POLICY_OUTPUTRPCRESULT)) {
            return;
        }
        ScriptResult result = (ScriptResult)o;
        String scriptPath = (String)ctx.get("$scriptpath");
        String scriptName = (String)ctx.get("$scriptname");
        long scriptStartTime = Long.parseLong((String)ctx.get("_scriptstarttime_"));
        long scriptEndTime = Long.parseLong((String)ctx.get("_scriptendtime_"));
        ICommandResult[] commandResults = result.commandResults;
        ArrayList<Object> rpcResults = new ArrayList<Object>();
        for (int i = 0; i < commandResults.length; ++i) {
            if (commandResults[i] == null || commandResults[i].getType() != 64) continue;
            rpcResults.add(((RPCResultResult)commandResults[i]).getValue());
        }
        Object[] results = rpcResults.toArray(new Object[rpcResults.size()]);
        AllRPCResult arr = new AllRPCResult(scriptStartTime, scriptEndTime, results);
        String fileName = scriptPath + "/" + scriptName + "_output" + "/result_" + Utils.formatSimpleTime(scriptStartTime) + "/allresult.xml";
        fileName = StringUtils.replace((String)fileName, (String)"\\", (String)"/");
        try {
            SerdeTool.saveObjectAsXML(arr, fileName);
            System.out.println("Save All RPC Result As XML:" + fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

