/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder.parser;

import com.kingdee.bos.rpcrecorder.Context;
import com.kingdee.bos.rpcrecorder.RecorderException;
import com.kingdee.bos.rpcrecorder.Utils;
import com.kingdee.bos.rpcrecorder.command.CommandInfo;
import com.kingdee.bos.rpcrecorder.command.ICommandParameter;
import com.kingdee.bos.rpcrecorder.command.UDFFactory;
import com.kingdee.bos.rpcrecorder.command.parameter.BooleanParam;
import com.kingdee.bos.rpcrecorder.command.parameter.FloatParam;
import com.kingdee.bos.rpcrecorder.command.parameter.IntParam;
import com.kingdee.bos.rpcrecorder.command.parameter.StringParam;
import com.kingdee.bos.rpcrecorder.command.parameter.UnresolvedParameter;
import com.kingdee.bos.rpcrecorder.command.parameter.VariableParam;
import com.kingdee.bos.rpcrecorder.def.ScriptDef;
import com.kingdee.bos.rpcrecorder.def.StatementDef;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class Parser {
    public static ScriptDef parserScriptFile(Context ctx, String fileName) {
        File file = null;
        InputStreamReader fr = null;
        fileName = Utils.getAbsolutePath(ctx, fileName);
        try {
            file = new File(fileName);
            fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            String script = "";
            String line = null;
            while ((line = br.readLine()) != null) {
                script = script + "\r\n" + line;
            }
            ScriptDef def = Parser.parserScript(script);
            String path = fileName.substring(0, fileName.lastIndexOf("/"));
            String scriptName = fileName.substring(fileName.lastIndexOf("/") + 1);
            if (scriptName.endsWith(".script")) {
                scriptName = scriptName.substring(0, scriptName.lastIndexOf("."));
            }
            def.scriptName = scriptName;
            def.scriptPath = path;
            ScriptDef scriptDef = def;
            return scriptDef;
        }
        catch (IOException e) {
            throw new RecorderException("Unable to read script file: " + fileName);
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static ScriptDef parserScript(String script) {
        ScriptDef scriptDef = new ScriptDef();
        scriptDef.fromText(script);
        return scriptDef;
    }

    public static CommandInfo parserStatement(StatementDef def) throws RecorderException {
        String command = def.command;
        CommandInfo commandInfo = new CommandInfo();
        commandInfo.commandText = def.toText();
        if (!UDFFactory.exists(command)) {
            throw new RecorderException("Unsupport command:" + command);
        }
        commandInfo.command = UDFFactory.getCommand(command);
        if (commandInfo.command.needResolveParameter()) {
            commandInfo.params = new ICommandParameter[1];
            commandInfo.params[0] = Parser.parserParameter2(def.parameter);
        } else if (def.parameters != null) {
            commandInfo.params = new ICommandParameter[def.parameters.length];
            for (int i = 0; i < commandInfo.params.length; ++i) {
                commandInfo.params[i] = Parser.parserParameter(def.parameters[i]);
            }
        }
        return commandInfo;
    }

    private static ICommandParameter parserParameter2(String parameter) {
        return new UnresolvedParameter(parameter);
    }

    public static ICommandParameter parserParameter(String string) {
        if (string.startsWith("$")) {
            VariableParam param = new VariableParam(string.substring(1));
            return param;
        }
        if (string.startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'")) {
            return new StringParam(string.substring(1, string.length() - 1));
        }
        if ("true".equalsIgnoreCase(string)) {
            return new BooleanParam(Boolean.TRUE);
        }
        if ("false".equalsIgnoreCase(string)) {
            return new BooleanParam(Boolean.FALSE);
        }
        Integer i = null;
        try {
            i = Integer.parseInt(string);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (i != null) {
            return new IntParam(i);
        }
        Float f = null;
        try {
            f = Float.valueOf(Float.parseFloat(string));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (f != null) {
            return new FloatParam(f);
        }
        throw new RecorderException("Illegal Parameter: " + string);
    }

    public static void main(String[] args) {
        String str = "@{helloworld}";
        System.out.println(str.substring(str.indexOf("@{") + 2, str.length() - 1));
        str = "1.0";
        System.out.println(Integer.parseInt(str));
    }
}

