/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder.serde;

import com.kingdee.bos.rpcrecorder.RecorderException;
import com.kingdee.bos.rpcrecorder.serde.AbstractXmlSerde;
import com.kingdee.bos.rpcrecorder.serde.IXmlSerde;
import com.kingdee.bos.rpcrecorder.serde.SerdeContext;
import com.kingdee.bos.rpcrecorder.serde.SerdeUtils;
import com.kingdee.bos.rpcrecorder.serde.XmlSerdeFactory;
import java.lang.reflect.Array;
import java.util.List;
import org.jdom.Element;

public class ArraySerdeProvider {
    public static void touch() {
    }

    static {
        XmlSerdeFactory.register(Object[].class, (IXmlSerde)new ArraySerde(Object[].class));
    }

    public static class ArraySerde
    extends AbstractXmlSerde {
        protected ArraySerde(Class clazz) {
            super(clazz);
        }

        @Override
        public Element toXML(SerdeContext ctx, Class clazz, Object object) {
            Element element = this.createElement();
            Object oa = object;
            if (oa != null) {
                int size = Array.getLength(oa);
                element.setAttribute("size", "" + size);
                element.setAttribute("class", object.getClass().getName());
                int index = 0;
                for (int i = 0; i < size; ++i) {
                    Object value = Array.get(oa, i);
                    Element childEle = new Element("Child");
                    childEle.setAttribute("index", "" + index++);
                    element.addContent(childEle);
                    childEle.addContent(ctx.toXML(value));
                }
            }
            return element;
        }

        @Override
        public Object fromXML(SerdeContext ctx, Element element) {
            String s = element.getAttributeValue("size");
            String clazzName = element.getAttributeValue("class");
            if (s == null || "".equals(s)) {
                return null;
            }
            Object oa = null;
            int size = Integer.parseInt(s);
            if (clazzName.equals("[[Ljava.lang.Object;")) {
                oa = new Object[size][];
            } else {
                Class childClazz = null;
                try {
                    childClazz = SerdeUtils.getArrayComponentClass(clazzName);
                }
                catch (ClassNotFoundException e) {
                    throw new RecorderException(e.getMessage());
                }
                oa = Array.newInstance(childClazz, size);
            }
            List children = element.getChildren("Child");
            int index = 0;
            for (Element childEle : children) {
                Element objectEle = (Element)childEle.getChildren().get(0);
                Array.set(oa, index++, ctx.fromXML(objectEle));
            }
            return oa;
        }

        @Override
        protected String getTagName() {
            return "Array";
        }

        @Override
        public boolean accept(String type) {
            return type.equals(this.getTagName()) || SerdeUtils.isArray(type);
        }

        @Override
        public boolean isMultiMatch() {
            return true;
        }
    }
}

