/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder.serde;

import com.kingdee.bos.rpc.impl.PrimitiveHold;
import com.kingdee.bos.rpcrecorder.RecorderException;
import com.kingdee.bos.rpcrecorder.serde.IXmlSerde;
import com.kingdee.bos.rpcrecorder.serde.SerdeContext;
import com.kingdee.bos.rpcrecorder.serde.SerdeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.jdom.Element;

public class CommonObjectSerde
implements IXmlSerde {
    public static CommonObjectSerde instance = new CommonObjectSerde();
    private static HashSet supportClass = new HashSet();

    public static void registerClass(String className) {
        supportClass.add(className);
    }

    @Override
    public Element toXML(SerdeContext ctx, Class clazz, Object object) throws RecorderException {
        ctx.markIdentityObject(object);
        Element element = new Element("CommonObject");
        element.setAttribute("id", "" + SerdeUtils.identityId(object));
        element.setAttribute("class", object.getClass().getName());
        CommonObjectSerde.encodeObject(ctx, object, element);
        return element;
    }

    @Override
    public Object fromXML(SerdeContext ctx, Element element) {
        String className = element.getAttributeValue("class");
        try {
            Class clz = SerdeUtils.classForName(className);
            Constructor ct = clz.getDeclaredConstructor(new Class[0]);
            ct.setAccessible(true);
            Object object = ct.newInstance(new Object[0]);
            this.decodeObject(ctx, object, element);
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new RecorderException("Class not found:" + className);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new RecorderException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new RecorderException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        throw new RecorderException("Can't decode class " + className + ",maybe the class chaged.");
    }

    private void decodeObject(SerdeContext ctx, Object object, Element element) {
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        Field[] fields = CommonObjectSerde.getFields(object);
        for (int i = 0; i < fields.length; ++i) {
            fields[i].setAccessible(true);
            if (Modifier.isStatic(fields[i].getModifiers())) continue;
            String name = fields[i].getName();
            fieldMap.put(name, fields[i]);
        }
        for (Element fieldEle : element.getChildren()) {
            Field field;
            String name = fieldEle.getAttributeValue("key");
            Element valueEle = (Element)fieldEle.getChildren().get(0);
            Object fieldValue = ctx.fromXML(valueEle);
            if (fieldValue == null || (field = (Field)fieldMap.get(name)) == null) continue;
            if (field.getType().isPrimitive()) {
                this.decodePrimitive(object, field, fieldValue);
                continue;
            }
            try {
                field.set(object, fieldValue);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean accept(String type) {
        return "CommonObject".equals(type) || this.reflectAccept(type);
    }

    private boolean reflectAccept(String type) {
        Class clz = null;
        try {
            clz = SerdeUtils.classForName(type);
            clz.getDeclaredConstructor(new Class[0]);
            return true;
        }
        catch (ClassNotFoundException e) {
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isMultiMatch() {
        return true;
    }

    private static Field[] getFields(Object object) {
        ArrayList<Field> list = new ArrayList<Field>();
        HashSet<String> names = new HashSet<String>();
        Class<?> clz = object.getClass();
        do {
            Field[] fields = clz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (names.contains(fields[i].getName())) continue;
                names.add(fields[i].getName());
                list.add(fields[i]);
            }
        } while ((clz = clz.getSuperclass()) != null && !clz.isInterface());
        return list.toArray(new Field[0]);
    }

    public static void encodeObject(SerdeContext ctx, Object object, Element parent) {
        Field[] fields = CommonObjectSerde.getFields(object);
        for (int i = 0; i < fields.length; ++i) {
            fields[i].setAccessible(true);
            int mod = fields[i].getModifiers();
            if (Modifier.isStatic(mod)) continue;
            Element fieldEle = new Element("Property");
            parent.addContent(fieldEle);
            String name = fields[i].getName();
            Class<?> clz = fields[i].getType();
            fieldEle.setAttribute("key", name);
            if (clz.isPrimitive()) {
                CommonObjectSerde.encodePrimitive(ctx, object, fields[i], fieldEle);
                continue;
            }
            try {
                Object fieldObject = fields[i].get(object);
                fieldEle.addContent(ctx.toXML(fieldObject));
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private static void encodePrimitive(SerdeContext ctx, Object object, Field field, Element fieldEle) {
        Class<?> clz = field.getType();
        try {
            if (clz.equals(Integer.TYPE)) {
                int n = field.getInt(object);
                fieldEle.addContent(ctx.toXML(new PrimitiveHold.IntHold(n)));
            }
            if (clz.equals(Short.TYPE)) {
                short s = field.getShort(object);
                fieldEle.addContent(ctx.toXML(new PrimitiveHold.ShortHold(s)));
            } else if (clz.equals(Long.TYPE)) {
                long l = field.getLong(object);
                fieldEle.addContent(ctx.toXML(new PrimitiveHold.LongHold(l)));
            } else if (clz.equals(Byte.TYPE)) {
                byte by = field.getByte(object);
                fieldEle.addContent(ctx.toXML(new PrimitiveHold.ByteHold(by)));
            } else if (clz.equals(Boolean.TYPE)) {
                boolean bl = field.getBoolean(object);
                fieldEle.addContent(ctx.toXML(new PrimitiveHold.BooleanHold(bl)));
            } else if (clz.equals(Character.TYPE)) {
                char c = field.getChar(object);
                fieldEle.addContent(ctx.toXML(new PrimitiveHold.CharHold(c)));
            } else if (clz.equals(Float.TYPE)) {
                float f = field.getFloat(object);
                fieldEle.addContent(ctx.toXML(new PrimitiveHold.FloatHold(f)));
            } else if (clz.equals(Double.TYPE)) {
                double d = field.getDouble(object);
                fieldEle.addContent(ctx.toXML(new PrimitiveHold.DoubleHold(d)));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    private void decodePrimitive(Object object, Field field, Object fieldValue) {
        Class<?> clz = field.getType();
        try {
            if (clz.equals(Integer.TYPE)) {
                field.setInt(object, ((PrimitiveHold.IntHold)fieldValue).value);
            }
            if (clz.equals(Short.TYPE)) {
                field.setShort(object, ((PrimitiveHold.ShortHold)fieldValue).value);
            } else if (clz.equals(Long.TYPE)) {
                field.setLong(object, ((PrimitiveHold.LongHold)fieldValue).value);
            } else if (clz.equals(Byte.TYPE)) {
                field.setByte(object, ((PrimitiveHold.ByteHold)fieldValue).value);
            } else if (clz.equals(Boolean.TYPE)) {
                field.setBoolean(object, ((PrimitiveHold.BooleanHold)fieldValue).value);
            } else if (clz.equals(Character.TYPE)) {
                field.set(object, Character.valueOf(((PrimitiveHold.CharHold)fieldValue).value));
            } else if (clz.equals(Float.TYPE)) {
                field.setFloat(object, ((PrimitiveHold.FloatHold)fieldValue).value);
            } else if (clz.equals(Double.TYPE)) {
                field.setDouble(object, ((PrimitiveHold.DoubleHold)fieldValue).value);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

