/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder.serde;

import com.kingdee.bos.rpcrecorder.Utils;
import com.kingdee.bos.rpcrecorder.serde.CustomObjectSerde;
import com.kingdee.bos.rpcrecorder.serde.IXmlSerde;
import com.kingdee.bos.rpcrecorder.serde.SerdeUtils;
import com.kingdee.bos.rpcrecorder.serde.XmlSerdeFactory;
import com.kingdee.util.StringUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class CustomObjectSerdeProvider {
    public static void touch() {
        CustomObjectSerdeProvider.loadFromXML();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFromXML() {
        InputStream is = null;
        try {
            is = CustomObjectSerdeProvider.class.getResourceAsStream("SerdeObjectConfigure.xml");
            CustomObjectSerdeProvider.load(is);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        String file = System.getProperty("CustomSerdeConfigureFile");
        if (file == null || file.length() == 0) {
            return;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            CustomObjectSerdeProvider.load(fis);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void load(InputStream is) {
        try {
            SAXBuilder builder = new SAXBuilder();
            Element element = builder.build(is).getRootElement();
            List list = element.getChildren("CustomClass");
            for (Element child : list) {
                String className = child.getAttributeValue("class");
                String argTypes = child.getChild("ArgTypes").getTextNormalize();
                String argValueFields = child.getChild("ArgValueFields").getTextNormalize();
                String setFields = child.getChild("SetFields").getTextNormalize();
                CustomObjectSerdeProvider.process(className, argTypes, argValueFields, setFields);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void process(String className, String strArgTypes, String strArgValueFields, String strSetFields) {
        try {
            Class<?> clazz = Class.forName(className);
            String[] strs = StringUtils.split((String)strArgTypes, (String)",");
            Utils.trim(strs);
            Class[] argTypes = new Class[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                argTypes[i] = SerdeUtils.classForName(strs[i]);
            }
            String[] argValueFields = StringUtils.split((String)strArgValueFields, (String)",");
            Utils.trim(argValueFields);
            String[] setFields = StringUtils.split((String)strSetFields, (String)",");
            Utils.trim(setFields);
            CustomObjectSerdeProvider.register(clazz, argTypes, argValueFields, setFields);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static void register(Class clazz, Class[] argTypes, String[] argValueFields, String[] setFields) {
        XmlSerdeFactory.register(clazz, (IXmlSerde)new CustomObjectSerde(clazz, argTypes, argValueFields, setFields));
    }
}

