/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder.serde;

import com.kingdee.bos.rpcrecorder.RecorderException;
import com.kingdee.bos.rpcrecorder.serde.AbstractXmlSerde;
import com.kingdee.bos.rpcrecorder.serde.IXmlSerde;
import com.kingdee.bos.rpcrecorder.serde.SerdeContext;
import com.kingdee.bos.rpcrecorder.serde.SerdeUtils;
import com.kingdee.bos.rpcrecorder.serde.XmlSerdeFactory;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import org.jdom.Element;

public class JavaBaseObjectSerdeProvider {
    public static void touch() {
    }

    static {
        XmlSerdeFactory.register(String.class, (IXmlSerde)new StringSerde(String.class));
        XmlSerdeFactory.register(BigDecimal.class, (IXmlSerde)new BigDecimalSerde(BigDecimal.class));
        XmlSerdeFactory.register(Date.class, (IXmlSerde)new DateSerde(BigDecimal.class));
        XmlSerdeFactory.register(Locale.class, (IXmlSerde)new LocaleSerde(Locale.class));
    }

    private static class LocaleSerde
    extends AbstractXmlSerde {
        protected LocaleSerde(Class clazz) {
            super(clazz);
        }

        @Override
        public Element toXML(SerdeContext ctx, Class clazz, Object object) throws RecorderException {
            Element element = this.createElement();
            Locale locale = (Locale)object;
            element.setAttribute("country", locale.getCountry());
            element.setAttribute("language", locale.getLanguage());
            element.setAttribute("variant", locale.getVariant());
            return element;
        }

        @Override
        public Object fromXML(SerdeContext ctx, Element element) throws RecorderException {
            String country = element.getAttributeValue("country");
            String language = element.getAttributeValue("language");
            String variant = element.getAttributeValue("variant");
            return new Locale(language, country, variant);
        }

        @Override
        public String getTagName() {
            return "Locale";
        }
    }

    private static class BigDecimalSerde
    extends AbstractXmlSerde {
        protected BigDecimalSerde(Class clazz) {
            super(clazz);
        }

        @Override
        public Element toXML(SerdeContext ctx, Class clazz, Object object) throws RecorderException {
            Element element = this.createElement();
            BigDecimal bd = (BigDecimal)object;
            element.setAttribute("value", "" + bd.doubleValue());
            return element;
        }

        @Override
        public Object fromXML(SerdeContext ctx, Element element) throws RecorderException {
            String s = element.getAttributeValue("value");
            Double d = Double.valueOf(s);
            return BigDecimal.valueOf(d);
        }

        @Override
        public String getTagName() {
            return "BigDecimal";
        }
    }

    private static class DateSerde
    extends AbstractXmlSerde {
        protected DateSerde(Class clazz) {
            super(clazz);
        }

        @Override
        public Element toXML(SerdeContext ctx, Class clazz, Object object) throws RecorderException {
            Element element = this.createElement();
            element.setAttribute("class", object.getClass().getName());
            Date date = (Date)object;
            element.setAttribute("value", "" + date.getTime());
            return element;
        }

        @Override
        public Object fromXML(SerdeContext ctx, Element element) throws RecorderException {
            String s = element.getAttributeValue("value");
            String className = element.getAttributeValue("class");
            Long t = Long.valueOf(s);
            try {
                Class clz = SerdeUtils.classForName(className);
                Constructor ct = clz.getConstructor(Long.TYPE);
                return ct.newInstance(t);
            }
            catch (Exception e) {
                throw new RecorderException(e.getMessage());
            }
        }

        @Override
        public String getTagName() {
            return "Date";
        }

        @Override
        public boolean accept(String type) {
            return this.getTagName().equals(type) || this.reflectAccept(type);
        }

        private boolean reflectAccept(String type) {
            Class clz = null;
            try {
                clz = SerdeUtils.classForName(type);
                clz.getDeclaredConstructor(Long.TYPE);
                return Date.class.isAssignableFrom(clz);
            }
            catch (ClassNotFoundException e) {
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return false;
        }
    }

    private static class StringSerde
    extends AbstractXmlSerde {
        protected StringSerde(Class clazz) {
            super(clazz);
        }

        @Override
        public Element toXML(SerdeContext ctx, Class clazz, Object object) throws RecorderException {
            Element element = this.createElement();
            element.setAttribute("value", (String)object);
            return element;
        }

        @Override
        public Object fromXML(SerdeContext ctx, Element element) throws RecorderException {
            String s = element.getAttributeValue("value");
            return s;
        }

        @Override
        public String getTagName() {
            return "String";
        }
    }
}

