/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder.serde;

import com.kingdee.bos.rpc.impl.RPCResult;
import com.kingdee.bos.rpcrecorder.serde.AbstractXmlSerde;
import com.kingdee.bos.rpcrecorder.serde.SerdeContext;
import org.jdom.Element;

public class RPCResultSerde
extends AbstractXmlSerde {
    public static String version = "2.0";

    protected RPCResultSerde(Class clazz) {
        super(clazz);
    }

    @Override
    public Element toXML(SerdeContext ctx, Class clazz, Object object) {
        Element element = this.createElement();
        element.setAttribute("version", RPCResult.CURRENT_VERSION);
        RPCResult result = (RPCResult)object;
        if (result.requestName != null) {
            element.setAttribute("requestName", result.requestName);
        }
        element.setAttribute("startTime", "" + result.startTime);
        element.setAttribute("endTime", "" + result.endTime);
        element.setAttribute("isException", Boolean.toString(result.isException));
        element.addContent(ctx.toXML(result.value));
        if (result.isException && result.exception != null) {
            Element eleException = new Element("Exception");
            eleException.addContent(ctx.toXML(result.exception));
            element.addContent(eleException);
        }
        return element;
    }

    @Override
    public Object fromXML(SerdeContext ctx, Element element) {
        Element eleException;
        long startTime = Long.parseLong(element.getAttributeValue("startTime"));
        long endTime = Long.parseLong(element.getAttributeValue("endTime"));
        boolean isException = Boolean.parseBoolean(element.getAttributeValue("isException"));
        Object value = ctx.fromXML((Element)element.getChildren().get(0));
        String version = element.getAttributeValue("version");
        Throwable exception = null;
        if (isException && (eleException = element.getChild("Exception")) != null) {
            exception = (Throwable)ctx.fromXML((Element)eleException.getChildren().get(0));
        }
        RPCResult result = new RPCResult(version, startTime, endTime, isException, exception, value);
        result.upgrade(ctx.getContext());
        return result;
    }

    @Override
    public String getTagName() {
        return "RPCResult";
    }
}

