/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder.serde;

import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import sun.tools.javac.Main;

public class SerdeClassGen {
    public static final String PACKAGE = "serde_generate";
    public static final File DEFAULT_ROOT = new File("serde_temporary");
    public static final File DEFAULT_SOURCE_ROOT = new File(DEFAULT_ROOT, "src");
    public static final File DEFAULT_CLASS_ROOT = new File(DEFAULT_ROOT, "classes");

    public Class genClass(String genClassName, String argTypes, String argValuesFields, String setFields) {
        String[] s1 = StringUtils.split((String)argTypes, (String)",");
        String[] s2 = StringUtils.split((String)argValuesFields, (String)",");
        String[] s3 = StringUtils.split((String)setFields, (String)",");
        this.trim(s1);
        this.trim(s2);
        this.trim(s3);
        return this.genClass(genClassName, s1, s2, s3);
    }

    private void trim(String[] ss) {
        for (int i = 0; i < ss.length; ++i) {
            if (ss[i] == null) continue;
            ss[i] = ss[i].trim();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class genClass(String genClassName, String[] argTypes, String[] argValueFields, String[] setFields) {
        InputStream is = null;
        InputStreamReader reader = null;
        try {
            String line;
            is = this.getClass().getResourceAsStream("serdeclass.template");
            reader = new InputStreamReader(is, "UTF-8");
            BufferedReader br = new BufferedReader(reader);
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\r\n");
            }
            String content = sb.toString();
            content = StringUtils.replace((String)content, (String)"<GenClass>", (String)genClassName);
            content = StringUtils.replace((String)content, (String)"<ArgTypes>", (String)this.genArgTypes(argTypes));
            content = StringUtils.replace((String)content, (String)"<ArgValueFields>", (String)this.genStrArray(argValueFields));
            content = StringUtils.replace((String)content, (String)"<SetFields>", (String)this.genStrArray(setFields));
            String srcFileName = this.getSrcFileName(genClassName);
            String classFileName = this.getClassFileName(genClassName);
            File srcFile = new File(srcFileName);
            File classFile = new File(classFileName);
            SerdeClassGen.mkdirs(srcFile.getParentFile());
            SerdeClassGen.mkdirs(classFile.getParentFile());
            String[] args = new String[]{"-d", classFile.getParentFile().getParentFile().getAbsolutePath(), srcFileName};
            this.writeFile(content, srcFileName);
            if (!new Main((OutputStream)System.out, this.getClass().getName()).compile(args)) {
                throw new Exception(srcFileName + " compile failed.");
            }
            if (!classFile.exists()) {
                throw new FileNotFoundException(classFile.getAbsolutePath());
            }
            byte[] bytes = this.readClass(classFileName);
            Class clazz = new DynamicClassLoader(this.getClass().getClassLoader()).loadClass(null, bytes);
            return clazz;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String content, String srcFileName) throws IOException {
        FileWriter fw = null;
        try {
            fw = new FileWriter(srcFileName);
            PrintWriter pw = new PrintWriter(fw);
            pw.println(content);
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readClass(String classFileName) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(classFileName);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bs = new byte[1024];
            int len = -1;
            while ((len = fis.read(bs)) > 0) {
                baos.write(bs, 0, len);
            }
            baos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    private String getSrcFileName(String genClassName) {
        return DEFAULT_SOURCE_ROOT + "/" + genClassName + ".java";
    }

    private String getClassFileName(String genClassName) {
        return DEFAULT_CLASS_ROOT + "/" + PACKAGE + "/" + genClassName + ".class";
    }

    private String genStrArray(String[] strs) {
        String ret = "";
        for (int i = 0; i < strs.length; ++i) {
            ret = ret + "\"" + strs[i] + "\"";
            if (i < 0 || i >= strs.length - 1) continue;
            ret = ret + ",";
        }
        return ret;
    }

    private String genArgTypes(String[] argTypes) {
        String ret = "";
        for (int i = 0; i < argTypes.length; ++i) {
            ret = argTypes[i].endsWith(".class") ? ret + argTypes[i] : ret + argTypes[i] + ".class";
            if (i < 0 || i >= argTypes.length - 1) continue;
            ret = ret + ",";
        }
        return ret;
    }

    private static void mkdirs(File path) {
        try {
            path.mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws ClassNotFoundException {
        String argTypes = "int,String";
        String argValueFields = "i,s";
        String setFields = "i,s";
        String className = "serde_" + System.currentTimeMillis();
        Class<?> clazz = Class.forName("[Ljava.lang.Object;");
        clazz.toString();
    }

    private static class DynamicClassLoader
    extends ClassLoader {
        DynamicClassLoader(ClassLoader cl) {
            super(cl);
        }

        Class loadClass(String name, byte[] data) {
            Class<?> cls = this.defineClass(name, data, 0, data.length, Object.class.getProtectionDomain());
            this.resolveClass(cls);
            return cls;
        }
    }
}

