/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder.serde;

import com.kingdee.bos.rpcrecorder.Context;
import com.kingdee.bos.rpcrecorder.Policy;
import com.kingdee.bos.rpcrecorder.RecorderException;
import com.kingdee.bos.rpcrecorder.serde.CommonObjectSerde;
import com.kingdee.bos.rpcrecorder.serde.GlobalCache;
import com.kingdee.bos.rpcrecorder.serde.IXmlSerde;
import com.kingdee.bos.rpcrecorder.serde.ObjectByVariableSerde;
import com.kingdee.bos.rpcrecorder.serde.RefSerde;
import com.kingdee.bos.rpcrecorder.serde.SerdeUtils;
import com.kingdee.bos.rpcrecorder.serde.UnknownObjectSerde;
import com.kingdee.bos.rpcrecorder.serde.XmlSerdeFactory;
import java.util.ArrayList;
import java.util.HashMap;
import org.jdom.Element;

public class SerdeContext {
    private HashMap identityMap = new HashMap();
    private ArrayList unsupportedClass = new ArrayList();
    private Context ctx;
    private String version = "1.0";
    private boolean objectChanged = false;

    public SerdeContext(Context ctx) {
        this.ctx = ctx;
    }

    public Context getContext() {
        return this.ctx;
    }

    public String getVersion() {
        return this.version;
    }

    public void setObjectChanged() {
        this.objectChanged = true;
    }

    public boolean isObjectChanged() {
        return this.objectChanged;
    }

    public Element toXML(Object object) {
        if (object == null) {
            return new Element("Null");
        }
        Class<?> clazz = object.getClass();
        String identity = SerdeUtils.identityId(object);
        if (this.identityMap.containsKey(identity)) {
            return RefSerde.instance.toXML(this, clazz, object);
        }
        IXmlSerde serde = XmlSerdeFactory.get(clazz);
        if (serde == null) {
            if (CommonObjectSerde.instance.accept(clazz.getName())) {
                return CommonObjectSerde.instance.toXML(this, clazz, object);
            }
            this.unsupportedClass.add(clazz.getName());
            Element ele = this.tryConvertion(clazz, object);
            if (ele != null) {
                return ele;
            }
            return UnknownObjectSerde.instance.toXML(this, clazz, object);
        }
        return serde.toXML(this, clazz, object);
    }

    public void markIdentityObject(String id, Object object) {
        this.identityMap.put(id, object);
    }

    public void markIdentityObject(Object object) {
        this.identityMap.put(SerdeUtils.identityId(object), object);
    }

    public Object getShardObject(String id) {
        return this.identityMap.get(id);
    }

    public Object fromXML(Element element) {
        long cost;
        Object o;
        boolean hasCommand;
        boolean hasVariable = "true".equals(element.getAttributeValue("_hasVariable_"));
        boolean bl = hasCommand = element.getAttribute("_command_") != null;
        if (!(hasVariable || hasCommand || this.objectChanged || (o = GlobalCache.globalElementToObjectCache.get(element)) == null)) {
            return o;
        }
        String name = element.getName();
        if (name.equals("Null")) {
            return null;
        }
        String id = element.getAttributeValue("id");
        Object value = null;
        IXmlSerde serde = XmlSerdeFactory.get(name);
        if (serde == null) {
            if (RefSerde.instance.accept(name)) {
                serde = RefSerde.instance;
            } else if (ObjectByVariableSerde.instance.accept(name)) {
                serde = ObjectByVariableSerde.instance;
            } else if (CommonObjectSerde.instance.accept(name)) {
                serde = CommonObjectSerde.instance;
            } else if (UnknownObjectSerde.instance.accept(name)) {
                serde = UnknownObjectSerde.instance;
            } else {
                throw new RecorderException("Unsupported Element type:" + name);
            }
        }
        boolean logOff = Policy.isOff(this.ctx, Policy.POLICY_LOGRPC);
        long start = System.currentTimeMillis();
        value = serde.fromXML(this, element);
        if (!logOff && (cost = System.currentTimeMillis() - start) > 100L) {
            System.out.println("Serde fromXML cost " + cost + "ms. the element name is " + name + ",id is " + id);
        }
        if (id != null && value != null) {
            this.markIdentityObject(id, value);
        }
        if (!(hasVariable || hasCommand || this.objectChanged)) {
            GlobalCache.globalElementToObjectCache.put(element, value);
            for (Element child : element.getChildren()) {
                GlobalCache.globalElementToObjectCache.remove(child);
            }
        }
        return value;
    }

    public Element tryConvertion(Class clazz, Object object) {
        return null;
    }

    public void clear() {
        this.identityMap.clear();
    }
}

