/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcrecorder.serde;

import com.kingdee.bos.rpc.impl.RPCRequest;
import com.kingdee.bos.rpc.impl.RPCResult;
import com.kingdee.bos.rpcrecorder.command.result.AllRPCResult;
import com.kingdee.bos.rpcrecorder.serde.AllRPCResultSerde;
import com.kingdee.bos.rpcrecorder.serde.ArraySerdeProvider;
import com.kingdee.bos.rpcrecorder.serde.CustomObjectSerdeProvider;
import com.kingdee.bos.rpcrecorder.serde.IXmlSerde;
import com.kingdee.bos.rpcrecorder.serde.JavaBaseObjectSerdeProvider;
import com.kingdee.bos.rpcrecorder.serde.PrimitiveSerdeProvider;
import com.kingdee.bos.rpcrecorder.serde.RPCRequestSerde;
import com.kingdee.bos.rpcrecorder.serde.RPCResultSerde;
import com.kingdee.bos.rpcrecorder.serde.ReflectSerdeProvider;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class XmlSerdeFactory {
    private static Logger logger = Logger.getLogger(XmlSerdeFactory.class);
    private static HashMap map = new HashMap();

    public static void registerProvider(String className) {
        try {
            Class<?> clz = Class.forName(className);
            Method method = clz.getMethod("touch", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info((Object)("Can't register serde provider " + className + ",exception is:" + e));
        }
    }

    public static void register(Class clazz, IXmlSerde xmlser) {
        map.put(clazz.getName(), xmlser);
    }

    public static void register(String type, IXmlSerde xmlser) {
        map.put(type, xmlser);
    }

    public static IXmlSerde get(Class clazz) {
        return XmlSerdeFactory.get(clazz.getName());
    }

    public static IXmlSerde get(String clazz) {
        IXmlSerde serde2 = (IXmlSerde)map.get(clazz);
        if (serde2 != null) {
            return serde2;
        }
        for (IXmlSerde serde2 : map.values()) {
            if (!serde2.accept(clazz)) continue;
            map.put(clazz, serde2);
            return serde2;
        }
        return null;
    }

    static {
        XmlSerdeFactory.register(RPCRequest.class, (IXmlSerde)new RPCRequestSerde(RPCRequest.class));
        XmlSerdeFactory.register(RPCResult.class, (IXmlSerde)new RPCResultSerde(RPCResult.class));
        XmlSerdeFactory.register(AllRPCResult.class, (IXmlSerde)new AllRPCResultSerde(AllRPCResult.class));
        PrimitiveSerdeProvider.touch();
        JavaBaseObjectSerdeProvider.touch();
        ArraySerdeProvider.touch();
        ReflectSerdeProvider.touch();
        CustomObjectSerdeProvider.touch();
        XmlSerdeFactory.registerProvider("com.kingdee.eas.client.recorder.serde.BOSSerdeProvider");
        XmlSerdeFactory.registerProvider("com.kingdee.eas.client.recorder.serde.EASSerdeProvider");
        XmlSerdeFactory.registerProvider("com.kingdee.eas.client.recorder.serde.SCMSerdeProvider");
    }
}

