/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcwrapper;

import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.orm.loadbalance.BalanceConfig;
import com.kingdee.bos.rpc.io.loadbalance.LoadBalanceLocalizer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import org.apache.log4j.Logger;

public class LoadBalanceLocalizerMain {
    private static final Logger logger = Logger.getLogger(LoadBalanceLocalizerMain.class);
    private static final String CCL_PREFIX = "ccl.";

    private static LoadBalanceLocalizer init() {
        LoadBalanceLocalizer lbl = new LoadBalanceLocalizer(ServerManager.getConfig((String)"ccl").tcpConnectionPort, ServerManager.getConfig((String)"ccl").sslConnectionPort);
        lbl.setDynamicFactor(ServerManager.getConfig((String)"ccl").dynamicFactor);
        BalanceConfig[] cclServers = ORMRPConfig.getCclServers();
        if (ServerManager.getConfig((String)"ccl").dynamicFactor) {
            for (int i = 0; i < cclServers.length; ++i) {
                BalanceConfig bc = cclServers[i];
                String capability = bc.getServerProperties().getProperty("capability", "1");
                String dynamicEffect = bc.getServerProperties().getProperty("dynamicEffect", String.valueOf(0.2f));
                String rmiPort = bc.getServerProperties().getProperty("rmiPort", String.valueOf(11020));
                lbl.registerServer(bc.getUrl(), Float.parseFloat(capability), Float.parseFloat(dynamicEffect), Integer.parseInt(rmiPort));
            }
        } else {
            for (int i = 0; i < cclServers.length; ++i) {
                BalanceConfig bc = cclServers[i];
                lbl.registerServer(bc.getUrl(), Float.parseFloat(bc.getServerProperties().getProperty("capability", "1")));
            }
        }
        return lbl;
    }

    public static void main(String[] args) {
        try {
            LoadBalanceLocalizer lbl = LoadBalanceLocalizerMain.init();
            lbl.start();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }
}

