/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcwrapper;

import com.kingdee.bos.rpc.RPCConfig;
import com.kingdee.bos.rpc.RPCManagement;
import com.kingdee.bos.rpc.impl.IOUtil;
import com.kingdee.bos.rpc.io.loadbalance.LBManage;
import com.kingdee.bos.rpcwrapper.ILoadBalanceServer;
import com.kingdee.bos.rpcwrapper.ServerManager;
import java.net.BindException;
import java.util.Map;
import javax.management.Notification;
import org.apache.log4j.Logger;

public class LoadBalanceServerMain {
    private static Logger logger = Logger.getLogger(LoadBalanceServerMain.class);
    public static ILoadBalanceServer server;

    public static void main(String[] args) {
        try {
            IOUtil.initLog4j();
            logger.info((Object)"Start LoadBalanceServerMain");
            server = ServerManager.getInstance().newTCPLoadBalanceServer();
            server.setDaemon(false);
            server.start();
            Map configs = com.kingdee.bos.rpc.io.server.ServerManager.getConfigs();
            for (Map.Entry entry : configs.entrySet()) {
                RPCConfig config = (RPCConfig)entry.getValue();
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    logger.info((Object)"Jvm is shutdown! Notify from LoadBalanceServerMain!");
                    try {
                        Notification nf = new Notification(LBManage.JVM_IS_SHUTDOWN.getNotifTypes()[0], LoadBalanceServerMain.class.getName(), LBManage.getSequenceNumber(), System.currentTimeMillis(), LBManage.JVM_IS_SHUTDOWN.getDescription());
                        RPCManagement.MBEAN_SERVER.invoke(RPCManagement.mbeanObjectName, "sendNotification", new Notification[]{nf}, null);
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex, (Throwable)ex);
                    }
                }
            });
            logger.info((Object)"lb broadcast start.");
            try {
                server.broadcast();
            }
            catch (Throwable th) {
                logger.warn((Object)th, th);
            }
            logger.info((Object)"lb broadcast end.");
        }
        catch (BindException t) {
            logger.error((Object)t, (Throwable)t);
            System.exit(0);
        }
        catch (Throwable t) {
            logger.error((Object)t, t);
            System.exit(0);
        }
    }
}

