/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcwrapper;

import com.kingdee.bos.orm.IEventContainer;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.rmi.IRMISession;
import com.kingdee.bos.orm.service.IServiceSession;
import com.kingdee.bos.orm.service.IServiceSessionEvent;
import com.kingdee.bos.rpcwrapper.IServerSession;
import com.kingdee.bos.rpcwrapper.IServerSessionListener;
import com.kingdee.bos.rpcwrapper.ISession;
import com.kingdee.bos.rpcwrapper.RMISessionListenerWrapper;
import java.util.HashMap;

public class RMISessionWrapper
implements ISession,
IServerSession {
    private static HashMap rmiSessionListenerWrapperTable = new HashMap();
    private final IRMISession session;

    RMISessionWrapper(IRMISession session) {
        this.session = session;
    }

    public static RMISessionWrapper getInstance(IRMISession session) {
        return new RMISessionWrapper(session);
    }

    @Override
    public Object getDelegate() {
        return this.session;
    }

    @Override
    public IORMModel createObject(String objectName, Class model) {
        return this.session.createObject(objectName, model);
    }

    @Override
    public IORMModel createObject(String objectName, Class model, Class[] initArgTypes, Object[] initArgs) {
        return this.session.createObject(objectName, model, initArgTypes, initArgs);
    }

    @Override
    public void put(Object key, Object value) {
        this.session.put(key, value);
    }

    @Override
    public Object get(Object key) {
        return this.session.get(key);
    }

    @Override
    public void addEventListener(IServerSessionListener listener) {
        RMISessionListenerWrapper wrapper = new RMISessionListenerWrapper(listener);
        rmiSessionListenerWrapperTable.put(listener, wrapper);
        this.getRMIEventContainer().addEventListener(IServiceSessionEvent.class, wrapper);
    }

    @Override
    public void removeEventListener(IServerSessionListener listener) {
        RMISessionListenerWrapper warrper = (RMISessionListenerWrapper)rmiSessionListenerWrapperTable.get(listener);
        if (warrper != null) {
            this.getRMIEventContainer().removeEventListener(IServiceSessionEvent.class, warrper);
        }
    }

    private final IEventContainer getRMIEventContainer() {
        IServiceSession iss = this.session.getServiceSession();
        return (IEventContainer)iss.queryInterface(IEventContainer.class);
    }

    @Override
    public void close() {
        if (this.session != null) {
            this.session.close();
        }
    }

    @Override
    public boolean isClosed() {
        if (this.session != null) {
            return this.session.isClosed();
        }
        return true;
    }
}

