/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcwrapper;

import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.RPCSession;
import com.kingdee.bos.rpc_availability.AttemptException;
import com.kingdee.bos.rpc_availability.Attempter;
import com.kingdee.bos.rpc_availability.FinderConfiguratonException;
import com.kingdee.bos.rpc_availability.ServerFacede;
import com.kingdee.bos.rpc_availability.ServerFinder;
import com.kingdee.bos.rpc_availability.urllist.UrlServerListRepresent;
import com.kingdee.bos.rpcwrapper.IRPCEngine;
import com.kingdee.bos.rpcwrapper.ISession;
import com.kingdee.bos.rpcwrapper.RPCSessionWrapper;
import org.apache.log4j.Logger;

public class RPCEngineWrapper
implements IRPCEngine {
    private static final Logger logger = Logger.getLogger(RPCEngineWrapper.class);
    String url;

    RPCEngineWrapper(String url) {
        this.url = url;
    }

    @Override
    public ISession createSession() {
        if (!ORMRPConfig.isEnableServerFinder()) {
            return new RPCSessionWrapper(RPCEngine.createSession(this.url));
        }
        ServerFinder serverFinder = null;
        try {
            serverFinder = ServerFinder.getInstance();
            RPCSession session = (RPCSession)serverFinder.tryServerAttempt(UrlServerListRepresent.getServerFacedeList(this.url), new CreateRPCSession_Attempter(), new Class[0], new Object[0]);
            return new RPCSessionWrapper(session);
        }
        catch (FinderConfiguratonException e1) {
            logger.debug((Object)"not config finder or config error,ingnore");
            return new RPCSessionWrapper(RPCEngine.createSession(this.url));
        }
    }

    @Override
    public IORMModel createObject(String objectName, Class model) {
        if (!ORMRPConfig.isEnableServerFinder()) {
            try {
                return (IORMModel)RPCEngine.createRemoteObject(this.url, objectName, model);
            }
            catch (RPCException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RPCException(e);
            }
        }
        ServerFinder serverFinder = null;
        try {
            serverFinder = ServerFinder.getInstance();
            IORMModel ormModel = (IORMModel)serverFinder.tryServerAttempt(UrlServerListRepresent.getServerFacedeList(this.url), new CreateRemoteObject_Attempter(), new Class[]{String.class, Class.class}, new Object[]{objectName, model});
            return ormModel;
        }
        catch (FinderConfiguratonException e1) {
            logger.debug((Object)"not config finder or config error,ingnore");
            try {
                return (IORMModel)RPCEngine.createRemoteObject(this.url, objectName, model);
            }
            catch (RPCException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RPCException(e);
            }
        }
    }

    @Override
    public IORMModel createObject(String objectName, Class model, Class[] initArgTypes, Object[] initArgs) {
        if (!ORMRPConfig.isEnableServerFinder()) {
            try {
                return (IORMModel)RPCEngine.createRemoteObject(this.url, objectName, model, initArgTypes, initArgs);
            }
            catch (RPCException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RPCException(e);
            }
        }
        ServerFinder serverFinder = null;
        try {
            serverFinder = ServerFinder.getInstance();
            IORMModel ormModel = (IORMModel)serverFinder.tryServerAttempt(UrlServerListRepresent.getServerFacedeList(this.url), new CreateRemoteObject1_Attempter(), new Class[]{String.class, Class.class, Class[].class, Object[].class}, new Object[]{objectName, model, initArgTypes, initArgs});
            return ormModel;
        }
        catch (FinderConfiguratonException e1) {
            logger.debug((Object)"not config finder or config error,ingnore");
            try {
                return (IORMModel)RPCEngine.createRemoteObject(this.url, objectName, model, initArgTypes, initArgs);
            }
            catch (RPCException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RPCException(e);
            }
        }
    }

    private static class CreateRemoteObject1_Attempter
    implements Attempter {
        private CreateRemoteObject1_Attempter() {
        }

        @Override
        public Object tryIt(ServerFacede server, Class[] argTypes, Object[] args) throws Exception {
            if (argTypes.length == 4) {
                String objectName = (String)args[0];
                Class model = (Class)args[1];
                Class[] initArgTypes = (Class[])args[2];
                Object[] initArgs = (Object[])args[3];
                return (IORMModel)RPCEngine.createRemoteObject(server.getIdentify(), objectName, model, initArgTypes, initArgs);
            }
            throw new AttemptException("CreateRPCSession_Attempter args mismatch!");
        }
    }

    private static class CreateRemoteObject_Attempter
    implements Attempter {
        private CreateRemoteObject_Attempter() {
        }

        @Override
        public Object tryIt(ServerFacede server, Class[] argTypes, Object[] args) throws Exception {
            if (argTypes.length == 2) {
                String objectName = (String)args[0];
                Class model = (Class)args[1];
                return (IORMModel)RPCEngine.createRemoteObject(server.getIdentify(), objectName, model);
            }
            throw new AttemptException("CreateRPCSession_Attempter args mismatch!");
        }
    }

    private static class CreateRPCSession_Attempter
    implements Attempter {
        private CreateRPCSession_Attempter() {
        }

        @Override
        public Object tryIt(ServerFacede server, Class[] argTypes, Object[] args) throws Exception {
            if (argTypes.length == 0) {
                return RPCEngine.createSession(server.getIdentify());
            }
            throw new AttemptException("CreateRPCSession_Attempter args mismatch!");
        }
    }
}

