/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcwrapper;

import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.orm.impl.server.TCPServer;
import com.kingdee.bos.orm.loadbalance.BalanceConfig;
import com.kingdee.bos.orm.loadbalance.TCPLoadBalanceServer;
import com.kingdee.bos.rpc.RPCManagement;
import com.kingdee.bos.rpc.RPCUtil;
import com.kingdee.bos.rpc.io.ConnectionFactory;
import com.kingdee.bos.rpc.io.loadbalance.LBManage;
import com.kingdee.bos.rpc.io.loadbalance.LoadBalance;
import com.kingdee.bos.rpc.io.server.NIOServer;
import com.kingdee.bos.rpc.io.server.NettyServer;
import com.kingdee.bos.rpc.io.server.SSLTCPServer;
import com.kingdee.bos.rpcwrapper.IHttpServer;
import com.kingdee.bos.rpcwrapper.ILoadBalanceServer;
import com.kingdee.bos.rpcwrapper.IServer;
import com.kingdee.bos.rpcwrapper.RMIHttpServer;
import com.kingdee.bos.rpcwrapper.RPCHttpServer;
import java.io.IOException;
import java.util.Map;
import javax.management.Notification;
import org.apache.log4j.Logger;

public class ServerManager {
    private static ServerManager manager = new ServerManager();
    private static Logger logger = Logger.getLogger(ServerManager.class);

    private ServerManager() {
    }

    public static ServerManager getInstance() {
        return manager;
    }

    public boolean isLoadBalanceMode() {
        return ORMRPConfig.isBalanceMode();
    }

    public boolean supportSSL() {
        return ORMRPConfig.supportSSL();
    }

    public int getDefaultSSLPort() {
        return ORMRPConfig.getSSLConnectionPort();
    }

    public IServer newTCPServer() throws IOException {
        return this.newTCPServer(this.getDefaultTCPPort());
    }

    public int getDefaultTCPPort() {
        return com.kingdee.bos.rpc.io.server.ServerManager.getDefaultConfig().tcpConnectionPort;
    }

    public IServer newTCPServer(int bindPort) throws IOException {
        if (ORMRPConfig.isUseOldRpc()) {
            return new TCPServerWrapper(new TCPServer(bindPort));
        }
        if (ORMRPConfig.isNIO()) {
            return new RPCNIOServerWrapper(new NIOServer(bindPort));
        }
        if (ORMRPConfig.isNetty()) {
            return new RPCNtyServerWrapper(new NettyServer(bindPort));
        }
        return new RPCTCPServerWrapper(new com.kingdee.bos.rpc.io.server.TCPServer(bindPort));
    }

    public IServer newTCPServer(String serverName, int bindPort) throws IOException {
        if (ORMRPConfig.isUseOldRpc()) {
            return new TCPServerWrapper(new TCPServer(bindPort));
        }
        if (ORMRPConfig.isNIO()) {
            return new RPCNIOServerWrapper(new NIOServer(bindPort));
        }
        return new RPCTCPServerWrapper(new com.kingdee.bos.rpc.io.server.TCPServer(serverName, bindPort));
    }

    public IServer newSSLServer() throws Exception {
        return this.newSSLServer(this.getDefaultSSLPort());
    }

    public IServer newSSLServer(String serverName) throws Exception {
        return this.newSSLServer(serverName, this.getDefaultSSLPort());
    }

    public IServer newSSLServer(int bindPort) throws Exception {
        return new RPCTCPServerWrapper(new SSLTCPServer(bindPort));
    }

    public IServer newSSLServer(String serverName, int bindPort) throws Exception {
        return new RPCTCPServerWrapper(new SSLTCPServer(serverName, bindPort));
    }

    public ILoadBalanceServer newTCPLoadBalanceServer() throws Exception {
        ORMRPConfig.loadConfig("loadbalance");
        com.kingdee.bos.rpc.io.server.ServerManager.getConfig((String)"loadbalance").standby = true;
        return this.newTCPLoadBalanceServer(com.kingdee.bos.rpc.io.server.ServerManager.getConfig((String)"loadbalance").tcpConnectionPort);
    }

    public ILoadBalanceServer newTCPLoadBalanceServer(int bindPort) throws Exception {
        ILoadBalanceServer lb = null;
        if (ORMRPConfig.isUseOldRpc()) {
            lb = new LBServerWrapper(new TCPLoadBalanceServer(bindPort));
        } else {
            if (ORMRPConfig.isNIO()) {
                lb = new RPCNIOLBServerWrapper(ORMRPConfig.getBalanceServers(), bindPort);
            }
            if (ORMRPConfig.isNetty()) {
                return new RPCNettyLBServerWrapper(ORMRPConfig.getBalanceServers(), bindPort);
            }
            lb = new RPCLBServerWrapper(ORMRPConfig.getBalanceServers(), bindPort, com.kingdee.bos.rpc.io.server.ServerManager.getConfig((String)"loadbalance").supportSSL, this.getDefaultSSLPort());
        }
        RPCManagement.registerMBean();
        return lb;
    }

    public IHttpServer getHttpServer() {
        if (ORMRPConfig.isUseOldRpc()) {
            return new RMIHttpServer();
        }
        return new RPCHttpServer();
    }

    static LoadBalance newLoadBalance(BalanceConfig[] lbs) {
        LoadBalance lb = new LoadBalance("default");
        for (int i = 0; i < lbs.length; ++i) {
            Float f = Float.valueOf(lbs[i].getServerProperties().getProperty("capability", "1f"));
            String dynamicEffect = lbs[i].getServerProperties().getProperty("dynamicEffect", String.valueOf(0.2f));
            String sockTimeout = lbs[i].getServerProperties().getProperty("sockTimeout", String.valueOf(10000));
            String urlAndstandbyUrl = lbs[i].getUrl();
            String[] sa = urlAndstandbyUrl.split("\\|");
            String name = lbs[i].getServerProperties().getProperty("name");
            if (sa.length == 1) {
                lb.registerServer(sa[0], f.floatValue(), null, Float.parseFloat(dynamicEffect), (int)RPCUtil.toMs(sockTimeout), name);
                continue;
            }
            if (sa.length <= 1) continue;
            lb.registerServer(sa[0], f.floatValue(), sa[1], Float.parseFloat(dynamicEffect), (int)RPCUtil.toMs(sockTimeout), name);
        }
        com.kingdee.bos.rpc.io.ServerManager.registerServer(lb);
        return lb;
    }

    private static class RPCNtyServerWrapper
    implements IServer {
        private final NettyServer server;

        public RPCNtyServerWrapper(NettyServer server) {
            this.server = server;
        }

        @Override
        public void shutdown() {
            this.server.shutdown();
        }

        @Override
        public void start() {
            this.server.start();
        }
    }

    private static class RPCNIOServerWrapper
    implements IServer {
        private final NIOServer server;

        public RPCNIOServerWrapper(NIOServer server) {
            this.server = server;
        }

        @Override
        public void shutdown() {
            this.server.shutdown();
        }

        @Override
        public void start() {
            this.server.start();
        }
    }

    private static class RPCTCPServerWrapper
    implements IServer {
        private final com.kingdee.bos.rpc.io.server.TCPServer server;

        public RPCTCPServerWrapper(com.kingdee.bos.rpc.io.server.TCPServer server) {
            this.server = server;
        }

        @Override
        public void shutdown() {
            this.server.shutdown();
        }

        @Override
        public void start() {
            this.server.start();
        }
    }

    private static class TCPServerWrapper
    implements IServer {
        private final TCPServer server;

        public TCPServerWrapper(TCPServer server) {
            this.server = server;
        }

        @Override
        public void shutdown() {
            this.server.shutdown();
        }

        @Override
        public void start() {
            this.server.start();
        }
    }

    private static class RPCNettyLBServerWrapper
    implements ILoadBalanceServer {
        private LoadBalance lb;
        private final NettyServer server;

        public RPCNettyLBServerWrapper(BalanceConfig[] lbs, int port) throws IOException {
            this.lb = ServerManager.newLoadBalance(lbs);
            this.server = new NettyServer("loadbalance", port, "server://default");
            this.server.removeHealthDegree();
            RPCManagement.registerMBean();
        }

        @Override
        public void shutdown() {
            this.server.shutdown();
            this.sendNotification();
        }

        private void sendNotification() {
            try {
                Notification nf = new Notification(LBManage.LB_IS_SHUTDOWN.getNotifTypes()[0], RPCNIOLBServerWrapper.class.getName(), LBManage.getSequenceNumber(), System.currentTimeMillis(), LBManage.LB_IS_SHUTDOWN.getDescription());
                RPCManagement.MBEAN_SERVER.invoke(RPCManagement.mbeanObjectName, "sendNotification", new Notification[]{nf}, null);
            }
            catch (Exception ex) {
                logger.error((Object)ex, (Throwable)ex);
            }
        }

        @Override
        public void start() {
            this.server.start();
        }

        @Override
        public void setDaemon(boolean daemon) {
            this.server.setDaemon(daemon);
        }

        @Override
        public Map statistics() {
            ConnectionFactory defaultServer = com.kingdee.bos.rpc.io.ServerManager.getServer("default");
            if (defaultServer instanceof LoadBalance) {
                LoadBalance lb = (LoadBalance)defaultServer;
                return lb.statistics();
            }
            return null;
        }

        @Override
        public void registerServer(String url, float performanceFactor) {
            this.lb.registerServer(url, performanceFactor);
        }

        @Override
        public void unregisterServer(String url) {
            this.lb.unregisterServer(url);
        }

        @Override
        public void broadcast() {
            this.lb.broadcast();
        }
    }

    private static class RPCNIOLBServerWrapper
    implements ILoadBalanceServer {
        private LoadBalance lb;
        private final NIOServer tcpServer;

        public RPCNIOLBServerWrapper(BalanceConfig[] lbs, int port) throws IOException {
            this.lb = ServerManager.newLoadBalance(lbs);
            this.tcpServer = new NIOServer("nio", port, "server://default");
            this.tcpServer.removeHealthDegree();
            RPCManagement.registerMBean();
        }

        @Override
        public void shutdown() {
            this.tcpServer.shutdown();
            this.sendNotification();
        }

        private void sendNotification() {
            try {
                Notification nf = new Notification(LBManage.LB_IS_SHUTDOWN.getNotifTypes()[0], RPCNIOLBServerWrapper.class.getName(), LBManage.getSequenceNumber(), System.currentTimeMillis(), LBManage.LB_IS_SHUTDOWN.getDescription());
                RPCManagement.MBEAN_SERVER.invoke(RPCManagement.mbeanObjectName, "sendNotification", new Notification[]{nf}, null);
            }
            catch (Exception ex) {
                logger.error((Object)ex, (Throwable)ex);
            }
        }

        @Override
        public void start() {
            this.tcpServer.start();
        }

        @Override
        public void setDaemon(boolean daemon) {
            this.tcpServer.setDaemon(daemon);
        }

        @Override
        public Map statistics() {
            ConnectionFactory defaultServer = com.kingdee.bos.rpc.io.ServerManager.getServer("default");
            if (defaultServer instanceof LoadBalance) {
                LoadBalance lb = (LoadBalance)defaultServer;
                return lb.statistics();
            }
            return null;
        }

        @Override
        public void registerServer(String url, float performanceFactor) {
            this.lb.registerServer(url, performanceFactor);
        }

        @Override
        public void unregisterServer(String url) {
            this.lb.unregisterServer(url);
        }

        @Override
        public void broadcast() {
            this.lb.broadcast();
        }
    }

    private static class RPCLBServerWrapper
    implements ILoadBalanceServer {
        private LoadBalance lb;
        private final com.kingdee.bos.rpc.io.server.TCPServer tcpServer;
        private final com.kingdee.bos.rpc.io.server.TCPServer sslServer;

        public RPCLBServerWrapper(BalanceConfig[] lbs, int port) throws Exception {
            this(lbs, port, false, 0);
        }

        public RPCLBServerWrapper(BalanceConfig[] lbs, int tcpPort, boolean supportSSL, int sslPort) throws Exception {
            this.lb = ServerManager.newLoadBalance(lbs);
            this.tcpServer = new com.kingdee.bos.rpc.io.server.TCPServer("loadbalance", tcpPort, "server://default");
            if (supportSSL) {
                ORMRPConfig.loadConfig("ssl");
                com.kingdee.bos.rpc.io.server.ServerManager.getConfig((String)"ssl").standby = true;
                this.sslServer = new SSLTCPServer("ssl", sslPort, "server://default");
            } else {
                this.sslServer = null;
            }
        }

        @Override
        public void shutdown() {
            this.tcpServer.shutdown();
            if (this.sslServer != null) {
                this.sslServer.shutdown();
            }
            this.sendNotification();
        }

        private void sendNotification() {
            try {
                Notification nf = new Notification(LBManage.LB_IS_SHUTDOWN.getNotifTypes()[0], RPCLBServerWrapper.class.getName(), LBManage.getSequenceNumber(), System.currentTimeMillis(), LBManage.LB_IS_SHUTDOWN.getDescription());
                RPCManagement.MBEAN_SERVER.invoke(RPCManagement.mbeanObjectName, "sendNotification", new Notification[]{nf}, null);
            }
            catch (Exception ex) {
                logger.error((Object)ex, (Throwable)ex);
            }
        }

        @Override
        public void start() {
            this.tcpServer.start();
            if (this.sslServer != null) {
                this.sslServer.start();
            }
        }

        @Override
        public void setDaemon(boolean daemon) {
            this.tcpServer.setDaemon(daemon);
            if (this.sslServer != null) {
                this.sslServer.setDaemon(daemon);
            }
        }

        @Override
        public Map statistics() {
            ConnectionFactory defaultServer = com.kingdee.bos.rpc.io.ServerManager.getServer("default");
            if (defaultServer instanceof LoadBalance) {
                LoadBalance lb = (LoadBalance)defaultServer;
                return lb.statistics();
            }
            return null;
        }

        @Override
        public void registerServer(String url, float performanceFactor) {
            this.lb.registerServer(url, performanceFactor);
        }

        @Override
        public void unregisterServer(String url) {
            this.lb.unregisterServer(url);
        }

        @Override
        public void broadcast() {
            this.lb.broadcast();
        }
    }

    private static class LBServerWrapper
    implements ILoadBalanceServer {
        private final TCPLoadBalanceServer lbs;

        public LBServerWrapper(TCPLoadBalanceServer lbs) {
            this.lbs = lbs;
        }

        @Override
        public void shutdown() {
            this.lbs.shutdown();
        }

        @Override
        public void start() {
            this.lbs.start();
        }

        @Override
        public void setDaemon(boolean daemon) {
            this.lbs.setDaemon(daemon);
        }

        @Override
        public Map statistics() {
            return null;
        }

        @Override
        public void registerServer(String url, float performanceFactor) {
        }

        @Override
        public void unregisterServer(String url) {
        }

        @Override
        public void broadcast() {
        }
    }
}

