/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcwrapper;

import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.orm.impl.service.SessionClosedException;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.rpc.io.RPCIOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.UnknownHostException;

public class Utils {
    public static boolean isRPCException(Throwable th) {
        return th instanceof ORMCoreException || th instanceof RPCException || th instanceof RPCIOException;
    }

    public static int getRPCErrorCode(Throwable th) {
        assert (th != null && Utils.isRPCException(th));
        int e = RPCException.getErrorCode(th);
        if (e == 500) {
            Throwable cause;
            if (th instanceof SessionClosedException) {
                e = 1001;
            } else if (th instanceof ORMCoreException) {
                cause = th.getCause();
                if (cause instanceof ConnectException) {
                    e = 2004;
                } else if (cause instanceof UnknownHostException) {
                    e = 2007;
                }
            }
            if (th instanceof RPCException) {
                cause = th.getCause();
                if (cause instanceof SocketException) {
                    e = 2004;
                } else if (cause instanceof UnknownHostException) {
                    e = 2007;
                }
            }
        }
        return e;
    }
}

