/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rpcwrapper.lbmon;

import com.kingdee.bos.rpc.io.ConnectionFactory;
import com.kingdee.bos.rpc.io.ServerManager;
import com.kingdee.bos.rpc.io.loadbalance.LoadBalance;
import java.util.Map;

public class LBServerManager {
    private LoadBalance loadBalance;

    LBServerManager(LoadBalance loadBalance) {
        this.loadBalance = loadBalance;
    }

    private static LoadBalance getLoadBalance(String name) {
        ConnectionFactory defaultServer = ServerManager.getServer(name);
        if (defaultServer instanceof LoadBalance) {
            return (LoadBalance)defaultServer;
        }
        return null;
    }

    public static LBServerManager getLBServerManager(String name) {
        LoadBalance lb = LBServerManager.getLoadBalance(name);
        if (lb != null) {
            return new LBServerManager(lb);
        }
        return null;
    }

    public static LBServerManager getDefaultLBServerManager() {
        return LBServerManager.getLBServerManager("default");
    }

    public Map statistics() {
        return this.loadBalance.statistics();
    }

    public void registerMember(String url, float capability) {
        this.loadBalance.registerServer(url, capability);
    }

    public void unregisterMember(int i) {
        this.loadBalance.unregisterServer(i);
    }

    public void stopMember(int i) {
    }
}

