/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tcpmonitor;

import com.kingdee.bos.tcpmonitor.DataStoreFile;
import com.kingdee.bos.tcpmonitor.EventManager;
import com.kingdee.bos.tcpmonitor.MonitorConfig;
import com.kingdee.bos.tcpmonitor.MonitorEvent;
import com.kingdee.bos.tcpmonitor.PhysicalResource;
import com.kingdee.bos.tcpmonitor.TcpServer;
import com.kingdee.bos.tcpmonitor.Util;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.log4j.Logger;

public class Connection
extends PhysicalResource {
    static Logger logger = Logger.getLogger((String)"tcpmonitor.Connection");
    public final TcpServer server;
    public final Socket sock;
    public final Socket sock2;
    public final String id = Util.identifier();
    public static final int REQUEST_DATA = 301;
    public static final int RESPONSE_DATA = 302;
    private final DataStoreFile storeFile;
    public long requestBytes = 0L;
    public long responseBytes = 0L;

    Connection(TcpServer server, Socket sock, Socket sock2) {
        this.server = server;
        this.sock = sock;
        this.sock2 = sock2;
        this.storeFile = new DataStoreFile(this);
        Thread t = new Thread(this.getTitle()){

            @Override
            public void run() {
                Connection.this.service();
            }
        };
        t.setDaemon(true);
        t.start();
    }

    private String getPeerAddress(Socket sock) {
        InetSocketAddress addr = (InetSocketAddress)sock.getRemoteSocketAddress();
        if (MonitorConfig.useHostNameInsteadIP) {
            return addr.getHostName() + ":" + addr.getPort();
        }
        return addr.getAddress().getHostAddress() + ":" + addr.getPort();
    }

    public String getTitle() {
        return "(" + this.id + ":" + this.getPeerAddress(this.sock) + "<==>" + this.getPeerAddress(this.sock2) + ")";
    }

    public String toString() {
        return this.getTitle();
    }

    @Override
    protected void finalClose() {
        Util.close(this.sock);
        Util.close(this.sock2);
        this.storeFile.close();
    }

    @Override
    protected void finalOpen() {
    }

    private void service() {
        EventManager.connectionOpened(this);
        try {
            this.open();
            Thread responseThread = new Thread("[Response]" + this.getTitle()){

                @Override
                public void run() {
                    Connection.this.pipeStream(Connection.this.sock2, Connection.this.sock);
                }
            };
            responseThread.setDaemon(true);
            responseThread.start();
            this.pipeStream(this.sock, this.sock2);
            responseThread.join();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.close();
        EventManager.connectionClosed(this);
    }

    private void dataIncoming(int type, byte[] data, int off, int len) {
        if (type == 301) {
            this.requestBytes += (long)len;
        } else {
            this.responseBytes += (long)len;
        }
        byte[] b = new byte[len];
        System.arraycopy(data, off, b, 0, len);
        EventManager.fireEvent(new MonitorEvent(type, this, b));
        if (MonitorConfig.dumpData) {
            this.storeFile.writeRecord(type, b, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pipeStream(Socket from, Socket to) {
        try {
            InputStream in = from.getInputStream();
            OutputStream out = to.getOutputStream();
            byte[] buf = new byte[16384];
            try {
                int l;
                while ((l = in.read(buf)) > 0) {
                    this.dataIncoming(from == this.sock ? 301 : 302, buf, 0, l);
                    out.write(buf, 0, l);
                    out.flush();
                }
            }
            finally {
                Util.close(in);
                Util.close(out);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

