/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tcpmonitor;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DataRecord {
    public static final int RECORD_LENGTH = 16;
    public int type;
    public long time;
    public long pos;
    public int len;
    private static final SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");

    public DataRecord(int type, long time, long pos, int len) {
        this.type = type;
        this.time = time;
        this.pos = pos;
        this.len = len;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.time);
        out.writeInt((int)this.pos);
        int val = this.len;
        if (this.type == 302) {
            val |= Integer.MIN_VALUE;
        }
        out.writeInt(val);
    }

    public DataRecord(DataInput in) throws IOException {
        this.read(in);
    }

    public void read(DataInput in) throws IOException {
        this.time = in.readLong();
        this.pos = (long)in.readInt() & 0xFFFFFFFFL;
        int val = in.readInt();
        this.type = (val & Integer.MIN_VALUE) == 0 ? 301 : 302;
        this.len = val & Integer.MAX_VALUE;
    }

    public String formatTime() {
        return df.format(new Date(this.time));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(this.formatTime());
        sb.append("][");
        if (this.type == 301) {
            sb.append("Client");
        } else {
            sb.append("Server");
        }
        sb.append("] [size= ");
        sb.append(this.len);
        sb.append("]");
        return sb.toString();
    }
}

