/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.KDAutoSearch;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;

public class AutoSearchPopup
extends JPopupMenu
implements ComboPopup {
    private static final long serialVersionUID = -2047859078703820416L;
    protected JList list;
    protected JScrollPane scroller;
    protected boolean valueIsAdjusting = false;
    protected MouseMotionListener mouseMotionListener;
    protected MouseListener mouseListener;
    protected KeyListener keyListener;
    protected ListSelectionListener listSelectionListener;
    protected MouseListener listMouseListener;
    protected MouseMotionListener listMouseMotionListener;
    private KDAutoSearch autoSearch;
    private JTextComponent parent = null;
    protected boolean hasEntered = false;

    public AutoSearchPopup(KDAutoSearch autoSearch) {
        this.autoSearch = autoSearch;
        this.parent = autoSearch.getTextComponent();
        this.list = this.createList();
        this.configureList();
        this.scroller = this.createScroller();
        this.configureScroller();
        this.configurePopup();
    }

    @Override
    public void show() {
        this.setListSelection(0);
        Point location = this.getPopupLocation();
        this.show(this.parent, location.x, location.y);
    }

    @Override
    public void hide() {
        MenuSelectionManager manager = MenuSelectionManager.defaultManager();
        MenuElement[] selection = manager.getSelectedPath();
        for (int i = 0; i < selection.length; ++i) {
            if (selection[i] != this) continue;
            manager.clearSelectedPath();
            break;
        }
        if (selection.length > 0) {
            this.parent.repaint();
        }
    }

    public JList getList() {
        return this.list;
    }

    @Override
    public MouseListener getMouseListener() {
        if (this.mouseListener == null) {
            this.mouseListener = this.createMouseListener();
        }
        return this.mouseListener;
    }

    @Override
    public MouseMotionListener getMouseMotionListener() {
        return null;
    }

    @Override
    public KeyListener getKeyListener() {
        if (this.keyListener == null) {
            this.keyListener = this.createKeyListener();
        }
        return this.keyListener;
    }

    @Override
    public void uninstallingUI() {
    }

    protected void configureList() {
        this.list.setForeground(UIManager.getColor("AutoSearch.foreground"));
        this.list.setBackground(UIManager.getColor("AutoSearch.background"));
        this.list.setSelectionForeground(UIManager.getColor("AutoSearch.selectionForeground"));
        this.list.setSelectionBackground(UIManager.getColor("AutoSearch.selectionBackground"));
        this.list.setBorder(null);
        this.list.setFocusable(false);
        this.list.setSelectionMode(0);
        this.setListSelection(0);
        this.installListListeners();
    }

    protected JList createList() {
        return new JList(this.autoSearch.getIndexValus()){
            private static final long serialVersionUID = -6999052130368419649L;

            @Override
            public void processMouseEvent(MouseEvent e) {
                if (e.isControlDown()) {
                    e = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers() ^ 2, e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger());
                }
                super.processMouseEvent(e);
            }
        };
    }

    protected JScrollPane createScroller() {
        return new JScrollPane(this.list, 20, 31);
    }

    protected void configureScroller() {
        this.scroller.setFocusable(false);
        this.scroller.getVerticalScrollBar().setFocusable(false);
        this.scroller.setBorder(null);
    }

    protected void configurePopup() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setBorder(BorderFactory.createLineBorder(UIManager.getColor("AutoSearch.borderLineColor")));
        this.setOpaque(false);
        this.add(this.scroller);
        this.setDoubleBuffered(true);
        this.setFocusable(false);
    }

    private void setListSelection(int selectedIndex) {
        if (selectedIndex == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(selectedIndex);
            this.list.ensureIndexIsVisible(selectedIndex);
        }
    }

    private Point getPopupLocation() {
        Dimension popupSize = this.parent.getSize();
        Insets insets = this.getInsets();
        popupSize.setSize(popupSize.width - (insets.right + insets.left), 7);
        Rectangle popupBounds = this.computePopupBounds(0, this.parent.getBounds().height, popupSize.width, popupSize.height);
        Dimension scrollSize = popupBounds.getSize();
        Point popupLocation = popupBounds.getLocation();
        int itemCount = this.list.getModel().getSize();
        int tempHeight = 0;
        tempHeight = itemCount > 7 ? 7 * this.parent.getHeight() : itemCount * this.parent.getHeight();
        scrollSize.setSize(scrollSize.getWidth(), (double)tempHeight);
        this.scroller.setMaximumSize(scrollSize);
        this.scroller.setPreferredSize(scrollSize);
        this.scroller.setMinimumSize(scrollSize);
        this.list.revalidate();
        return popupLocation;
    }

    protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
        Rectangle screenBounds;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration gc = this.parent.getGraphicsConfiguration();
        Point p = new Point();
        SwingUtilities.convertPointFromScreen(p, this.parent);
        if (gc != null) {
            Insets screenInsets = toolkit.getScreenInsets(gc);
            screenBounds = gc.getBounds();
            screenBounds.width -= screenInsets.left + screenInsets.right;
            screenBounds.height -= screenInsets.top + screenInsets.bottom;
            screenBounds.x += p.x + screenInsets.left;
            screenBounds.y += p.y + screenInsets.top;
        } else {
            screenBounds = new Rectangle(p, toolkit.getScreenSize());
        }
        Rectangle rect = new Rectangle(px, py, pw, ph);
        if (py + ph > screenBounds.y + screenBounds.height && ph < screenBounds.height) {
            rect.y = -rect.height;
        }
        return rect;
    }

    protected KeyListener createKeyListener() {
        return new PopupMenuKeyListener();
    }

    protected void installListListeners() {
        this.listMouseListener = this.createListMouseListener();
        if (this.listMouseListener != null) {
            this.list.addMouseListener(this.listMouseListener);
        }
        if ((this.listMouseMotionListener = this.createListMouseMotionListener()) != null) {
            this.list.addMouseMotionListener(this.listMouseMotionListener);
        }
    }

    protected void uninstallListListeners() {
        if (this.listMouseListener != null) {
            this.list.removeMouseListener(this.listMouseListener);
            this.listMouseListener = null;
        }
        if (this.listMouseMotionListener != null) {
            this.list.removeMouseMotionListener(this.listMouseMotionListener);
            this.listMouseMotionListener = null;
        }
        if (this.listSelectionListener != null) {
            this.list.removeListSelectionListener(this.listSelectionListener);
            this.listSelectionListener = null;
        }
    }

    protected void updateListBoxSelectionForEvent(MouseEvent anEvent, boolean shouldScroll) {
        Point location = anEvent.getPoint();
        if (this.list == null) {
            return;
        }
        int index = this.list.locationToIndex(location);
        if (index == -1) {
            index = location.y < 0 ? 0 : this.list.getModel().getSize() - 1;
        }
        if (this.list.getSelectedIndex() != index) {
            this.list.setSelectedIndex(index);
            if (shouldScroll) {
                this.list.ensureIndexIsVisible(index);
            }
        }
    }

    protected MouseMotionListener createListMouseMotionListener() {
        return new ListMouseMotionHandler();
    }

    protected void togglePopup() {
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    protected MouseListener createMouseListener() {
        return new InvocationMouseHandler();
    }

    protected MouseEvent convertMouseEvent(MouseEvent e) {
        Point convertedPoint = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this.list);
        MouseEvent newEvent = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), convertedPoint.x, convertedPoint.y, e.getClickCount(), e.isPopupTrigger());
        return newEvent;
    }

    protected MouseListener createListMouseListener() {
        return new ListMouseHandler();
    }

    protected class ListMouseHandler
    extends MouseAdapter {
        protected ListMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent anEvent) {
            AutoSearchPopup.this.autoSearch.setCanDoValueChange(false);
            AutoSearchPopup.this.parent.setText(AutoSearchPopup.this.list.getSelectedValue().toString());
            if (AutoSearchPopup.this.parent.getText() != null) {
                AutoSearchPopup.this.parent.setCaretPosition(AutoSearchPopup.this.parent.getText().length());
            }
            AutoSearchPopup.this.hide();
        }
    }

    protected class InvocationMouseHandler
    extends MouseAdapter {
        protected InvocationMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e) || !AutoSearchPopup.this.parent.isEnabled()) {
                return;
            }
            if (AutoSearchPopup.this.parent.isEditable()) {
                JTextComponent comp = AutoSearchPopup.this.parent;
                if (!(comp instanceof JComponent) || ((JComponent)comp).isRequestFocusEnabled()) {
                    ((Component)comp).requestFocus();
                }
            } else if (AutoSearchPopup.this.parent.isRequestFocusEnabled()) {
                AutoSearchPopup.this.parent.requestFocus();
            }
            AutoSearchPopup.this.togglePopup();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Component source = (Component)e.getSource();
            Dimension size = source.getSize();
            Rectangle bounds = new Rectangle(0, 0, size.width - 1, size.height - 1);
            if (!bounds.contains(e.getPoint())) {
                Rectangle r = new Rectangle();
                AutoSearchPopup.this.list.computeVisibleRect(r);
                AutoSearchPopup.this.hide();
            }
            AutoSearchPopup.this.hasEntered = false;
        }
    }

    protected class ListMouseMotionHandler
    extends MouseMotionAdapter {
        protected ListMouseMotionHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent anEvent) {
            Point location = anEvent.getPoint();
            Rectangle r = new Rectangle();
            AutoSearchPopup.this.list.computeVisibleRect(r);
            if (r.contains(location)) {
                AutoSearchPopup.this.updateListBoxSelectionForEvent(anEvent, false);
            }
        }
    }

    static class PopupMenuKeyListener
    implements KeyListener {
        PopupMenuKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

