/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.CtrlPlainDocument;
import com.kingdee.cosmic.ctrl.swing.IKDTextComponent;
import com.kingdee.cosmic.ctrl.swing.util.TextComponentUtilities;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.im.InputMethodRequests;
import java.text.Format;
import javax.swing.JFormattedTextField;
import javax.swing.UIManager;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class BasicFormattedTextField
extends JFormattedTextField
implements IKDTextComponent {
    private static final long serialVersionUID = -8238237328087918970L;
    private boolean required = false;
    private boolean selectAllOnFocus = true;
    private Color customForegroundColor;
    private Color customBackgroundColor;
    private boolean firelistener = true;
    boolean isFoucusLost = false;

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        boolean old = this.required;
        this.required = required;
        if (this.isEnabled() && this.isEditable() && required) {
            this.setBackground(UIManager.getColor("TextField.requiredBackground"));
            this.setForeground(UIManager.getColor("TextField.requiredForeground"));
            this.repaint();
        }
        this.firePropertyChange("required", (Object)old, (Object)required);
    }

    public void setSelectAllOnFocus(boolean newValue) {
        this.selectAllOnFocus = newValue;
    }

    public boolean isSelectAllOnFocus() {
        return this.selectAllOnFocus;
    }

    public void selectAllfromTheEnd() {
        Document doc = this.getDocument();
        if (doc != null) {
            this.setCaretPosition(doc.getLength());
            this.moveCaretPosition(0);
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (e.getID() == 1004 && this.isSelectAllOnFocus()) {
            Rectangle alloc = this.getBounds();
            if (alloc.width > 0 && alloc.height > 0) {
                this.selectAllfromTheEnd();
            }
        }
    }

    @Override
    public void setEditable(boolean editable) {
        if (TextComponentUtilities.setEditable(this, editable)) {
            super.setEditable(editable);
            if (this.isEnabled()) {
                if (editable) {
                    this.setBackground(UIManager.getColor("TextField.background"));
                    this.setForeground(UIManager.getColor("TextField.foreground"));
                    this.setRequired(this.isRequired());
                } else {
                    this.setBackground(UIManager.getColor("TextField.readonlyBackground"));
                    this.setForeground(UIManager.getColor("TextField.readonlyForeground"));
                    this.repaint();
                }
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (TextComponentUtilities.setEnabled(this, enabled)) {
            super.setEnabled(enabled);
            if (enabled) {
                this.setBackground(UIManager.getColor("TextField.background"));
                this.setForeground(UIManager.getColor("TextField.foreground"));
                this.setEditable(this.isEditable());
            } else {
                this.setBackground(UIManager.getColor("TextField.disableBackground"));
                this.setForeground(UIManager.getColor("TextField.disableForeground"));
                this.repaint();
            }
        }
    }

    @Override
    public String getText() {
        if (this.getAccessAuthority() == 2) {
            Object data = TextComponentUtilities.getData(this);
            return data == null ? "" : data.toString();
        }
        return super.getText();
    }

    @Override
    public void setText(String t) {
        if (TextComponentUtilities.setData(this, t)) {
            try {
                Document doc = this.getDocument();
                if (doc instanceof CtrlPlainDocument) {
                    ((CtrlPlainDocument)doc).replace(0, doc.getLength(), t, null, true);
                } else if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).replace(0, doc.getLength(), t, null);
                } else {
                    doc.remove(0, doc.getLength());
                    doc.insertString(0, t, null);
                }
            }
            catch (BadLocationException e) {
                UIManager.getLookAndFeel().provideErrorFeedback(this);
            }
        }
    }

    public BasicFormattedTextField() {
        TextComponentUtilities.storeOriginalData(this);
    }

    public BasicFormattedTextField(Object value) {
        super(value);
        TextComponentUtilities.storeOriginalData(this);
    }

    public BasicFormattedTextField(Format format) {
        super(format);
        TextComponentUtilities.storeOriginalData(this);
    }

    public BasicFormattedTextField(JFormattedTextField.AbstractFormatter formatter) {
        super(formatter);
        TextComponentUtilities.storeOriginalData(this);
    }

    public BasicFormattedTextField(JFormattedTextField.AbstractFormatterFactory factory) {
        super(factory);
        TextComponentUtilities.storeOriginalData(this);
    }

    public BasicFormattedTextField(JFormattedTextField.AbstractFormatterFactory factory, Object currentValue) {
        super(factory, currentValue);
        TextComponentUtilities.storeOriginalData(this);
    }

    @Override
    public void setAccessAuthority(int authority) {
        TextComponentUtilities.setAccessAuthority(this, authority);
    }

    @Override
    public int getAccessAuthority() {
        return TextComponentUtilities.getAccessAuthority(this);
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return null;
    }

    public void setCustomForegroundColor(Color newColor) {
        Color oldColor = this.customForegroundColor;
        this.customForegroundColor = newColor;
        this.firePropertyChange("customForegroundColorChanged", oldColor, newColor);
    }

    public Color getCustomForegroundColor() {
        return this.customForegroundColor;
    }

    public void setCustomBackgroundColor(Color newColor) {
        Color oldColor = this.customBackgroundColor;
        this.customBackgroundColor = newColor;
        this.firePropertyChange("customBackgroundColorChanged", oldColor, newColor);
    }

    public Color getCustomBackgroundColor() {
        return this.customBackgroundColor;
    }

    public void setValue(Object o, boolean fireListener) {
        if (!fireListener) {
            this.firelistener = false;
            this.setValue(o);
            this.firelistener = true;
        } else {
            this.setValue(o);
        }
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if ("value".equals(propertyName) && !this.firelistener) {
            return;
        }
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public boolean isFoucusLost() {
        return this.isFoucusLost;
    }

    public void setFoucusLost(boolean isFoucusLost) {
        this.isFoucusLost = isFoucusLost;
    }
}

