/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.BasicFormattedTextField;
import com.kingdee.cosmic.ctrl.swing.BasicNumberTextField;
import com.kingdee.cosmic.ctrl.swing.CtrlPlainDocument;
import com.kingdee.cosmic.ctrl.swing.DateFormatterEx;
import com.kingdee.cosmic.ctrl.swing.ICtrTextDocumentFilter;
import com.kingdee.cosmic.ctrl.swing.IDateTimePicker;
import com.kingdee.cosmic.ctrl.swing.KDDatePicker;
import com.kingdee.cosmic.ctrl.swing.KDInfoTip;
import com.kingdee.cosmic.ctrl.swing.KDSpinner;
import com.kingdee.cosmic.ctrl.swing.KDTimePicker;
import com.kingdee.cosmic.ctrl.swing.StringUtils;
import com.kingdee.cosmic.ctrl.swing.common.i18n.CtrlSwingMessages;
import com.kingdee.cosmic.ctrl.swing.event.DataChangeEvent;
import com.kingdee.cosmic.ctrl.swing.event.DataChangeListener;
import com.kingdee.cosmic.ctrl.swing.model.IDateTimeModel;
import com.kingdee.cosmic.ctrl.swing.model.KDSpinnerDateModel;
import com.kingdee.cosmic.ctrl.swing.util.CtrlFormatUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;

public class DateTimeEditor
extends JPanel {
    private static final long serialVersionUID = 4196789147744445705L;
    public static final int DATEPICKER_EDITOR = 0;
    public static final int TIMEPICKER_EDITOR = 1;
    private JComponent parent = null;
    private IDateTimeModel model = null;
    private EditorArea editorArea = null;
    private int componentKind = -1;
    private transient Date todayDate = null;
    private boolean isSupportedEmpty = true;
    private boolean fireListener = true;
    private String ownPattern = null;

    public DateTimeEditor(JComponent parent) {
        if (!(parent instanceof IDateTimePicker)) {
            throw new IllegalArgumentException("null parent or parent is not IDateTimePicker ");
        }
        if (parent instanceof KDDatePicker) {
            this.componentKind = 0;
        } else if (parent instanceof KDTimePicker) {
            this.componentKind = 1;
        } else {
            throw new IllegalArgumentException("don't agree the Class Type:" + parent.getName());
        }
        this.todayDate = new Date(System.currentTimeMillis());
        this.parent = parent;
        this.model = ((IDateTimePicker)((Object)parent)).getModel();
        this.configEditor();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(this.editorArea.getComponent().getPreferredSize());
        this.setMinimumSize(this.editorArea.getComponent().getMinimumSize());
        this.setMaximumSize(this.editorArea.getComponent().getMaximumSize());
        this.add((Component)this.editorArea.getComponent(), "Center");
        parent.addPropertyChangeListener(new EditorPropertyChangeListener());
    }

    public void hideInfoTip() {
        if (this.editorArea != null && this.editorArea.ftf != null && this.editorArea.ftf.getInfoTip() != null) {
            this.editorArea.ftf.getInfoTip().setShowing(false);
        }
    }

    public void setDateTimeModel(IDateTimeModel model) {
        if (model == null) {
            throw new IllegalArgumentException("null model");
        }
        if (!model.equals(this.model)) {
            IDateTimeModel oldModel = this.model;
            if (oldModel != null) {
                oldModel = null;
            }
            this.model = model;
            this.configEditor();
        }
    }

    public void setDataChangeListenerFired(boolean fire) {
        this.fireListener = fire;
    }

    public boolean getDataChangeListenerFired() {
        return this.fireListener;
    }

    public void setEditable(boolean b) {
        if (this.editorArea != null) {
            this.editorArea.setEditable(b);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        if (this.editorArea != null) {
            this.editorArea.setEnabled(b);
        } else {
            super.setEnabled(b);
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.editorArea != null) {
            return this.editorArea.isEnabled();
        }
        return super.isEnabled();
    }

    public boolean isEditable() {
        if (this.editorArea != null) {
            return this.editorArea.isEditable();
        }
        return true;
    }

    public void setRequired(boolean b) {
        if (this.editorArea != null) {
            this.editorArea.setRequired(b);
        }
    }

    public JComponent getEditorComponent() {
        return this.editorArea.getComponent();
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    public IDateTimeModel getDateTimeModel() {
        return this.model;
    }

    public SimpleDateFormat getFormat() {
        return this.editorArea.getFormat();
    }

    protected void configEditor() {
        if (this.model == null) {
            throw new NullPointerException("model is null");
        }
        Locale l = Locale.getDefault();
        if (this.editorArea == null) {
            this.editorArea = new EditorArea(l, this.model);
        } else {
            this.editorArea.setIsChange(false);
            this.editorArea.setLocale(l);
            this.editorArea.setModel(this.model);
            this.editorArea.setIsChange(true);
        }
    }

    void addDataChangeListener(DataChangeListener l) {
        this.listenerList.add(DataChangeListener.class, l);
    }

    void removeDataChangeListener(DataChangeListener l) {
        this.listenerList.remove(DataChangeListener.class, l);
    }

    void fireDataChanged(DataChangeEvent event) {
        if (!this.fireListener) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataChangeListener.class || event == null) continue;
            ((DataChangeListener)listeners[i + 1]).dataChanged(event);
        }
    }

    public Date getValue() {
        return this.editorArea != null ? this.editorArea.getEditorAreaValue() : null;
    }

    public void setValue(Date d) {
        this.editorArea.setEditorAreaValue(d);
    }

    void setSupportedEmpty(boolean b) {
        this.isSupportedEmpty = b;
        this.editorArea.setEAIsSupportedEmpty(this.isSupportedEmpty);
    }

    boolean isSupportedEmpty() {
        return this.isSupportedEmpty;
    }

    public void setMaximumDate(Date newMaxDate) {
        this.editorArea.getDateFormatter().setMaximum(newMaxDate);
    }

    public Date getMaximumDate() {
        Comparable<?> max = this.editorArea.getDateFormatter().getMaximum();
        if (max instanceof Date) {
            return (Date)max;
        }
        return null;
    }

    public void setMinimumDate(Date newMinDate) {
        this.editorArea.getDateFormatter().setMinimum(newMinDate);
    }

    public Date getMinimumDate() {
        Comparable<?> min = this.editorArea.getDateFormatter().getMinimum();
        if (min instanceof Date) {
            return (Date)min;
        }
        return null;
    }

    public void setDateTimePattern(String dateTimePattern) {
        this.editorArea.configComponent(dateTimePattern);
        if (!StringUtils.isEmpty(dateTimePattern)) {
            this.ownPattern = dateTimePattern;
        }
    }

    public String getDateTimePattern() {
        return this.editorArea.getFormat().toPattern();
    }

    public String getText() {
        Date v = this.getValue();
        if (v != null) {
            return this.editorArea.getFormat().format(v);
        }
        return "";
    }

    private int getComponentKind() {
        return this.componentKind;
    }

    private static class DateTimeTextField
    extends BasicFormattedTextField {
        private static final long serialVersionUID = -3518690600870969034L;
        private CtrlPlainDocument timeDocument = new CtrlPlainDocument();
        private ICtrTextDocumentFilter ctrlTextDocuFilter = new BasicNumberTextField.DefaultCtrlTextDocumentFilter();
        private boolean pSupportedEmtpy = true;
        private KDInfoTip textFieldInfo = null;

        public DateTimeTextField(JFormattedTextField.AbstractFormatter formatter) {
            super(formatter);
            this.init();
        }

        private void init() {
            this.ctrlTextDocuFilter.setValidateStr("-/:, ");
            this.timeDocument.setCtrTextDocumentFilter(this.ctrlTextDocuFilter);
            this.setDocument(this.timeDocument);
            if (this.textFieldInfo == null) {
                this.textFieldInfo = new KDInfoTip(null, CtrlSwingMessages.getMLS("ErrorDateMessage", "\u65e5\u671f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!"));
            }
        }

        public KDInfoTip getInfoTip() {
            return this.textFieldInfo;
        }

        @Override
        protected void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
            if (e.isTemporary()) {
                return;
            }
            if (e.getID() == 1005) {
                this.timeDocument.setFocusing(false);
            } else {
                this.timeDocument.setFocusing(true);
            }
        }

        @Override
        public void commitEdit() throws ParseException {
            try {
                String text = this.getText();
                if (text.indexOf(45) == -1 && text.indexOf(47) == -1 && text.indexOf(58) == -1 && text.length() == 8) {
                    if (this.getParent().getLocale().getLanguage().equals("en")) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(text.substring(0, 2));
                        sb.append('/');
                        sb.append(text.substring(2, 4));
                        sb.append('/');
                        sb.append(text.substring(4, 8));
                        this.setText(sb.toString());
                    } else {
                        StringBuilder sb = new StringBuilder();
                        sb.append(text.substring(0, 4));
                        sb.append('-');
                        sb.append(text.substring(4, 6));
                        sb.append('-');
                        sb.append(text.substring(6, 8));
                        this.setText(sb.toString());
                    }
                }
                super.commitEdit();
            }
            catch (ParseException pe) {
                KDDatePicker dp = (KDDatePicker)this.getParent().getParent();
                if (!this.isFoucusLost && dp.isOpenTips()) {
                    throw pe;
                }
                dp.setParseException(true);
                this.reSetValueWhenError();
            }
        }

        void setPIsSupportedEmtpy(boolean b) {
            this.pSupportedEmtpy = b;
        }

        private void reSetValueWhenError() {
            String pText = this.getText();
            pText = pText != null ? pText.trim() : "";
            int len = pText.length();
            if (this.pSupportedEmtpy && len == 0) {
                this.setValue(null);
            } else {
                this.setValueUsingLastValue();
                this.requestFocusInWindow();
                if (((KDDatePicker)this.getParent().getParent()).isShowErrorInfo() && this.isEnabled() && this.isEditable()) {
                    this.textFieldInfo.setArrowHeight(10);
                    this.textFieldInfo.setParent((KDDatePicker)this.getParent().getParent());
                    this.textFieldInfo.setShowing(true);
                }
            }
        }

        private void setValueUsingLastValue() {
            Object obj = this.getValue();
            if (obj != null) {
                this.setValue(obj);
            } else {
                this.setValue(new Date());
            }
        }
    }

    protected class EditorArea
    implements Serializable {
        private static final long serialVersionUID = -6771670262312296127L;
        private Locale l = null;
        private IDateTimeModel m = null;
        private DateTimeTextField ftf = null;
        private KDSpinner spinner = null;
        private boolean isChange = true;
        private static final int DATETYPE = 0;
        private static final int TIMETYPE = 1;
        private boolean timePickerEmpty = false;
        private boolean enabled = true;

        public EditorArea(Locale l, IDateTimeModel model) {
            this.l = l;
            this.m = model;
            if (model.getValue() == null) {
                model.setValue(DateTimeEditor.this.todayDate);
            }
            this.resetFormated();
        }

        public JComponent getComponent() {
            if (this.spinner != null) {
                this.spinner.getEditor();
                return this.spinner;
            }
            if (this.ftf != null) {
                return this.ftf;
            }
            throw new NullPointerException("DateTimeEditor is null.");
        }

        public void setIsChange(boolean isC) {
            this.isChange = isC;
            if (this.isChange) {
                this.resetFormated();
            }
        }

        public void setLocale(Locale le) {
            if (!le.equals(this.l)) {
                this.l = le;
                if (this.isChange) {
                    this.resetFormated();
                }
            }
        }

        public void setModel(IDateTimeModel model) {
            if (model != this.m) {
                this.m = model;
                if (this.isChange) {
                    this.resetFormated();
                }
            }
        }

        private void resetFormated() {
            boolean isDateEnable = this.m.isDateEnable();
            boolean isTimeEnable = this.m.isTimeEnable();
            boolean isMilliSecondEnable = this.m.isMillisecondEnable();
            String pattern = this.getPattern(isDateEnable, isTimeEnable, isMilliSecondEnable);
            this.configComponent(pattern);
        }

        public SimpleDateFormat getFormat() {
            DateFormatter dateFormatter = this.getDateFormatter();
            if (dateFormatter != null) {
                return (SimpleDateFormat)dateFormatter.getFormat();
            }
            return null;
        }

        DateFormatter getDateFormatter() {
            if (this.ftf != null) {
                return (DateFormatter)this.ftf.getFormatter();
            }
            if (this.spinner != null) {
                return (DateFormatter)((JSpinner.DateEditor)this.spinner.getEditor()).getTextField().getFormatter();
            }
            return null;
        }

        private void configComponent(String pattern) {
            switch (DateTimeEditor.this.getComponentKind()) {
                case 0: {
                    this.configDatePickerEditor(pattern);
                    this.spinner = null;
                    break;
                }
                case 1: {
                    this.configTimePickerEditor(pattern);
                    this.ftf = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("DateTimeEidot's componentKind is illegal.");
                }
            }
        }

        JFormattedTextField getDatePickerEditor() {
            if (this.ftf == null) {
                DateFormat reservedFormat;
                SimpleDateFormat simpFormat = new SimpleDateFormat();
                DateFormatSymbols symbols = CtrlFormatUtilities.getDateFormatSymbols();
                if (symbols != null) {
                    simpFormat.setDateFormatSymbols(symbols);
                }
                if ((reservedFormat = CtrlFormatUtilities.getDateTimeFormat()) == null) {
                    reservedFormat = CtrlFormatUtilities.getDateFormat();
                }
                if (reservedFormat != null) {
                    simpFormat.setTimeZone(reservedFormat.getTimeZone());
                }
                simpFormat.applyPattern(this.getNullPattern(0));
                simpFormat.setLenient(false);
                DateFormatterEx dateFormatter = new DateFormatterEx(simpFormat);
                this.ftf = new DateTimeTextField(dateFormatter);
                this.ftf.setBorder(null);
                if (DateTimeEditor.this.model.getValue() == null) {
                    DateTimeEditor.this.model.setValue(DateTimeEditor.this.todayDate);
                }
                this.ftf.setToolTipText(this.getNullPattern(0));
                this.ftf.setValue(DateTimeEditor.this.model.getValue());
                this.ftf.addPropertyChangeListener("value", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent pce) {
                        if (pce.getPropertyName().equals("value")) {
                            EditorArea.this.setValueByFormattedTextField(pce);
                        }
                    }
                });
                this.ftf.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (EditorArea.this.ftf.getInfoTip() != null) {
                            EditorArea.this.ftf.getInfoTip().setShowing(false);
                        }
                    }
                });
                this.ftf.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent fe) {
                        DateTimeEditor.this.parent.repaint();
                    }

                    @Override
                    public void focusLost(FocusEvent fe) {
                        if (EditorArea.this.ftf.getInfoTip() != null) {
                            EditorArea.this.ftf.getInfoTip().setShowing(false);
                        }
                        KDDatePicker dp = (KDDatePicker)DateTimeEditor.this.parent;
                        try {
                            dp.setParseException(false);
                            ((EditorArea)EditorArea.this).ftf.isFoucusLost = true;
                            EditorArea.this.ftf.commitEdit();
                            ((EditorArea)EditorArea.this).ftf.isFoucusLost = false;
                        }
                        catch (ParseException e) {
                            return;
                        }
                        DateTimeEditor.this.model.setValue((Date)EditorArea.this.ftf.getValue());
                        if (DateTimeEditor.this.model.getValue() != null && dp.hasDatePickerDownList() && !dp.isDownListCreated()) {
                            dp.getDatePickerDownList().getModel().setValue(DateTimeEditor.this.model.getValue());
                        }
                        DateTimeEditor.this.parent.repaint();
                    }
                });
            }
            return this.ftf;
        }

        private void configDatePickerEditor(String pattern) {
            String toPattern = ((SimpleDateFormat)((DateFormatter)this.getDatePickerEditor().getFormatter()).getFormat()).toPattern();
            if (toPattern == null || !toPattern.equals(pattern)) {
                DateFormatter dateFormatter = (DateFormatter)this.getDatePickerEditor().getFormatter();
                SimpleDateFormat simpFormat = (SimpleDateFormat)dateFormatter.getFormat();
                simpFormat.applyPattern(pattern);
                dateFormatter.setFormat(simpFormat);
                JFormattedTextField.AbstractFormatterFactory formatFactory = this.getDatePickerEditor().getFormatterFactory();
                ((DefaultFormatterFactory)formatFactory).setDefaultFormatter(dateFormatter);
                this.getDatePickerEditor().setFormatterFactory(formatFactory);
                this.getDatePickerEditor().setToolTipText(pattern);
            }
        }

        JSpinner getTimePickerEditor() {
            if (this.spinner == null) {
                KDSpinnerDateModel sdm = new KDSpinnerDateModel();
                this.spinner = new KDSpinner(sdm);
                JSpinner.DateEditor spiDateEditor = (JSpinner.DateEditor)this.spinner.getEditor();
                DateFormatter formatter = (DateFormatter)((JSpinner.DateEditor)this.spinner.getEditor()).getTextField().getFormatter();
                DateFormat reservedFormat = CtrlFormatUtilities.getDateTimeFormat();
                if (reservedFormat == null) {
                    reservedFormat = CtrlFormatUtilities.getDateFormat();
                }
                if (reservedFormat != null) {
                    spiDateEditor.getFormat().setTimeZone(reservedFormat.getTimeZone());
                }
                spiDateEditor.getFormat().applyPattern(this.getNullPattern(1));
                DateFormatSymbols symbols = CtrlFormatUtilities.getDateFormatSymbols();
                if (symbols != null) {
                    spiDateEditor.getFormat().setDateFormatSymbols(symbols);
                }
                formatter.setAllowsInvalid(false);
                formatter.setOverwriteMode(true);
                JFormattedTextField.AbstractFormatterFactory factory = spiDateEditor.getTextField().getFormatterFactory();
                ((DefaultFormatterFactory)factory).setDefaultFormatter(formatter);
                spiDateEditor.getTextField().setFormatterFactory(factory);
                this.spinner.setEditor(spiDateEditor);
                if (DateTimeEditor.this.model.getValue() == null) {
                    DateTimeEditor.this.model.setValue(DateTimeEditor.this.todayDate);
                }
                this.spinner.setValue(DateTimeEditor.this.model.getValue());
                this.spinner.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent che) {
                        if (EditorArea.this.timePickerEmpty) {
                            DateTimeEditor.this.model.setEmptyValue(true);
                        } else {
                            DateTimeEditor.this.model.setEmptyValue(false);
                        }
                        EditorArea.this.setValueBySpinner(che);
                        EditorArea.this.timePickerEmpty = false;
                    }
                });
            }
            return this.spinner;
        }

        private void configTimePickerEditor(String pattern) {
            String toPattern = ((JSpinner.DateEditor)this.getTimePickerEditor().getEditor()).getFormat().toPattern();
            if (toPattern == null || !toPattern.equals(pattern)) {
                ((JSpinner.DateEditor)this.getTimePickerEditor().getEditor()).getFormat().applyPattern(pattern);
                ((JSpinner.DateEditor)this.spinner.getEditor()).getTextField().setFormatterFactory(((JSpinner.DateEditor)this.spinner.getEditor()).getTextField().getFormatterFactory());
            }
        }

        protected String getPattern(boolean isDateEnable, boolean isTimeEnable, boolean isMilliSecondEnable) {
            if (DateTimeEditor.this.ownPattern != null) {
                return DateTimeEditor.this.ownPattern;
            }
            DateFormat format = CtrlFormatUtilities.getDateTimeFormat();
            if (format != null && isDateEnable && isTimeEnable) {
                return ((SimpleDateFormat)format).toPattern();
            }
            StringBuilder sb = new StringBuilder();
            if (isDateEnable) {
                format = CtrlFormatUtilities.getDateFormat();
                if (format != null) {
                    sb.append(((SimpleDateFormat)format).toPattern());
                } else {
                    sb.append(((SimpleDateFormat)DateFormat.getDateInstance()).toPattern());
                }
            }
            if (isTimeEnable) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                if (isMilliSecondEnable) {
                    sb.append("HH:mm:ss:SSS");
                } else {
                    format = CtrlFormatUtilities.getTimeFormat();
                    if (format != null) {
                        sb.append(((SimpleDateFormat)format).toPattern());
                    } else {
                        sb.append(((SimpleDateFormat)DateFormat.getTimeInstance()).toPattern());
                    }
                }
            }
            return sb.toString();
        }

        private String getNullPattern(int type) {
            if (this.l.equals(Locale.CHINA)) {
                if (type == 0) {
                    return "yyyy-MM-dd";
                }
                return "HH:mm:ss";
            }
            if (type == 0) {
                return ((SimpleDateFormat)DateFormat.getDateInstance()).toPattern();
            }
            return ((SimpleDateFormat)DateFormat.getTimeInstance()).toPattern();
        }

        public void setEditable(boolean b) {
            if (this.isEnabled()) {
                if (this.spinner != null) {
                    ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().setEditable(b);
                } else if (this.ftf != null) {
                    this.ftf.setEditable(b);
                }
            }
        }

        public boolean isEditable() {
            if (this.spinner != null) {
                return ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().isEditable();
            }
            if (this.ftf != null) {
                return this.ftf.isEditable();
            }
            return false;
        }

        public void setRequired(boolean b) {
            if (this.isEnabled()) {
                if (this.spinner != null) {
                    this.spinner.setRequired(b);
                } else if (this.ftf != null) {
                    this.ftf.setRequired(b);
                }
            }
        }

        public boolean isRequired() {
            if (this.spinner != null) {
                return this.spinner.isRequired();
            }
            if (this.ftf != null) {
                return this.ftf.isRequired();
            }
            return false;
        }

        private void setValueByFormattedTextField(PropertyChangeEvent e) {
            Date newDate = (Date)e.getNewValue();
            Date oldDate = (Date)e.getOldValue();
            DataChangeEvent dce = new DataChangeEvent(DateTimeEditor.this.parent, newDate, oldDate);
            DateTimeEditor.this.model.setValue(newDate);
            DateTimeEditor.this.fireDataChanged(dce);
        }

        void setEAIsSupportedEmpty(boolean b) {
            if (this.ftf != null) {
                this.ftf.setPIsSupportedEmtpy(b);
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean b) {
            this.enabled = b;
            if (this.spinner != null) {
                this.spinner.setEnabled(b);
            } else if (this.ftf != null) {
                this.ftf.setEnabled(b);
            }
        }

        private void setValueBySpinner(ChangeEvent e) {
            Date newDate = (Date)this.spinner.getValue();
            Date oldDate = DateTimeEditor.this.model.getValue();
            DataChangeEvent dce = new DataChangeEvent(DateTimeEditor.this.parent, newDate, oldDate);
            this.m.setValue(newDate);
            DateTimeEditor.this.fireDataChanged(dce);
        }

        void setEditorAreaValue(Date date) {
            if (date != null) {
                Date oldDate;
                if (this.ftf != null) {
                    oldDate = (Date)this.ftf.getValue();
                    if (oldDate == null || oldDate.getTime() != date.getTime()) {
                        if (DateTimeEditor.this.fireListener) {
                            this.ftf.setValue(date);
                        } else {
                            this.ftf.setValue(date, false);
                        }
                    }
                    this.ftf.repaint();
                }
                if (this.spinner != null) {
                    oldDate = (Date)this.spinner.getValue();
                    if (oldDate == null || oldDate.getTime() != date.getTime()) {
                        this.timePickerEmpty = DateTimeEditor.this.model.isEmptyValue();
                        if (DateTimeEditor.this.fireListener) {
                            this.spinner.setValue(date);
                        } else {
                            this.spinner.setValue(date, false);
                        }
                    }
                    this.spinner.repaint();
                }
            } else if (this.ftf != null) {
                if (DateTimeEditor.this.fireListener) {
                    this.ftf.setValue(null);
                } else {
                    this.ftf.setValue(null, false);
                }
            } else if (this.spinner != null) {
                Calendar tempCal = Calendar.getInstance();
                tempCal.set(11, 0);
                tempCal.set(12, 0);
                tempCal.set(13, 0);
                tempCal.set(14, 0);
                if (DateTimeEditor.this.fireListener) {
                    this.spinner.setValue(tempCal.getTime());
                } else {
                    this.spinner.setValue(tempCal.getTime(), false);
                }
            }
        }

        Date getEditorAreaValue() {
            if (this.ftf != null) {
                return (Date)this.ftf.getValue();
            }
            if (this.spinner != null) {
                return (Date)this.spinner.getValue();
            }
            return null;
        }
    }

    class EditorPropertyChangeListener
    implements PropertyChangeListener {
        EditorPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("timeEnabled") || name.equals("milliSecondEnable")) {
                DateTimeEditor.this.configEditor();
            } else if (name.equals("editable")) {
                Boolean isEditable = (Boolean)e.getNewValue();
                DateTimeEditor.this.setEditable(isEditable);
            }
        }
    }
}

