/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.swing.BasicFormattedTextField;
import com.kingdee.cosmic.ctrl.swing.IBoundLabelControl;
import com.kingdee.cosmic.ctrl.swing.IKDComponent;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.common.i18n.CtrlSwingMessages;
import com.kingdee.cosmic.ctrl.swing.event.DataChangeEvent;
import com.kingdee.cosmic.ctrl.swing.event.DataChangeListener;
import com.kingdee.cosmic.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Currency;
import java.util.Locale;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.NumberFormatter;

public class KDCurrencyTextField
extends BasicFormattedTextField
implements IKDComponent,
IBoundLabelControl {
    private static final long serialVersionUID = 3283509326455283340L;
    private Object userObject = null;
    private Currency currentCurrency = null;
    public static final int SHORT_TYPE = 2;
    public static final int INTEGER_TYPE = 1;
    public static final int FLOAT_TYPE = 4;
    public static final int DOUBLE_TYPE = 5;
    public static final int BYTE_TYPE = 6;
    public static final int LONG_TYPE = 7;
    public static final int BIGDECIMAL_TYPE = 8;
    public static final int BIGINTEGER_TYPE = 10;
    public static final int FOCUS_VERIFIER = 11;
    public static final int INPUTING_VERIFIER = 12;
    public static final int NO_VERIFIER = -1;
    private int dataVerifierType = -1;
    private int dataType = -1;
    private int roundingMode = 4;
    private static final int DEFAULT_PRECISION = 4;
    private int precision = 4;
    private boolean isGroupingUsed = true;
    private Locale currencyLocale = null;
    private InnerPropertyChangeListener innerPropertyChangeListener = null;
    private static final Currency DEFAULT_CURRENCY = Currency.getInstance(Locale.CHINA);
    protected KDLabelContainer kdLabelContainer;
    private static final boolean DEBUG = false;
    private static int logscount = 0;
    private Insets customInsets;

    public KDCurrencyTextField() {
        this(null, (Currency)null);
    }

    public KDCurrencyTextField(Number value) {
        this(value, (Currency)null);
    }

    public KDCurrencyTextField(Number value, Locale l) {
        if (l == null) {
            l = Locale.CHINA;
        }
        this.currencyLocale = l;
        BigDecimal tempBig = this.setCurrencyValue(value, Currency.getInstance(l));
        this.init();
        this.setValue(tempBig);
    }

    public KDCurrencyTextField(Number value, Currency c) {
        BigDecimal tempBig = this.setCurrencyValue(value, c);
        this.init();
        this.setValue(tempBig);
    }

    public KDCurrencyTextField(Locale l) {
        this(null, l);
    }

    public KDCurrencyTextField(Currency c) {
        this(null, c);
    }

    private void init() {
        this.setFormatterFactory(this.generateFormatterFactory(4));
        this.innerPropertyChangeListener = new InnerPropertyChangeListener();
        this.addPropertyChangeListener(this.innerPropertyChangeListener);
        this.setInputVerifier(new FormattedTextFieldVerifier());
        this.setMaximumValue(CtrlSwingUtilities.BUS_MAX_BIGDECIMAL);
        this.setMinimumValue(CtrlSwingUtilities.BUS_MIN_BIGDECIMAL);
    }

    protected Currency getCurretncyByLocale(Locale l) {
        if (l != null) {
            return Currency.getInstance(l);
        }
        return DEFAULT_CURRENCY;
    }

    private BigDecimal setCurrencyValue(Object newData, Currency c) {
        if (c == null) {
            c = DEFAULT_CURRENCY;
        }
        this.currentCurrency = c;
        BigDecimal tempBig = null;
        if (newData instanceof String) {
            try {
                tempBig = new BigDecimal(newData.toString().trim());
            }
            catch (Exception exception) {}
        } else if (newData instanceof Number) {
            tempBig = new BigDecimal(newData.toString());
        }
        return tempBig;
    }

    public void setCurrency(Currency newCurrency) {
        Currency old;
        if (newCurrency == null) {
            newCurrency = DEFAULT_CURRENCY;
        }
        if ((old = this.getCurrency()) == null || !old.equals(newCurrency)) {
            this.currentCurrency = newCurrency;
            NumberFormat displayFormat = this.getDisplayFormat();
            if (displayFormat != null) {
                displayFormat.setCurrency(this.currentCurrency);
            }
            this.repaint();
        }
    }

    public void setCurrencySymbol(String currency) {
        DecimalFormat df = (DecimalFormat)this.getDisplayFormat();
        if (df != null) {
            DecimalFormatSymbols dfss = df.getDecimalFormatSymbols();
            dfss.setCurrencySymbol(currency);
            df.setDecimalFormatSymbols(dfss);
            this.repaint();
        }
    }

    public String getCurrencySymbol() {
        String currency = "";
        DecimalFormat df = (DecimalFormat)this.getDisplayFormat();
        if (df != null) {
            DecimalFormatSymbols dfss = df.getDecimalFormatSymbols();
            currency = dfss.getCurrencySymbol();
        }
        return currency;
    }

    public Currency getCurrency() {
        return this.currentCurrency;
    }

    public void setCurrencyLocale(Locale newLocale) {
        Currency old;
        if (newLocale == null) {
            newLocale = Locale.CHINA;
        }
        if ((old = this.getCurrency()) == null || !old.equals(Currency.getInstance(newLocale))) {
            this.setCurrency(Currency.getInstance(newLocale));
            this.currencyLocale = newLocale;
        }
    }

    public Locale getCurrencyLocale() {
        return this.currencyLocale;
    }

    @Override
    public Object getValue() {
        return this.getBigDecimalValue();
    }

    protected Format createIntTypeFormat(int newDataType) {
        DecimalFormat decFormat = (DecimalFormat)DecimalFormat.getCurrencyInstance(Locale.CHINA);
        if (this.getCurrency() != null) {
            decFormat.setCurrency(this.getCurrency());
        }
        decFormat.setDecimalSeparatorAlwaysShown(false);
        decFormat.setParseIntegerOnly(true);
        decFormat.setMinimumFractionDigits(0);
        decFormat.setMaximumFractionDigits(0);
        return decFormat;
    }

    protected JFormattedTextField.AbstractFormatter createIntTypeEditorFormatter(int newDataType) {
        DecimalFormat tempFormat = (DecimalFormat)DecimalFormat.getNumberInstance();
        tempFormat.setDecimalSeparatorAlwaysShown(false);
        tempFormat.setMinimumFractionDigits(0);
        tempFormat.setParseIntegerOnly(false);
        tempFormat.setGroupingUsed(false);
        NumberFormatter tempFormatter = new NumberFormatter(tempFormat);
        return tempFormatter;
    }

    protected JFormattedTextField.AbstractFormatter createIntTypeDisplayFormatter(int newDataType) {
        Format tempFormat = this.createIntTypeFormat(newDataType);
        if (this.isGroupingUsed()) {
            ((NumberFormat)tempFormat).setGroupingUsed(true);
        } else {
            ((NumberFormat)tempFormat).setGroupingUsed(false);
        }
        NumberFormatter tempFormatter = new NumberFormatter((NumberFormat)tempFormat);
        return tempFormatter;
    }

    protected Format createFloatTypeFormat(int newDataType) {
        DecimalFormat decFormat = (DecimalFormat)DecimalFormat.getCurrencyInstance(Locale.CHINA);
        if (this.getCurrency() != null) {
            decFormat.setCurrency(this.getCurrency());
            decFormat.setMinimumFractionDigits(this.getCurrency().getDefaultFractionDigits());
            decFormat.setMaximumFractionDigits(this.getCurrency().getDefaultFractionDigits());
        } else {
            decFormat.setMinimumFractionDigits(2);
        }
        decFormat.setDecimalSeparatorAlwaysShown(true);
        decFormat.setParseIntegerOnly(false);
        return decFormat;
    }

    protected JFormattedTextField.AbstractFormatter createFloatTypeEditorFormatter(int newDataType) {
        DecimalFormat tempFormat = (DecimalFormat)DecimalFormat.getNumberInstance();
        tempFormat.setDecimalSeparatorAlwaysShown(true);
        if (this.getCurrency() != null) {
            tempFormat.setMinimumFractionDigits(this.getCurrency().getDefaultFractionDigits());
            tempFormat.setMaximumFractionDigits(this.getCurrency().getDefaultFractionDigits());
        } else {
            tempFormat.setMinimumFractionDigits(2);
            tempFormat.setMaximumFractionDigits(2);
        }
        tempFormat.setParseIntegerOnly(false);
        tempFormat.setGroupingUsed(false);
        NumberFormatter tempFormatter = new NumberFormatter(tempFormat);
        return tempFormatter;
    }

    protected JFormattedTextField.AbstractFormatter createFloatTypeDisplayFormatter(int newDataType) {
        DecimalFormat tempFormat = (DecimalFormat)this.createFloatTypeFormat(newDataType);
        if (this.isGroupingUsed()) {
            tempFormat.setGroupingUsed(true);
        } else {
            tempFormat.setGroupingUsed(false);
        }
        NumberFormatter tempFormatter = new NumberFormatter(tempFormat);
        return tempFormatter;
    }

    protected JFormattedTextField.AbstractFormatter createNullValueFormatter(int newDataType) {
        return null;
    }

    protected JFormattedTextField.AbstractFormatterFactory generateFormatterFactory(int newDataType) {
        if (this.isValidateDateType(newDataType)) {
            this.dataType = newDataType;
            JFormattedTextField.AbstractFormatterFactory tempFactory = this.getFormatterFactory();
            if (tempFactory == null || !(tempFactory instanceof DefaultFormatterFactory)) {
                tempFactory = new DefaultFormatterFactory();
            }
            ((DefaultFormatterFactory)tempFactory).setNullFormatter(this.createNullValueFormatter(newDataType));
            switch (newDataType) {
                case 1: 
                case 2: 
                case 6: 
                case 7: 
                case 10: {
                    ((DefaultFormatterFactory)tempFactory).setEditFormatter(this.createIntTypeEditorFormatter(newDataType));
                    ((DefaultFormatterFactory)tempFactory).setDisplayFormatter(this.createIntTypeDisplayFormatter(newDataType));
                    break;
                }
                default: {
                    ((DefaultFormatterFactory)tempFactory).setEditFormatter(this.createFloatTypeEditorFormatter(newDataType));
                    ((DefaultFormatterFactory)tempFactory).setDisplayFormatter(this.createFloatTypeDisplayFormatter(newDataType));
                }
            }
            return tempFactory;
        }
        throw new IllegalArgumentException(CtrlSwingMessages.getMLS("KDCurrencyTextFieldDoesNotSupportDataType", "KDCurrencyTextField\u63a7\u4ef6\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\uff0c\u8bf7\u53c2\u89c1\u672c\u7c7b\u5b9a\u4e49\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b\u3002"));
    }

    protected JFormattedTextField.AbstractFormatterFactory generateFormatterFactory(Object value) {
        this.dataType = this.generateDataType(value);
        return this.generateFormatterFactory(this.dataType);
    }

    private int generateDataType(Object value) {
        int tempDataType = 8;
        if (value == null) {
            tempDataType = 8;
        } else if (Byte.class.isInstance(value)) {
            tempDataType = 6;
        } else if (Short.class.isInstance(value)) {
            tempDataType = 2;
        } else if (Integer.class.isInstance(value)) {
            tempDataType = 1;
        } else if (Long.class.isInstance(value)) {
            tempDataType = 7;
        } else if (Float.class.isInstance(value)) {
            tempDataType = 4;
        } else if (Double.class.isInstance(value)) {
            tempDataType = 5;
        } else if (BigDecimal.class.isInstance(value)) {
            tempDataType = 8;
        } else if (BigInteger.class.isInstance(value)) {
            tempDataType = 10;
        } else {
            throw new IllegalArgumentException(CtrlSwingMessages.getMLS("KDCurrencyTextFieldDoesNotSupportValueObjectType", "KDCurrencyTextField\u63a7\u4ef6\u4e0d\u652f\u6301\u8be5\u503c\u5bf9\u8c61\u7c7b\u578b\uff0c\u8bf7\u53c2\u89c1\u672c\u7c7b\u5b9a\u4e49\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b\u3002"));
        }
        return tempDataType;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        if (precision >= 0) {
            this.setMaximumFractionDigits(precision);
            this.setMinimumFractionDigits(precision);
        }
    }

    public void setRoundingMode(int newRoundingMode) {
        if (newRoundingMode != this.getRoundingMode()) {
            this.roundingMode = newRoundingMode;
        }
    }

    public int getRoundingMode() {
        return this.roundingMode;
    }

    private Object getSuperValue() {
        return super.getValue();
    }

    public Object getValue(Class c) {
        if (c != null) {
            String cName = c.getName();
            if (cName.equals("java.lang.Byte")) {
                return this.getByteValue();
            }
            if (cName.equals("java.lang.Short")) {
                return this.getShortValue();
            }
            if (cName.equals("java.lang.Integer")) {
                return this.getIntegerValue();
            }
            if (cName.equals("java.lang.Float")) {
                return this.getFloatValue();
            }
            if (cName.equals("java.lang.Double")) {
                return this.getDoubleValue();
            }
            if (cName.equals("java.lang.Long")) {
                return this.getLongValue();
            }
            if (cName.equals("java.math.BigDecimal")) {
                return this.getBigDecimalValue();
            }
            if (cName.equals("java.math.BigInteger")) {
                return this.getBigIntegerValue();
            }
            if (cName.equals("java.lang.String")) {
                return this.getStringValue();
            }
            throw new IllegalArgumentException("the Class[" + c + "] is not supported!");
        }
        return null;
    }

    public void setDataType(int newDataType) {
        int old;
        if (this.isValidateDateType(newDataType) && newDataType != (old = this.getDataType())) {
            this.dataType = newDataType;
            this.setFormatterFactory(this.generateFormatterFactory(this.dataType));
        }
    }

    public void setDataVerifierType(int newVerifierType) {
        int old = this.getDataVerifierType();
        if (newVerifierType != 11 && newVerifierType != 12) {
            newVerifierType = -1;
        }
        if (newVerifierType != old) {
            this.dataVerifierType = newVerifierType;
            InternationalFormatter ef = this.getEditorFormatter();
            if (this.dataVerifierType == 12 && ef != null) {
                ef.setAllowsInvalid(true);
            }
        }
    }

    public int getDataVerifierType() {
        return this.dataVerifierType;
    }

    public int getDataType() {
        return this.dataType;
    }

    public Number getNumberValue() {
        BigDecimal bigD = this.getBigDecimalValue();
        if (bigD != null) {
            switch (this.dataType) {
                case 6: {
                    return bigD.byteValue();
                }
                case 2: {
                    return bigD.shortValue();
                }
                case 1: {
                    return bigD.intValue();
                }
                case 4: {
                    return Float.valueOf(bigD.floatValue());
                }
                case 5: {
                    return bigD.doubleValue();
                }
                case 8: {
                    return bigD;
                }
                case 10: {
                    return bigD.toBigInteger();
                }
                case 7: {
                    return bigD.longValue();
                }
            }
            return bigD;
        }
        return null;
    }

    public BigDecimal getBigDecimalValue() {
        Object number = this.getSuperValue();
        BigDecimal bigDec = null;
        if (number != null) {
            if (number instanceof BigDecimal) {
                bigDec = (BigDecimal)number;
            } else if (number instanceof Number) {
                bigDec = new BigDecimal(number.toString());
            } else {
                return null;
            }
            try {
                BigDecimal tempBig = bigDec.setScale(2, this.getRoundingMode());
                return tempBig;
            }
            catch (ArithmeticException ae) {
                return bigDec;
            }
            catch (IllegalArgumentException ie) {
                return bigDec;
            }
        }
        return bigDec;
    }

    public BigInteger getBigIntegerValue() {
        BigDecimal bigDe = this.getBigDecimalValue();
        if (bigDe != null) {
            return bigDe.toBigInteger();
        }
        return null;
    }

    public Short getShortValue() {
        BigDecimal number = this.getBigDecimalValue();
        if (number != null) {
            return number.shortValue();
        }
        return null;
    }

    public Byte getByteValue() {
        BigDecimal number = this.getBigDecimalValue();
        if (number != null) {
            return number.byteValue();
        }
        return null;
    }

    public Integer getIntegerValue() {
        BigDecimal number = this.getBigDecimalValue();
        if (number != null) {
            return number.intValue();
        }
        return null;
    }

    public Long getLongValue() {
        BigDecimal number = this.getBigDecimalValue();
        if (number != null) {
            return number.longValue();
        }
        return null;
    }

    public Float getFloatValue() {
        BigDecimal number = this.getBigDecimalValue();
        if (number != null) {
            return new Float(number.floatValue());
        }
        return null;
    }

    public Double getDoubleValue() {
        BigDecimal number = this.getBigDecimalValue();
        if (number != null) {
            return new Double(number.doubleValue());
        }
        return null;
    }

    public String getStringValue() {
        Object obj = this.getSuperValue();
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public void addDataChangeListener(DataChangeListener l) {
        this.listenerList.add(DataChangeListener.class, l);
    }

    public void removeDataChangeListener(DataChangeListener l) {
        this.listenerList.remove(DataChangeListener.class, l);
    }

    protected void fireDataChangeListener(DataChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataChangeListener.class || event == null) continue;
            ((DataChangeListener)listeners[i + 1]).dataChanged(event);
        }
    }

    public void setGroupingUsed(boolean newGroupingUsed) {
        boolean old = this.isGroupingUsed();
        if (old != newGroupingUsed) {
            this.isGroupingUsed = newGroupingUsed;
            NumberFormat tempFormat = this.getDisplayFormat();
            if (tempFormat != null) {
                tempFormat.setGroupingUsed(this.isGroupingUsed);
                this.updateText();
            }
        }
    }

    private void updateText() {
        JFormattedTextField.AbstractFormatter af = this.getFormatter();
        if (af != null) {
            try {
                this.setText(af.valueToString(this.getValue()));
            }
            catch (ParseException pe) {
                this.setText("");
            }
        }
    }

    private InternationalFormatter getDisplayFormatter() {
        JFormattedTextField.AbstractFormatter tempFormatter;
        JFormattedTextField.AbstractFormatterFactory tempFactory = this.getFormatterFactory();
        if (tempFactory instanceof DefaultFormatterFactory && (tempFormatter = ((DefaultFormatterFactory)tempFactory).getDisplayFormatter()) instanceof InternationalFormatter) {
            return (InternationalFormatter)tempFormatter;
        }
        return null;
    }

    private NumberFormat getDisplayFormat() {
        Format tempFormat;
        InternationalFormatter tempFormatter = this.getDisplayFormatter();
        if (tempFormatter != null && (tempFormat = tempFormatter.getFormat()) instanceof NumberFormat) {
            return (NumberFormat)tempFormat;
        }
        return null;
    }

    private InternationalFormatter getEditorFormatter() {
        JFormattedTextField.AbstractFormatter tempFormatter;
        JFormattedTextField.AbstractFormatterFactory tempFactory = this.getFormatterFactory();
        if (tempFactory instanceof DefaultFormatterFactory && (tempFormatter = ((DefaultFormatterFactory)tempFactory).getEditFormatter()) instanceof InternationalFormatter) {
            return (InternationalFormatter)tempFormatter;
        }
        return null;
    }

    private NumberFormat getEditorFormat() {
        Format tempFormat;
        InternationalFormatter tempFormatter = this.getEditorFormatter();
        if (tempFormatter != null && (tempFormat = tempFormatter.getFormat()) instanceof NumberFormat) {
            return (NumberFormat)tempFormat;
        }
        return null;
    }

    public boolean isGroupingUsed() {
        return this.isGroupingUsed;
    }

    public void setMaximumFractionDigits(int newValue) {
        if (newValue >= 0) {
            this.precision = newValue;
            NumberFormat tempFormat = this.getEditorFormat();
            if (tempFormat != null) {
                tempFormat.setMaximumFractionDigits(newValue);
            }
            if ((tempFormat = this.getDisplayFormat()) != null) {
                tempFormat.setMaximumFractionDigits(newValue);
            }
        }
    }

    public void setMaximumIntegerDigits(int newValue) {
        NumberFormat tempFormat = this.getEditorFormat();
        if (tempFormat != null) {
            tempFormat.setMaximumIntegerDigits(newValue);
        }
        if ((tempFormat = this.getDisplayFormat()) != null) {
            tempFormat.setMaximumIntegerDigits(newValue);
        }
    }

    public void setMinimumFractionDigits(int newValue) {
        NumberFormat tempFormat = this.getEditorFormat();
        if (tempFormat != null) {
            tempFormat.setMinimumFractionDigits(newValue);
        }
        if ((tempFormat = this.getDisplayFormat()) != null) {
            tempFormat.setMinimumFractionDigits(newValue);
        }
    }

    public void setMinimumIntegerDigits(int newValue) {
        NumberFormat tempFormat = this.getEditorFormat();
        if (tempFormat != null) {
            tempFormat.setMinimumIntegerDigits(newValue);
        }
        if ((tempFormat = this.getDisplayFormat()) != null) {
            tempFormat.setMinimumIntegerDigits(newValue);
        }
    }

    public int getMaximumFractionDigits() {
        NumberFormat tempFormat = this.getEditorFormat();
        if (tempFormat != null) {
            return tempFormat.getMaximumFractionDigits();
        }
        return 6;
    }

    public int getMaximumIntegerDigits() {
        NumberFormat tempFormat = this.getEditorFormat();
        if (tempFormat != null) {
            return tempFormat.getMaximumIntegerDigits();
        }
        return 8;
    }

    public int getMinimumFractionDigits() {
        NumberFormat tempFormat = this.getEditorFormat();
        if (tempFormat != null) {
            return tempFormat.getMinimumFractionDigits();
        }
        return 3;
    }

    public int getMinimumIntegerDigits() {
        NumberFormat tempFormat = this.getEditorFormat();
        if (tempFormat != null) {
            return tempFormat.getMinimumIntegerDigits();
        }
        return 8;
    }

    private boolean isValidateDateType(int newDateType) {
        switch (newDateType) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setUserObject(Object newUserObject) {
        this.userObject = newUserObject;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    public void setMaximumValue(Comparable newMaxiValue) {
        InternationalFormatter tempFormatter = this.getEditorFormatter();
        if (tempFormatter != null && newMaxiValue != null) {
            tempFormatter.setMaximum(newMaxiValue);
        }
    }

    public Comparable getMaximumValue() {
        InternationalFormatter tempFormatter = this.getEditorFormatter();
        if (tempFormatter != null) {
            return tempFormatter.getMaximum();
        }
        return null;
    }

    public void setMinimumValue(Comparable newMiniValue) {
        InternationalFormatter tempFormatter = this.getEditorFormatter();
        if (tempFormatter != null && newMiniValue != null) {
            tempFormatter.setMinimum(newMiniValue);
        }
    }

    public Comparable getMinimumValue() {
        InternationalFormatter tempFormatter = this.getEditorFormatter();
        if (tempFormatter != null) {
            return tempFormatter.getMinimum();
        }
        return null;
    }

    protected int selfPrecision(int outPrecision) {
        return outPrecision;
    }

    private void logs(String info) {
    }

    @Override
    public void setValue(Object newDataValue) {
        BigDecimal tempBig = null;
        BigDecimal maxDecimal = new BigDecimal(this.getMaximumValue().toString().trim());
        BigDecimal minDecimal = new BigDecimal(this.getMinimumValue().toString().trim());
        if (newDataValue instanceof String) {
            try {
                tempBig = new BigDecimal(newDataValue.toString().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (newDataValue instanceof Number || newDataValue == null) {
            if (newDataValue != null && maxDecimal != null && minDecimal != null) {
                if (((Number)newDataValue).doubleValue() > ((Number)maxDecimal).doubleValue()) {
                    newDataValue = maxDecimal;
                }
                if (((Number)newDataValue).doubleValue() < ((Number)minDecimal).doubleValue()) {
                    newDataValue = minDecimal;
                }
            }
            super.setValue(newDataValue);
        } else if (tempBig != null) {
            if (((Number)tempBig).doubleValue() > ((Number)maxDecimal).doubleValue()) {
                tempBig = maxDecimal;
            }
            if (((Number)tempBig).doubleValue() < ((Number)minDecimal).doubleValue()) {
                tempBig = minDecimal;
            }
            super.setValue(tempBig);
        } else {
            throw new IllegalArgumentException(newDataValue.getClass().getName() + CtrlSwingMessages.getMLS("currencyEditControlDoesNotSupportDataType", " \u91d1\u989d\u7f16\u8f91\u63a7\u4ef6\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u3002"));
        }
    }

    @Override
    public void setLabelContainer(KDLabelContainer kdLabelContainer) {
        this.kdLabelContainer = kdLabelContainer;
    }

    @Override
    public KDLabelContainer getLabelContainer() {
        return this.kdLabelContainer;
    }

    @Override
    public void setBoundLabel(JLabel label) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabel(label);
        }
    }

    @Override
    public JLabel getBoundLabel() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabel();
        }
        return null;
    }

    @Override
    public void setBoundLabelAlignment(int alignment) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelAlignment(alignment);
        }
    }

    @Override
    public int getBoundLabelAlignment() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelAlignment();
        }
        return 7;
    }

    @Override
    public void setBoundLabelLength(int len) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelLength(len);
        }
    }

    @Override
    public int getBoundLabelLength() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelLength();
        }
        return 0;
    }

    @Override
    public void setBoundLabelText(String labelText) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelText(labelText);
        }
    }

    @Override
    public String getBoundLabelText() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelText();
        }
        return "";
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    @Override
    public void commitEdit() throws ParseException {
        String str = this.getText();
        if (str == null || str.length() <= 0) {
            this.setValue(null);
        } else {
            super.commitEdit();
        }
    }

    public class FormattedTextFieldVerifier
    extends InputVerifier {
        @Override
        public boolean verify(JComponent input) {
            JFormattedTextField ftf;
            JFormattedTextField.AbstractFormatter formatter;
            if (KDCurrencyTextField.this.dataVerifierType != 11) {
                return true;
            }
            if (input instanceof JFormattedTextField && (formatter = (ftf = (JFormattedTextField)input).getFormatter()) != null) {
                String text = ftf.getText();
                try {
                    formatter.stringToValue(text);
                    return true;
                }
                catch (ParseException pe) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean shouldYieldFocus(JComponent input) {
            return this.verify(input);
        }
    }

    protected class InnerPropertyChangeListener
    implements PropertyChangeListener {
        protected InnerPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String pName = evt.getPropertyName();
            if (pName != null && pName.equals("value")) {
                Object oldV = evt.getOldValue();
                Object newV = evt.getNewValue();
                boolean isFired = false;
                if (oldV == null && newV != null) {
                    isFired = true;
                } else if (oldV != null && newV != null && oldV instanceof Number && newV instanceof Number) {
                    BigDecimal oldBig = new BigDecimal(oldV.toString());
                    BigDecimal newBig = new BigDecimal(newV.toString());
                    if (!ArrayUtil.isEqual((Double)oldBig.doubleValue(), (Double)newBig.doubleValue())) {
                        isFired = true;
                    }
                    oldBig = null;
                    newBig = null;
                }
                if (isFired) {
                    DataChangeEvent dataEvent = new DataChangeEvent(evt.getSource(), evt.getOldValue(), evt.getNewValue());
                    KDCurrencyTextField.this.fireDataChangeListener(dataEvent);
                    if (KDCurrencyTextField.this.getValue() != null) {
                        KDCurrencyTextField.this.logs("current valus " + KDCurrencyTextField.this.getValue().getClass().getName());
                    }
                }
            }
        }
    }
}

