/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.swing.plaf.lfm.KDFontUIResource;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class KDFont
extends Font {
    private static final Logger log = LogUtil.getPackageLogger(KDFont.class);
    private static final long serialVersionUID = -5008956562051634709L;
    private static Properties fontProperties = null;
    private static String[] sysFamilyName;
    private static float fontScale;
    private int realSize;
    private static boolean isTableMode;
    private static boolean isFormDrawing;
    private Font formFont = null;

    public KDFont(String name, int style, int size) {
        super(name, style, Math.round((float)size * fontScale));
        this.realSize = size;
    }

    public KDFont(Map attributes) {
        super(attributes);
        Object obj = attributes.get(TextAttribute.SIZE);
        if (obj instanceof Integer) {
            this.realSize = (Integer)obj;
            this.realSize = Math.round((float)this.realSize / fontScale);
        }
    }

    @Override
    public int getSize() {
        return this.realSize;
    }

    public int getDrawingSize() {
        return super.getSize();
    }

    public Font deriveFont(Map attributes) {
        Map<TextAttribute, ?> newAttrs = this.getAttributes();
        AttributedCharacterIterator.Attribute[] validAttribs = this.getAvailableAttributes();
        for (int i = 0; i < validAttribs.length; ++i) {
            Object obj = attributes.get(validAttribs[i]);
            if (obj == null) continue;
            newAttrs.put((TextAttribute)validAttribs[i], obj);
        }
        return new KDFont(newAttrs);
    }

    public static void setTableMode(boolean is) {
        isTableMode = is;
    }

    public static void setFormDrawing(boolean is) {
        isFormDrawing = is;
    }

    public Font getFont() {
        if (isTableMode || !isFormDrawing) {
            return this;
        }
        if (this.formFont == null) {
            this.formFont = this.deriveFont((float)this.realSize);
        }
        return this.formFont;
    }

    public static Font createFont(String name, int style, int size) {
        Font font = null;
        try {
            font = KDFont.isSystemDefineFont(name) ? new Font(name, style, Math.round((float)size * fontScale)) : KDFont.loadFont(name, style, size);
        }
        catch (Exception e) {
            font = KDFont.loadFont(name, style, size);
        }
        return font;
    }

    public static Font createFont(Map attributes) {
        String name = (String)attributes.get(TextAttribute.FAMILY);
        int style = 0;
        Font font = null;
        try {
            if (KDFont.isSystemDefineFont(name)) {
                font = new Font(attributes);
            } else {
                float pointSize = ((Float)attributes.get(TextAttribute.SIZE)).floatValue();
                int size = (int)((double)pointSize + 0.5);
                Object obj = attributes.get(TextAttribute.WEIGHT);
                if (obj != null && obj.equals(TextAttribute.WEIGHT_BOLD)) {
                    style |= 1;
                }
                if ((obj = attributes.get(TextAttribute.POSTURE)) != null && obj.equals(TextAttribute.POSTURE_OBLIQUE)) {
                    style |= 2;
                }
                font = KDFont.loadFont(name, style, size);
            }
        }
        catch (Exception e) {
            float pointSize = ((Float)attributes.get(TextAttribute.SIZE)).floatValue();
            int size = (int)((double)pointSize + 0.5);
            Object obj = attributes.get(TextAttribute.WEIGHT);
            if (obj != null && obj.equals(TextAttribute.WEIGHT_BOLD)) {
                style |= 1;
            }
            if ((obj = attributes.get(TextAttribute.POSTURE)) != null && obj.equals(TextAttribute.POSTURE_OBLIQUE)) {
                style |= 2;
            }
            font = KDFont.loadFont(name, style, size);
        }
        return font;
    }

    /*
     * Exception decompiling
     */
    public static Font loadFont(String name, int style, int size) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isSystemDefineFont(String name) {
        if (sysFamilyName == null || sysFamilyName.length != 0) {
            sysFamilyName = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        }
        for (int i = 0; i < sysFamilyName.length; ++i) {
            if (!sysFamilyName[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    static {
        fontScale = KDFontUIResource.fontScale;
        isTableMode = false;
        isFormDrawing = false;
    }
}

