/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class KDLayout
implements LayoutManager2 {
    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(0x3FFFFFFF, 0x3FFFFFFF);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        JComponent jc = (JComponent)comp;
        if (constraints != null) {
            jc.putClientProperty("KDLayoutConstraints", constraints);
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public void layoutContainer(Container parent) {
        JComponent c = (JComponent)parent;
        Rectangle containerOriginalBounds = (Rectangle)c.getClientProperty("OriginalBounds");
        float scaleH = (float)c.getWidth() / (float)containerOriginalBounds.width;
        float scaleV = (float)c.getHeight() / (float)containerOriginalBounds.height;
        int count = c.getComponentCount();
        for (int i = 0; i < count; ++i) {
            float right;
            float bottom;
            JComponent item = (JComponent)c.getComponent(i);
            Constraints cons = (Constraints)item.getClientProperty("KDLayoutConstraints");
            if (cons == null) {
                System.out.println("The following component holds an illegal constraint status : " + item.getName() + " [class name : " + item.getClass().getName() + ", parent name : " + parent.getName() + "]");
                continue;
            }
            Rectangle originalRect = cons.originalBounds;
            Rectangle newRect = (Rectangle)cons.originalBounds.clone();
            if ((cons.anchor & 1) == 1) {
                newRect.y = originalRect.y;
            }
            if ((cons.anchor & 0x20) == 32) {
                newRect.y = (int)((float)originalRect.y * scaleV);
            }
            if ((cons.anchor & 2) == 2) {
                bottom = c.getHeight() - (containerOriginalBounds.height - (originalRect.y + originalRect.height));
                if ((cons.anchor & 1) == 0 && (cons.anchor & 0x20) == 0) {
                    newRect.y = (int)(bottom - (float)newRect.height);
                } else {
                    newRect.height = (int)(bottom - (float)newRect.y);
                }
            }
            if ((cons.anchor & 0x40) == 64) {
                bottom = (float)c.getHeight() - (float)(containerOriginalBounds.height - (originalRect.y + originalRect.height)) * scaleV;
                if ((cons.anchor & 1) == 0 && (cons.anchor & 0x20) == 0) {
                    newRect.y = (int)(bottom - (float)newRect.height);
                } else {
                    newRect.height = (int)(bottom - (float)newRect.y);
                }
            }
            if ((cons.anchor & 4) == 4) {
                newRect.x = originalRect.x;
            }
            if ((cons.anchor & 0x80) == 128) {
                newRect.x = (int)((float)originalRect.x * scaleH);
            }
            if ((cons.anchor & 8) == 8) {
                right = c.getWidth() - (containerOriginalBounds.width - (originalRect.x + originalRect.width));
                if ((cons.anchor & 4) == 0 && (cons.anchor & 0x80) == 0) {
                    newRect.x = (int)(right - (float)newRect.width);
                } else {
                    newRect.width = (int)(right - (float)newRect.x);
                }
            }
            if ((cons.anchor & 0x100) == 256) {
                right = (float)c.getWidth() - (float)(containerOriginalBounds.width - (originalRect.x + originalRect.width)) * scaleH;
                if ((cons.anchor & 4) == 0 && (cons.anchor & 0x80) == 0) {
                    newRect.x = (int)(right - (float)newRect.width);
                } else {
                    newRect.width = (int)(right - (float)newRect.x);
                }
            }
            if ((cons.anchor & 0x10) == 16) {
                float ocx = (float)containerOriginalBounds.width / 2.0f;
                float cx = (float)c.getWidth() / 2.0f;
                float ox = (float)originalRect.x + (float)originalRect.width / 2.0f;
                float delta = ocx - ox;
                newRect.x = (int)(cx - delta - (float)(newRect.width / 2));
            }
            item.setBounds(newRect);
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    public static class Constraints {
        public static final int ANCHOR_TOP = 1;
        public static final int ANCHOR_BOTTOM = 2;
        public static final int ANCHOR_LEFT = 4;
        public static final int ANCHOR_RIGHT = 8;
        public static final int ANCHOR_CENTRE = 16;
        public static final int ANCHOR_TOP_SCALE = 32;
        public static final int ANCHOR_BOTTOM_SCALE = 64;
        public static final int ANCHOR_LEFT_SCALE = 128;
        public static final int ANCHOR_RIGHT_SCALE = 256;
        public static final int ANCHOR_NONE = 0;
        public int anchor = 0;
        public Rectangle originalBounds;

        public Constraints() {
        }

        public Constraints(int anchor, Rectangle bounds) {
            this.anchor = anchor;
            this.originalBounds = bounds;
        }

        public Constraints(int x, int y, int w, int h, int anchor) {
            this.anchor = anchor;
            this.originalBounds = new Rectangle(x, y, w, h);
        }
    }
}

