/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.LittleArrowButton;
import com.kingdee.cosmic.ctrl.swing.SimpleMenuBarConstraints;
import com.kingdee.cosmic.ctrl.swing.SimpleMenuBarLayout;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeBorders;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class KDMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 2210621314523556835L;
    private Icon easIcon = null;
    private JLabel iconLab = null;
    private JLabel logoText = null;
    private HashMap selfMap = null;
    private static final int MENUINTERVAL = 0;

    public KDMenuBar() {
        this.init();
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
    }

    private void init() {
        this.setLayout(new SimpleMenuBarLayout());
        this.createLogoLab();
        this.setLogo();
        this.addDefaultHidenButton();
        this.setBorder(null);
    }

    protected void addDefaultHidenButton() {
        LittleArrowButton dArrowBu = new LittleArrowButton();
        this.add((Component)dArrowBu, (Object)new SimpleMenuBarConstraints("hidebutton", 0, 0));
    }

    public JComponent addRightComponent(JComponent menu, int rightInterval, Object identify) {
        this.addRightComponent(menu, rightInterval);
        this.setComponentIdentify(menu, identify);
        return menu;
    }

    public JComponent addRightComponent(JComponent menu, int rightInterval) {
        SimpleMenuBarConstraints cons = new SimpleMenuBarConstraints("backcons", this.getComponentCount() + 1, rightInterval);
        if (menu != null) {
            menu.setBackground(Color.decode("#E6EDF3"));
            menu.setOpaque(false);
            if (menu instanceof AbstractButton) {
                menu.setBorder(new KingdeeBorders.ToolBarButtonBorder());
                menu.setFocusable(false);
            }
        }
        super.add((Component)menu, cons);
        return menu;
    }

    @Override
    protected void addImpl(Component comp, Object constants, int index) {
        if (comp instanceof JMenu) {
            ((JMenu)comp).setOpaque(false);
            ((JMenu)comp).setRolloverEnabled(true);
        }
        if (constants == null || !(constants instanceof SimpleMenuBarConstraints)) {
            SimpleMenuBarConstraints cons = new SimpleMenuBarConstraints("frontcons", this.getComponentCount() + 1, 0);
            super.addImpl(comp, cons, index);
        } else {
            super.addImpl(comp, constants, index);
        }
    }

    @Override
    public Component add(Component comp, int index) {
        int tempIn = index;
        if (comp instanceof JMenu) {
            tempIn = this.getLogoLab() != null && this.logoText != null ? (tempIn += 3) : (this.getLogoLab() != null ? (tempIn += 2) : ++tempIn);
        }
        return super.add(comp, tempIn);
    }

    public void setMenuIdentify(JMenu menu, Object identify) {
        this.setComponentIdentify(menu, identify);
    }

    public void setComponentIdentify(JComponent comp, Object identify) {
        if (identify == null || comp == null) {
            throw new NullPointerException("JComponent or identify not is null.");
        }
        this.getSelfMap().put(identify, comp);
    }

    public Object getMenuIdentify(JMenu menu) {
        return this.getComponentIdentify(menu);
    }

    public Object getComponentIdentify(JComponent comp) {
        boolean b = this.getSelfMap().containsValue(comp);
        if (b) {
            for (Object obj : this.getSelfMap().keySet()) {
                if (this.getSelfMap().get(obj) != comp) continue;
                return obj;
            }
            return null;
        }
        return null;
    }

    public JMenu add(JMenu menu, Object identify) {
        super.add(menu);
        this.setComponentIdentify(menu, identify);
        return menu;
    }

    public JMenu getMenu(Object identify) {
        JComponent comp = this.getComponent(identify);
        if (comp instanceof JMenu) {
            return (JMenu)comp;
        }
        return null;
    }

    public JComponent getComponent(Object identify) {
        Object obj = this.getSelfMap().get(identify);
        if (obj instanceof JComponent) {
            return (JComponent)obj;
        }
        return null;
    }

    public boolean removeMenu(Object identify) {
        try {
            JComponent obj = this.getComponent(identify);
            if (obj != null) {
                this.remove(obj);
                this.getSelfMap().remove(identify);
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public Object[] getMenuIdentifys() {
        Set set = this.getSelfMap().keySet();
        if (set.size() > 0) {
            return set.toArray();
        }
        return null;
    }

    public void setLogo(Icon icon) {
        if (this.getLogoLab() == null) {
            return;
        }
        if (icon != null) {
            this.easIcon = icon;
            this.getLogoLab().setText("");
            this.getLogoLab().setIcon(icon);
            this.getLogoLab().setOpaque(true);
            Dimension dim = new Dimension(icon.getIconWidth(), icon.getIconHeight());
            this.getLogoLab().setPreferredSize(dim);
            this.getLogoLab().setMaximumSize(dim);
            this.getLogoLab().setMinimumSize(dim);
        } else {
            this.getLogoLab().setIcon(null);
            this.getLogoLab().setOpaque(false);
        }
    }

    public void setLogo() {
        if (this.getLogoLab() != null) {
            this.easIcon = UIManager.getIcon("kingdee.logo");
            this.setLogo(this.easIcon);
        }
    }

    public void hideLogo() {
        if (this.getLogoLab() != null) {
            this.getLogoLab().setVisible(false);
        }
    }

    public Icon getLogo() {
        return this.easIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap getSelfMap() {
        if (this.selfMap == null) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.selfMap = new HashMap();
            }
        }
        return this.selfMap;
    }

    protected void createLogoLab() {
        if (this.iconLab == null) {
            this.iconLab = new JLabel();
            this.iconLab.setBackground(new Color(0, 0, 0, 0));
            this.iconLab.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    public JLabel getLogoLab() {
        return this.iconLab;
    }

    @Override
    public void setToolTipText(String text) {
    }

    @Override
    public JMenu getMenu(int index) {
        if (this.logoText != null) {
            return super.getMenu(index + 3);
        }
        return super.getMenu(index + 2);
    }

    @Override
    public int getMenuCount() {
        if (this.logoText != null) {
            return this.getComponentCount() - 3;
        }
        return this.getComponentCount() - 2;
    }
}

