/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.IBoundLabelControl;
import com.kingdee.cosmic.ctrl.swing.IKDComponent;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.LimitedLengthDocument;
import com.kingdee.cosmic.ctrl.swing.TextLengthVerifier;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeePasswordFieldUI;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;

public class KDPasswordField
extends JPasswordField
implements IKDComponent,
IBoundLabelControl {
    private static final long serialVersionUID = -3319665021128728150L;
    protected Object userObject = null;
    protected KDLabelContainer kdLabelContainer;
    private Insets customInsets;
    public static final String undoAction = "undo-KDPasswordField";
    public static final String redoAction = "redo-KDPasswordField";
    public UndoManager manager = null;
    protected TextLengthVerifier verifier = null;

    public KDPasswordField() {
        this.init();
    }

    public KDPasswordField(String text) {
        super(text);
        this.init();
    }

    public KDPasswordField(int columns) {
        super(columns);
        this.init();
    }

    public KDPasswordField(String text, int columns) {
        super(text, columns);
        this.init();
    }

    public KDPasswordField(Document doc, String txt, int columns) {
        super(doc, txt, columns);
        this.init();
    }

    private void init() {
        if (this.manager == null) {
            this.manager = new UndoManager();
        }
        this.getDocument().addUndoableEditListener(this.manager);
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public void setLabelContainer(KDLabelContainer kdLabelContainer) {
        this.kdLabelContainer = kdLabelContainer;
    }

    @Override
    public KDLabelContainer getLabelContainer() {
        return this.kdLabelContainer;
    }

    @Override
    public void setBoundLabel(JLabel label) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabel(label);
        }
    }

    @Override
    public JLabel getBoundLabel() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabel();
        }
        return null;
    }

    @Override
    public void setBoundLabelAlignment(int alignment) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelAlignment(alignment);
        }
    }

    @Override
    public int getBoundLabelAlignment() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelAlignment();
        }
        return 7;
    }

    @Override
    public void setBoundLabelLength(int len) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelLength(len);
        }
    }

    @Override
    public int getBoundLabelLength() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelLength();
        }
        return 0;
    }

    @Override
    public void setBoundLabelText(String labelText) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelText(labelText);
        }
    }

    @Override
    public String getBoundLabelText() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelText();
        }
        return "";
    }

    @Override
    public void updateUI() {
        this.setUI(KingdeePasswordFieldUI.createUI(this));
    }

    private LimitedLengthDocument getLimitedLengthDocument() {
        Document doc = this.getDocument();
        if (doc instanceof LimitedLengthDocument) {
            return (LimitedLengthDocument)doc;
        }
        return null;
    }

    public void setText(String t, boolean fireListenner) {
        if (fireListenner) {
            this.setText(t);
        } else {
            int i;
            DocumentListener[] savedDocumentListeners = ((AbstractDocument)this.getDocument()).getDocumentListeners();
            for (i = 0; i < savedDocumentListeners.length; ++i) {
                this.getDocument().removeDocumentListener(savedDocumentListeners[i]);
            }
            this.setText(t);
            for (i = 0; i < savedDocumentListeners.length; ++i) {
                this.getDocument().addDocumentListener(savedDocumentListeners[i]);
            }
            this.repaint();
        }
    }

    protected TextLengthVerifier getTextLengthVerifier() {
        if (this.verifier == null) {
            this.verifier = new TextLengthVerifier();
            this.setInputVerifier(this.verifier);
        }
        return this.verifier;
    }

    public void setMaxLength(int len) {
        if (len < -1) {
            return;
        }
        LimitedLengthDocument doc = this.getLimitedLengthDocument();
        if (doc != null) {
            doc.setMaxLength(len);
        }
        this.getTextLengthVerifier().setMaxLength(len);
    }

    public int getMaxLength() {
        LimitedLengthDocument doc = this.getLimitedLengthDocument();
        if (doc != null) {
            return doc.getMaxLength();
        }
        return -1;
    }

    public void setMinLength(int len) {
        LimitedLengthDocument doc = this.getLimitedLengthDocument();
        if (doc != null) {
            doc.setMinLength(len);
        }
        this.getTextLengthVerifier().setMinLength(len);
    }

    public int getMinLength() {
        LimitedLengthDocument doc = this.getLimitedLengthDocument();
        if (doc != null) {
            return doc.getMinLength();
        }
        return 0;
    }

    @Override
    protected Document createDefaultModel() {
        LimitedLengthDocument doc = new LimitedLengthDocument();
        return doc;
    }
}

