/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.IKDComponent;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeBorders;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeProgressBarUI;
import com.kingdee.cosmic.ctrl.swing.resource.KDResourceManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Window;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class KDProgressBar
extends JProgressBar
implements IKDComponent {
    private static final long serialVersionUID = -5232661550634860150L;
    protected static Border border;
    protected Color foreground = null;
    protected Object userObject = null;
    private Insets customInsets;
    protected Image image = null;
    protected Popup popup = null;
    protected boolean popupShow = false;

    public KDProgressBar() {
        this.initProp();
        this.setBorder(border);
    }

    public void initProp() {
        border = KingdeeBorders.createBevelBorder(true, UIManager.getColor("ProgressBar.bordercolordark"), UIManager.getColor("ProgressBar.bordercolorlight"));
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public KDProgressBar(BoundedRangeModel newModel) {
        super(newModel);
        this.initProp();
        this.setBorder(border);
    }

    public KDProgressBar(int orient) {
        super(orient);
        this.initProp();
        this.setBorder(border);
    }

    public KDProgressBar(int min, int max) {
        super(min, max);
        this.initProp();
        this.setBorder(border);
    }

    public KDProgressBar(int orient, int min, int max) {
        super(orient, min, max);
        this.initProp();
        this.setBorder(border);
    }

    @Override
    public void updateUI() {
        this.setUI(KingdeeProgressBarUI.createUI(this));
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    @Override
    public void setForeground(Color fg) {
        this.foreground = fg;
    }

    @Override
    public Color getForeground() {
        if (this.foreground != null) {
            return this.foreground;
        }
        return UIManager.getColor("ProgressBar.cellscolor");
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public boolean isPopupShow() {
        return this.popupShow;
    }

    public void setPopupShow(boolean show) {
        if (show == this.popupShow) {
            return;
        }
        this.popupShow = show;
        if (this.popupShow && this.popup == null) {
            this.popup = this.getPopup();
        }
        if (this.popupShow) {
            this.popup.show();
        } else {
            this.popup.hide();
            this.popup = null;
        }
    }

    protected Popup getPopup() {
        ImagePane pane = new ImagePane();
        Window window = SwingUtilities.getWindowAncestor(this);
        Point pt = this.getLocationOnScreen();
        if (this.getOrientation() == 0) {
            pt.y -= pane.getHeight();
        } else {
            pt.x -= pane.getWidth();
        }
        PopupFactory factory = PopupFactory.getSharedInstance();
        Popup pop = factory.getPopup(window, pane, pt.x, pt.y);
        return pop;
    }

    protected class ImagePane
    extends JComponent {
        private static final long serialVersionUID = -1616582500500546186L;

        public ImagePane() {
            Image img = KDProgressBar.this.getImage();
            if (img == null) {
                img = KDResourceManager.getImageByDefault("progressbar_popup.gif");
                KDProgressBar.this.setImage(img);
            }
            if (img != null) {
                MediaTracker tracker = new MediaTracker(this);
                tracker.addImage(img, 0);
                try {
                    tracker.waitForID(0);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                int imgw = img.getWidth(this);
                int imgh = img.getHeight(this);
                Dimension d = new Dimension(imgw, imgh);
                this.setPreferredSize(d);
                this.setSize(d);
                this.setBorder(KingdeeBorders.createEditorBorder());
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            Insets insets = this.getInsets();
            int w = this.getWidth();
            int h = this.getHeight();
            GradientPaint bkpaint = new GradientPaint(insets.left, insets.top, Color.LIGHT_GRAY, insets.left, h - insets.bottom, Color.WHITE);
            g2.setPaint(bkpaint);
            g2.fillRect(insets.left, insets.top, w - insets.left - insets.right, h - insets.top - insets.bottom);
            Image img = KDProgressBar.this.getImage();
            if (img != null) {
                int imgw = img.getWidth(this);
                int imgh = img.getHeight(this);
                g.drawImage(KDProgressBar.this.image, (w - imgw) / 2, (h - imgh) / 2, this);
            }
        }
    }
}

