/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.BarPartArea;
import com.kingdee.cosmic.ctrl.swing.KDStatusBar;
import com.kingdee.cosmic.ctrl.swing.helper.KDHelperBar;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JToolBar;

public class KDSkinRootPane
extends JRootPane {
    private static final long serialVersionUID = 8077007569485806239L;
    private BarPartArea eastPane = null;
    private BarPartArea southPane = null;
    private BarPartArea westPane = null;
    private BarPartArea northPane = null;
    private static final boolean DEBUG = false;
    private static final boolean TIMEBUG = false;
    private ToolMenuBarManager toolMenuBarManager = null;

    public KDSkinRootPane() {
        this.initData();
    }

    public void addToolBar(JToolBar toolBar, int orientation) {
        this.getToolMenuBarManager().addInnerToolMenuStatusBar(toolBar, orientation, null);
    }

    public JToolBar[] getToolBars() {
        return this.getToolMenuBarManager().getInnerAllToolBar();
    }

    public KDStatusBar getStatusBar() {
        return this.getToolMenuBarManager().getInnerStatusBar();
    }

    public void setStatusBar(KDStatusBar statusBar) {
        this.getToolMenuBarManager().addInnerToolMenuStatusBar(statusBar, 5, null);
    }

    public void setHelperBar(KDHelperBar helperBar) {
        this.getToolMenuBarManager().addInnerToolMenuStatusBar(helperBar, 3, null);
    }

    @Override
    public void setJMenuBar(JMenuBar menuBar) {
        this.getToolMenuBarManager().addInnerToolMenuStatusBar(menuBar, 1, null);
    }

    @Override
    public void setMenuBar(JMenuBar menu) {
        this.setJMenuBar(menu);
    }

    @Override
    public JMenuBar getJMenuBar() {
        return this.getToolMenuBarManager().getInnerJMenuBar();
    }

    @Override
    public JMenuBar getMenuBar() {
        return this.getToolMenuBarManager().getInnerJMenuBar();
    }

    @Override
    protected LayoutManager createRootLayout() {
        return new SkinRootLayout();
    }

    public void addToolBar(JToolBar toolBar, int orientation, Object identify) {
        this.getToolMenuBarManager().addInnerToolMenuStatusBar(toolBar, orientation, identify);
    }

    public JToolBar getToolBar(Object identify) {
        return this.getToolMenuBarManager().getJToolBarByIdentify(identify);
    }

    public void removeJMenuBar(JMenuBar menuBar) {
        this.getToolMenuBarManager().removeInnerToolMenuStatusBar(menuBar);
    }

    public void removeStatusBar(KDStatusBar statusBar) {
        this.getToolMenuBarManager().removeInnerToolMenuStatusBar(statusBar);
    }

    public void removeHelperBar(KDHelperBar helperBar) {
        this.getToolMenuBarManager().removeInnerToolMenuStatusBar(helperBar);
    }

    public void removeAllStatusBar() {
        this.getBarPartAreaOfOrientation(5).removeAllKDStatusBar();
    }

    public void removeToolBar(JToolBar toolbar) {
        this.getToolMenuBarManager().removeInnerToolMenuStatusBar(toolbar);
    }

    public void removeToolBarByIdentify(Object identify) {
        this.getToolMenuBarManager().removeInnerToolBarByIdentify(identify);
    }

    public void setToolBarIdentify(JToolBar toolBar, Object identify) {
        this.getToolMenuBarManager().setInnerToolBarIdentify(toolBar, identify);
    }

    public void removeAllToolBar() {
        this.getToolMenuBarManager().removeInnerAllToolBar();
    }

    ToolMenuBarManager getToolMenuBarManager() {
        if (this.toolMenuBarManager == null) {
            this.toolMenuBarManager = new ToolMenuBarManager();
        }
        return this.toolMenuBarManager;
    }

    protected void initData() {
        this.eastPane = new BarPartArea(3);
        this.setPartArea(this.eastPane);
        this.southPane = new BarPartArea(5);
        this.setPartArea(this.southPane);
        this.westPane = new BarPartArea(7);
        this.setPartArea(this.westPane);
        this.northPane = new BarPartArea(1);
        this.setPartArea(this.northPane);
    }

    private void setPartArea(BarPartArea partArea) {
        if (partArea == null) {
            throw new IllegalComponentStateException("partArea cannot be set to null.");
        }
        if (partArea != null && partArea.getParent() == this.layeredPane) {
            this.layeredPane.remove(partArea);
        }
        switch (partArea.getAreaOrientation()) {
            case 3: {
                this.eastPane = partArea;
                break;
            }
            case 5: {
                this.southPane = partArea;
                break;
            }
            case 7: {
                this.westPane = partArea;
                break;
            }
            case 1: {
                this.northPane = partArea;
                break;
            }
            default: {
                throw new IllegalComponentStateException("partArea's areaOrientation  donot setting.");
            }
        }
        this.layeredPane.add((Component)partArea, JLayeredPane.FRAME_CONTENT_LAYER);
    }

    public BarPartArea getBarPartAreaOfOrientation(int orientation) {
        switch (orientation) {
            case 3: {
                return this.eastPane;
            }
            case 5: {
                return this.southPane;
            }
            case 7: {
                return this.westPane;
            }
            case 1: {
                return this.northPane;
            }
        }
        return null;
    }

    private void logs(String info) {
    }

    protected class ToolMenuBarManager
    implements Serializable {
        private static final long serialVersionUID = 1838388074974465758L;
        private Hashtable toolBarHash = new Hashtable(0);

        public void addInnerToolMenuStatusBar(JComponent comp, int orientation, Object identify) {
            if (comp == null) {
                return;
            }
            switch (orientation) {
                case 3: {
                    KDSkinRootPane.this.getBarPartAreaOfOrientation(3).addSanBar(comp);
                    break;
                }
                case 5: {
                    KDSkinRootPane.this.getBarPartAreaOfOrientation(5).addSanBar(comp);
                    break;
                }
                case 7: {
                    KDSkinRootPane.this.getBarPartAreaOfOrientation(7).addSanBar(comp);
                    break;
                }
                case 1: {
                    KDSkinRootPane.this.getBarPartAreaOfOrientation(1).addSanBar(comp);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("orientation is illegal.");
                }
            }
            if (!(comp instanceof KDHelperBar) && comp instanceof JToolBar && identify != null) {
                this.setInnerToolBarIdentify((JToolBar)comp, identify);
            }
        }

        public void removeInnerToolMenuStatusBar(JComponent comp) {
            if (comp == null) {
                return;
            }
            if (comp instanceof KDHelperBar) {
                Container c = comp.getParent();
                if (c != null) {
                    c.remove(comp);
                }
            } else if (comp instanceof JToolBar) {
                Container tempContainer = comp.getParent().getParent();
                if (tempContainer != null) {
                    if (tempContainer instanceof BarPartArea) {
                        KDSkinRootPane.this.logs("succeed to remove toolbar  int BarPartArea[" + ((BarPartArea)tempContainer).getAreaOrientation() + "]");
                        ((BarPartArea)tempContainer).removeSanBar(comp);
                        Object identify = this.getIdentifyByJToolBar((JToolBar)comp);
                        if (identify != null) {
                            this.getToolBarHash().remove(identify);
                        }
                    } else {
                        tempContainer.remove(comp);
                    }
                }
            } else if (comp instanceof JMenuBar) {
                KDSkinRootPane.this.getBarPartAreaOfOrientation(1).removeSanBar((JMenuBar)comp);
            } else if (comp instanceof KDStatusBar) {
                KDSkinRootPane.this.getBarPartAreaOfOrientation(5).removeSanBar((KDStatusBar)comp);
            }
        }

        public void removeInnerToolBarByIdentify(Object identify) {
            JToolBar tempToolBar = this.getJToolBarByIdentify(identify);
            if (tempToolBar != null) {
                this.removeInnerToolMenuStatusBar(tempToolBar);
            }
        }

        public void setInnerToolBarIdentify(JToolBar toolBar, Object identify) {
            if (toolBar != null) {
                if (identify != null) {
                    if (this.getToolBarHash().containsKey(identify)) {
                        if (this.getToolBarHash().get(identify) != toolBar) {
                            throw new IllegalArgumentException("identify doesn't is uniquely,it was defined.");
                        }
                    } else if (this.getValus().contains(toolBar)) {
                        Enumeration keys = this.getKeys();
                        while (keys.hasMoreElements()) {
                            Object tempKey = keys.nextElement();
                            if (this.getToolBarHash().get(tempKey) != toolBar) continue;
                            this.getToolBarHash().remove(tempKey);
                            this.getToolBarHash().put(identify, toolBar);
                            break;
                        }
                    } else {
                        this.getToolBarHash().put(identify, toolBar);
                    }
                } else {
                    throw new NullPointerException("identify of JToolBar is null.");
                }
            }
        }

        public JToolBar getJToolBarByIdentify(Object identify) {
            Object obj = this.getToolBarHash().get(identify);
            if (obj instanceof JToolBar) {
                return (JToolBar)obj;
            }
            return null;
        }

        public Object getIdentifyByJToolBar(JToolBar toolBar) {
            if (toolBar == null) {
                return null;
            }
            Enumeration enu = this.getKeys();
            while (enu.hasMoreElements()) {
                Object identify = enu.nextElement();
                JToolBar tempBar = this.getJToolBarByIdentify(identify);
                if (null == tempBar || tempBar != toolBar) continue;
                return identify;
            }
            return null;
        }

        public KDStatusBar getInnerStatusBar() {
            return KDSkinRootPane.this.getBarPartAreaOfOrientation(5).getKDStatusBar();
        }

        public JMenuBar getInnerJMenuBar() {
            return KDSkinRootPane.this.getBarPartAreaOfOrientation(1).getJMenuBar();
        }

        private Enumeration getKeys() {
            return this.getToolBarHash().keys();
        }

        private Collection getValus() {
            return this.getToolBarHash().values();
        }

        public JToolBar[] getInnerAllToolBar() {
            Object[] obj = this.getValus().toArray();
            if (obj != null && obj.length > 0) {
                JToolBar[] tempToolBar = new JToolBar[obj.length];
                System.arraycopy(obj, 0, tempToolBar, 0, obj.length);
                return tempToolBar;
            }
            return null;
        }

        public Hashtable getToolBarHash() {
            if (this.toolBarHash == null) {
                this.toolBarHash = new Hashtable(0);
            }
            return this.toolBarHash;
        }

        public void removeInnerAllToolBar() {
            KDSkinRootPane.this.getBarPartAreaOfOrientation(1).removeAllJToolBar();
            KDSkinRootPane.this.getBarPartAreaOfOrientation(3).removeAllJToolBar();
            KDSkinRootPane.this.getBarPartAreaOfOrientation(5).removeAllJToolBar();
            KDSkinRootPane.this.getBarPartAreaOfOrientation(7).removeAllJToolBar();
            this.getToolBarHash().clear();
        }
    }

    protected class SkinRootLayout
    implements LayoutManager2,
    Serializable {
        private static final long serialVersionUID = -7019290829074905718L;

        protected SkinRootLayout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension d;
                Dimension pD = parent.getSize();
                Dimension dim = new Dimension(0, 0);
                if (KDSkinRootPane.this.eastPane != null && KDSkinRootPane.this.eastPane.isVisible()) {
                    d = KDSkinRootPane.this.eastPane.getPreferredSize();
                    dim.width += d.width;
                }
                if (KDSkinRootPane.this.westPane != null && KDSkinRootPane.this.westPane.isVisible()) {
                    d = KDSkinRootPane.this.westPane.getPreferredSize();
                    dim.width += d.width;
                }
                if (KDSkinRootPane.this.contentPane != null) {
                    d = KDSkinRootPane.this.contentPane.getPreferredSize();
                    dim.width += d.width;
                    dim.height += d.height;
                } else {
                    dim.width += pD.width;
                    dim.height += pD.height;
                }
                if (KDSkinRootPane.this.northPane != null && KDSkinRootPane.this.northPane.isVisible()) {
                    d = KDSkinRootPane.this.northPane.getPreferredSize();
                    dim.height += d.height;
                }
                if (KDSkinRootPane.this.southPane != null && KDSkinRootPane.this.southPane.isVisible()) {
                    d = KDSkinRootPane.this.southPane.getPreferredSize();
                    dim.height += d.height;
                }
                if (KDSkinRootPane.this.contentPane != null) {
                    Insets insets = KDSkinRootPane.this.contentPane.getInsets();
                    dim.width += insets.left + insets.right;
                    dim.height += insets.top + insets.bottom;
                }
                return dim;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension d;
                Dimension dim = new Dimension(0, 0);
                Dimension pD = parent.getSize();
                if (KDSkinRootPane.this.eastPane != null && KDSkinRootPane.this.eastPane.isVisible()) {
                    d = KDSkinRootPane.this.eastPane.getMinimumSize();
                    dim.width += d.width;
                }
                if (KDSkinRootPane.this.westPane != null && KDSkinRootPane.this.westPane.isVisible()) {
                    d = KDSkinRootPane.this.westPane.getMinimumSize();
                    dim.width += d.width;
                }
                if (KDSkinRootPane.this.contentPane != null) {
                    d = KDSkinRootPane.this.contentPane.getMinimumSize();
                    dim.width += d.width;
                    dim.height += d.height;
                } else {
                    dim.width += pD.width;
                    dim.height += pD.height;
                }
                if (KDSkinRootPane.this.northPane != null && KDSkinRootPane.this.northPane.isVisible()) {
                    d = KDSkinRootPane.this.northPane.getMinimumSize();
                    dim.height += d.height;
                }
                if (KDSkinRootPane.this.southPane != null && KDSkinRootPane.this.southPane.isVisible()) {
                    d = KDSkinRootPane.this.southPane.getMinimumSize();
                    dim.height += d.height;
                }
                if (KDSkinRootPane.this.contentPane != null) {
                    Insets insets = KDSkinRootPane.this.contentPane.getInsets();
                    dim.width += insets.left + insets.right;
                    dim.height += insets.top + insets.bottom;
                }
                return dim;
            }
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Rectangle b = parent.getBounds();
            Insets i = KDSkinRootPane.this.getInsets();
            int w = b.width - i.right - i.left;
            int h = b.height - i.top - i.bottom;
            if (KDSkinRootPane.this.layeredPane != null) {
                KDSkinRootPane.this.layeredPane.setBounds(i.left, i.top, w, h);
            }
            if (KDSkinRootPane.this.glassPane != null) {
                KDSkinRootPane.this.glassPane.setBounds(i.left, i.top, w, h);
            }
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension d;
                Insets insets = parent.getInsets();
                int top = insets.top;
                int bottom = parent.getHeight() - insets.bottom;
                int left = insets.left;
                int right = parent.getWidth() - insets.right;
                if (KDSkinRootPane.this.northPane != null && KDSkinRootPane.this.northPane.isVisible()) {
                    KDSkinRootPane.this.northPane.setSize(right - left, KDSkinRootPane.this.northPane.getHeight());
                    d = KDSkinRootPane.this.northPane.getPreferredSize();
                    KDSkinRootPane.this.northPane.setBounds(left, top, right - left, d.height);
                    top += d.height;
                }
                if (KDSkinRootPane.this.southPane != null && KDSkinRootPane.this.southPane.isVisible()) {
                    KDSkinRootPane.this.southPane.setSize(right - left, KDSkinRootPane.this.southPane.getHeight());
                    d = KDSkinRootPane.this.southPane.getPreferredSize();
                    KDSkinRootPane.this.southPane.setBounds(left, bottom - d.height, right - left, d.height);
                    bottom -= d.height;
                }
                if (KDSkinRootPane.this.eastPane != null && KDSkinRootPane.this.eastPane.isVisible()) {
                    KDSkinRootPane.this.eastPane.setSize(KDSkinRootPane.this.eastPane.getWidth(), bottom - top);
                    d = KDSkinRootPane.this.eastPane.getPreferredSize();
                    KDSkinRootPane.this.eastPane.setBounds(right - d.width, top, d.width, bottom - top);
                    right -= d.width;
                }
                if (KDSkinRootPane.this.westPane != null && KDSkinRootPane.this.westPane.isVisible()) {
                    KDSkinRootPane.this.westPane.setSize(KDSkinRootPane.this.westPane.getWidth(), bottom - top);
                    d = KDSkinRootPane.this.westPane.getPreferredSize();
                    KDSkinRootPane.this.westPane.setBounds(left, top, d.width, bottom - top);
                    left += d.width;
                }
                if (KDSkinRootPane.this.contentPane != null && KDSkinRootPane.this.contentPane.isVisible()) {
                    KDSkinRootPane.this.contentPane.setBounds(left, top, right - left, bottom - top);
                }
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeLayoutComponent(Component comp) {
            Object object = comp.getTreeLock();
            synchronized (object) {
                if (comp == KDSkinRootPane.this.contentPane) {
                    KDSkinRootPane.this.contentPane = null;
                } else if (comp == KDSkinRootPane.this.northPane) {
                    KDSkinRootPane.this.northPane = null;
                } else if (comp == KDSkinRootPane.this.southPane) {
                    KDSkinRootPane.this.southPane = null;
                } else if (comp == KDSkinRootPane.this.eastPane) {
                    KDSkinRootPane.this.eastPane = null;
                } else if (comp == KDSkinRootPane.this.westPane) {
                    KDSkinRootPane.this.westPane = null;
                }
            }
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }
    }
}

