/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.kdf.expr.Variant;
import com.kingdee.cosmic.ctrl.swing.IBoundLabelControl;
import com.kingdee.cosmic.ctrl.swing.ICtrTextDocumentFilter;
import com.kingdee.cosmic.ctrl.swing.IKDComponent;
import com.kingdee.cosmic.ctrl.swing.IKDTextComponent;
import com.kingdee.cosmic.ctrl.swing.KDInfoTip;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.Stepable;
import com.kingdee.cosmic.ctrl.swing.common.i18n.CtrlSwingMessages;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeSpinnerUI;
import com.kingdee.cosmic.ctrl.swing.util.TextComponentUtilities;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.AbstractSpinnerModel;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.NumberFormatter;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;

public class KDSpinner
extends JSpinner
implements IKDComponent,
IBoundLabelControl,
IKDTextComponent {
    private static final Logger logger = LogUtil.getPackageLogger(KDSpinner.class);
    private static final long serialVersionUID = -32643099620756464L;
    protected FocusHandler listener;
    protected KeyHandler keyListener;
    protected Object userObject = null;
    protected KDLabelContainer kdLabelContainer;
    private Insets customInsets;
    private boolean required = false;
    private Color customBackground = null;
    private KDInfoTip errorInfo = new KDInfoTip(this, CtrlSwingMessages.getMLS("KDSpinnerErrorMessage", "\u8d85\u51fa\u8303\u56f4\u6216\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01"));
    private boolean nullAble = false;
    private SpinnerModel oringinModel = null;
    private JSpinner.DefaultEditor editor = null;

    public KDSpinner(SpinnerModel model) {
        super(model);
        this.configureEditor();
        TextComponentUtilities.storeOriginalData(this);
    }

    public KDSpinner() {
        this.configureEditor();
        TextComponentUtilities.storeOriginalData(this);
    }

    private FocusHandler getFocusHandler() {
        if (this.listener == null) {
            this.listener = new FocusHandler(this);
        }
        return this.listener;
    }

    private KeyHandler getKeyHandler() {
        if (this.keyListener == null) {
            this.keyListener = new KeyHandler(this);
        }
        return this.keyListener;
    }

    @Override
    public void setModel(SpinnerModel model) {
        Object spinner = ((JSpinner.DefaultEditor)this.getEditor()).getTextField().getClientProperty("spinner");
        Object access = ((JSpinner.DefaultEditor)this.getEditor()).getTextField().getClientProperty("access");
        super.setModel(model);
        ((JSpinner.DefaultEditor)this.getEditor()).getTextField().putClientProperty("spinner", spinner);
        ((JSpinner.DefaultEditor)this.getEditor()).getTextField().putClientProperty("access", access);
        TextComponentUtilities.storeOriginalData(this);
        this.updateUI();
    }

    @Override
    public void setValue(Object value) {
        if (this.getAccessAuthority() == 2) {
            int i;
            ChangeListener[] savedModelChangeListener = ((AbstractSpinnerModel)this.getModel()).getChangeListeners();
            for (i = 0; i < savedModelChangeListener.length; ++i) {
                this.getModel().removeChangeListener(savedModelChangeListener[i]);
            }
            super.setValue(value);
            for (i = 0; i < savedModelChangeListener.length; ++i) {
                this.getModel().addChangeListener(savedModelChangeListener[i]);
            }
        } else {
            super.setValue(value);
        }
    }

    public void setValue(Object value, boolean fireListener) {
        if (fireListener) {
            super.setValue(value);
        } else {
            ChangeListener[] savedChangeListeners = this.getChangeListeners();
            ChangeListener savedEditorChangeListener = null;
            if (savedChangeListeners != null) {
                int i;
                for (i = 0; i < savedChangeListeners.length; ++i) {
                    if (!(savedChangeListeners[i] instanceof JSpinner.DefaultEditor)) {
                        this.removeChangeListener(savedChangeListeners[i]);
                        continue;
                    }
                    savedEditorChangeListener = savedChangeListeners[i];
                    savedChangeListeners[i] = null;
                }
                super.setValue(value);
                this.addChangeListener(savedEditorChangeListener);
                for (i = 0; i < savedChangeListeners.length; ++i) {
                    this.addChangeListener(savedChangeListeners[i]);
                }
            } else {
                super.setValue(value);
            }
        }
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    public void setCustomBackground(Color col) {
        this.customBackground = col;
    }

    public Color getCustomBackground() {
        return this.customBackground;
    }

    public KDInfoTip getErrorInfo() {
        return this.errorInfo;
    }

    @Override
    public void commitEdit() throws ParseException {
        Object oldValue = this.getValue();
        JComponent editor = this.getEditor();
        if (editor instanceof JSpinner.DefaultEditor) {
            try {
                ((JSpinner.DefaultEditor)editor).commitEdit();
            }
            catch (Exception e) {
                ((JSpinner.DefaultEditor)editor).getTextField().setText(oldValue.toString());
            }
        }
    }

    @Override
    public void setRequired(boolean required) {
        boolean oldValue = this.required;
        this.required = required;
        ((JSpinner.DefaultEditor)this.getEditor()).getTextField().putClientProperty("required", required ? Boolean.TRUE : Boolean.FALSE);
        this.firePropertyChange("required", (Object)oldValue, (Object)required);
    }

    private void configureEditor() {
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)this.getEditor();
        JFormattedTextField ftf = editor.getTextField();
        if (editor instanceof JSpinner.NumberEditor) {
            ((JSpinner.NumberEditor)editor).getFormat().setGroupingUsed(false);
        }
        ftf.setBorder(null);
        ftf.putClientProperty("combo", Boolean.TRUE);
        ftf.putClientProperty("spinner", Boolean.TRUE);
    }

    public void setGroupingUsed(boolean b) {
        if (this.getEditor() instanceof JSpinner.NumberEditor) {
            JSpinner.NumberEditor edt = (JSpinner.NumberEditor)this.getEditor();
            DecimalFormat df = edt.getFormat();
            JFormattedTextField ftf = edt.getTextField();
            df.setGroupingUsed(b);
            try {
                Object val = this.getValue();
                if (val != null) {
                    ftf.setText(df.format(val));
                } else {
                    ftf.setText("");
                }
            }
            catch (Exception e) {
                ftf.setText("");
            }
        }
    }

    public boolean isGroupingUsed() {
        if (this.getEditor() instanceof JSpinner.NumberEditor) {
            return ((JSpinner.NumberEditor)this.getEditor()).getFormat().isGroupingUsed();
        }
        return false;
    }

    @Override
    protected JComponent createEditor(SpinnerModel model) {
        JSpinner.DefaultEditor edt = null;
        edt = model instanceof SpinnerDateModel ? new JSpinner.DateEditor(this) : (model instanceof SpinnerListModel ? new JSpinner.ListEditor(this) : (model instanceof SpinnerNumberModel ? new DefaultNumberEditor(this) : new JSpinner.DefaultEditor(this)));
        JFormattedTextField ftf = edt.getTextField();
        ftf.setBorder(null);
        ftf.setBackground(UIManager.getColor("TextField.initBackground"));
        ftf.setSelectedTextColor(UIManager.getColor("TextField.selectionForeground"));
        ftf.setSelectionColor(UIManager.getColor("TextField.selectionBackground"));
        ftf.addFocusListener(this.getFocusHandler());
        ftf.addKeyListener(this.getKeyHandler());
        ftf.setDisabledTextColor(UIManager.getColor("TextField.disabledForeground"));
        return edt;
    }

    @Override
    public void setEditor(JComponent editor) {
        JFormattedTextField ftf;
        JComponent edt = this.getEditor();
        if (edt instanceof JSpinner.DefaultEditor) {
            ftf = ((JSpinner.DefaultEditor)edt).getTextField();
            ftf.removeFocusListener(this.listener);
            ftf.removeKeyListener(this.keyListener);
        } else {
            edt.removeFocusListener(this.listener);
            edt.removeKeyListener(this.keyListener);
        }
        super.setEditor(editor);
        edt = this.getEditor();
        if (edt instanceof JSpinner.DefaultEditor) {
            ftf = ((JSpinner.DefaultEditor)editor).getTextField();
            ftf.addFocusListener(this.getFocusHandler());
            ftf.addKeyListener(this.getKeyHandler());
        } else {
            edt.addFocusListener(this.getFocusHandler());
            edt.addKeyListener(this.getKeyHandler());
        }
    }

    @Override
    public void updateUI() {
        this.setUI(KingdeeSpinnerUI.createUI(this));
    }

    public void setStepSize(Number size) {
        SpinnerModel model = this.getModel();
        if (model instanceof SpinnerNumberModel) {
            ((SpinnerNumberModel)model).setStepSize(size);
        }
    }

    public void setStepSize(Object size) {
        SpinnerModel model = this.getModel();
        if (model instanceof Stepable) {
            ((Stepable)((Object)model)).setStepSize(size);
        } else if (model instanceof SpinnerNumberModel && size instanceof Number) {
            ((SpinnerNumberModel)model).setStepSize((Number)size);
        }
    }

    public Object getStepSize() {
        SpinnerModel model = this.getModel();
        if (model instanceof Stepable) {
            return ((Stepable)((Object)model)).getStepSize();
        }
        if (model instanceof SpinnerNumberModel) {
            return ((SpinnerNumberModel)model).getStepSize();
        }
        return null;
    }

    @Override
    public boolean hasFocus() {
        boolean br = super.hasFocus();
        if (br) {
            return br;
        }
        JComponent edt = this.getEditor();
        if (edt == null) {
            return false;
        }
        br = edt.hasFocus();
        if (br) {
            return br;
        }
        if (edt instanceof JSpinner.DefaultEditor) {
            br = ((JSpinner.DefaultEditor)this.getEditor()).getTextField().hasFocus();
        }
        return br;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (TextComponentUtilities.setEnabled(this, enabled)) {
            super.setEnabled(enabled);
            if (enabled) {
                this.setBackground(UIManager.getColor("Spinner.enabledBackground"));
            } else if (this.getAccessAuthority() == 1) {
                this.setBackground(UIManager.getColor("Spinner.enabledBackground"));
            } else {
                this.setBackground(UIManager.getColor("Spinner.disableBackground"));
            }
            JComponent edt = this.getEditor();
            JFormattedTextField editorComponent = null;
            if (edt instanceof JSpinner.DefaultEditor) {
                editorComponent = ((JSpinner.DefaultEditor)edt).getTextField();
            }
            if (editorComponent != null) {
                if (enabled) {
                    editorComponent.setBackground(UIManager.getColor("Spinner.enabledBackground"));
                } else {
                    editorComponent.setBackground(UIManager.getColor("Spinner.disabledBackground"));
                }
            }
        }
    }

    @Override
    public void setEditable(boolean b) {
        JComponent edt;
        if (TextComponentUtilities.setEditable(this, b) && (edt = this.getEditor()) instanceof JSpinner.DefaultEditor) {
            ((JSpinner.DefaultEditor)edt).getTextField().setEditable(b);
        }
    }

    @Override
    public boolean isEditable() {
        JComponent edt = this.getEditor();
        if (edt instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor)edt).getTextField().isEditable();
        }
        return false;
    }

    public void setEditorUnFiltered(boolean b) {
        JFormattedTextField tf = ((JSpinner.DefaultEditor)this.getEditor()).getTextField();
        if (tf.getDocument() instanceof NumberPlainDocument) {
            ((NumberPlainDocument)tf.getDocument()).setUnFiltered(b);
        }
    }

    public boolean isEditorUnFiltered() {
        JFormattedTextField tf = ((JSpinner.DefaultEditor)this.getEditor()).getTextField();
        if (tf.getDocument() instanceof NumberPlainDocument) {
            return ((NumberPlainDocument)tf.getDocument()).isUnFiltered();
        }
        return false;
    }

    @Override
    public void setLabelContainer(KDLabelContainer kdLabelContainer) {
        this.kdLabelContainer = kdLabelContainer;
    }

    @Override
    public KDLabelContainer getLabelContainer() {
        return this.kdLabelContainer;
    }

    @Override
    public void setBoundLabel(JLabel label) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabel(label);
        }
    }

    @Override
    public void requestFocus() {
        ((JSpinner.DefaultEditor)this.getEditor()).getTextField().requestFocus();
    }

    public void requestFoucs(boolean val) {
        ((JSpinner.DefaultEditor)this.getEditor()).getTextField().requestFocus(val);
    }

    @Override
    public boolean requestFocusInWindow() {
        return ((JSpinner.DefaultEditor)this.getEditor()).getTextField().requestFocusInWindow();
    }

    @Override
    public JLabel getBoundLabel() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabel();
        }
        return null;
    }

    @Override
    public void setBoundLabelAlignment(int alignment) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelAlignment(alignment);
        }
    }

    @Override
    public int getBoundLabelAlignment() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelAlignment();
        }
        return 7;
    }

    @Override
    public void setBoundLabelLength(int len) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelLength(len);
        }
    }

    @Override
    public int getBoundLabelLength() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelLength();
        }
        return 0;
    }

    @Override
    public void setBoundLabelText(String labelText) {
        if (this.kdLabelContainer != null) {
            this.kdLabelContainer.setBoundLabelText(labelText);
        }
    }

    @Override
    public String getBoundLabelText() {
        if (this.kdLabelContainer != null) {
            return this.kdLabelContainer.getBoundLabelText();
        }
        return "";
    }

    public BigDecimal getBigDecimalValue() {
        Object val = this.getValue();
        if (val == null) {
            return null;
        }
        Variant var = new Variant(val);
        try {
            return var.toBigDecimal();
        }
        catch (SyntaxErrorException e) {
            logger.error((Object)"err", (Throwable)e);
            return null;
        }
    }

    public Float getFloatVlaue() {
        Object val = this.getValue();
        if (val == null) {
            return null;
        }
        Variant var = new Variant(val);
        try {
            return new Float(var.floatValue());
        }
        catch (SyntaxErrorException e) {
            logger.error((Object)"err", (Throwable)e);
            return null;
        }
    }

    public Double getDoubleVlaue() {
        Object val = this.getValue();
        if (val == null) {
            return null;
        }
        Variant var = new Variant(val);
        try {
            return new Double(var.doubleValue());
        }
        catch (SyntaxErrorException e) {
            logger.error((Object)"err", (Throwable)e);
            return null;
        }
    }

    public Integer getIntegerVlaue() {
        Object val = this.getValue();
        if (val == null) {
            return null;
        }
        Variant var = new Variant(val);
        try {
            return var.intValue();
        }
        catch (SyntaxErrorException e) {
            logger.error((Object)"err", (Throwable)e);
            return null;
        }
    }

    public Object getValue(Class c) {
        Object val;
        block11: {
            val = this.getValue();
            if (val == null) {
                return null;
            }
            Variant var = new Variant(val);
            try {
                if (c == Byte.class) {
                    val = var.byteValue();
                    break block11;
                }
                if (c == Short.class) {
                    val = var.shortValue();
                    break block11;
                }
                if (c == Integer.class) {
                    val = var.intValue();
                    break block11;
                }
                if (c == Long.class) {
                    val = var.longValue();
                    break block11;
                }
                if (c == Float.class) {
                    val = Float.valueOf(var.floatValue());
                    break block11;
                }
                if (c == Double.class) {
                    val = var.doubleValue();
                    break block11;
                }
                if (c == BigInteger.class) {
                    val = var.toBigInteger();
                    break block11;
                }
                if (c == BigDecimal.class) {
                    val = var.toBigDecimal();
                    break block11;
                }
                throw new IllegalArgumentException("c type is not supported");
            }
            catch (SyntaxErrorException e) {
                logger.error((Object)"err", (Throwable)e);
                throw new IllegalArgumentException("c type is not supported", e);
            }
        }
        return val;
    }

    @Override
    public void setAccessAuthority(int authority) {
        TextComponentUtilities.setAccessAuthority(this, authority);
        ((JSpinner.DefaultEditor)this.getEditor()).getTextField().putClientProperty("access", authority);
    }

    @Override
    public int getAccessAuthority() {
        return TextComponentUtilities.getAccessAuthority(this);
    }

    @Override
    public Object getNextValue() {
        Object obj = super.getNextValue();
        if (obj == null && this.getModel() instanceof SpinnerNumberModel) {
            return (Number)((Object)((SpinnerNumberModel)this.getModel()).getMaximum());
        }
        return obj;
    }

    @Override
    public Object getPreviousValue() {
        Object obj = super.getPreviousValue();
        if (obj == null && this.getModel() instanceof SpinnerNumberModel) {
            return (Number)((Object)((SpinnerNumberModel)this.getModel()).getMinimum());
        }
        return obj;
    }

    public void setPattern(String pattern) {
        if (this.getModel() instanceof SpinnerNumberModel) {
            ((DecimalFormat)((NumberFormatter)((JSpinner.DefaultEditor)this.getEditor()).getTextField().getFormatter()).getFormat()).applyPattern(pattern);
        }
    }

    public void setNullable(boolean nullAble) {
        this.nullAble = nullAble;
        if (nullAble) {
            this.installNullableModel();
        } else if (this.oringinModel != null && this.editor != null) {
            this.uninstallNullableModel();
        }
    }

    public boolean isNullable() {
        return this.nullAble;
    }

    private void uninstallNullableModel() {
        Object temp;
        if (this.oringinModel != this.getModel()) {
            temp = this.getModel();
            this.setModel(this.oringinModel);
            this.oringinModel = temp;
            temp = null;
            this.syncModel();
        }
        if (this.editor != this.getEditor()) {
            temp = (JSpinner.DefaultEditor)this.getEditor();
            this.addChangeListener(this.editor);
            this.setEditor(this.editor);
            this.editor = temp;
            temp = null;
            this.syncEditor();
        }
    }

    private void installNullableModel() {
        this.oringinModel = this.getModel();
        this.editor = (JSpinner.DefaultEditor)this.getEditor();
        if (this.getModel() instanceof SpinnerNumberModel) {
            final DecimalFormat f = (DecimalFormat)((NumberFormatter)this.editor.getTextField().getFormatter()).getFormat();
            DefaultNumberEditor instead = new DefaultNumberEditor(this, new DecimalFormat(f.toPattern()));
            this.setModel(new SpinnerNumberModel(){
                private Number value = BigDecimal.valueOf(0.0);

                @Override
                public Object getValue() {
                    return this.value;
                }

                @Override
                public void setValue(Object value) {
                    if (value == null || value instanceof String && ((String)value).trim().equals("")) {
                        if (this.value == value) {
                            return;
                        }
                        this.value = null;
                        this.fireStateChanged();
                        return;
                    }
                    this.value = Double.valueOf(String.valueOf(value));
                    super.setValue(value);
                    this.fireStateChanged();
                }
            });
            instead.getTextField().setFormatterFactory(new JFormattedTextField.AbstractFormatterFactory(){
                private NumberFormatter formatter = null;

                @Override
                public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
                    if (this.formatter == null) {
                        this.formatter = new DefaultNumberEditorFormatter((SpinnerNumberModel)KDSpinner.this.getModel(), new DecimalFormat(f.toPattern())){

                            @Override
                            public Object stringToValue(String text) throws ParseException {
                                if (text == null || text.trim().equals("")) {
                                    return null;
                                }
                                return super.stringToValue(text);
                            }

                            @Override
                            public String valueToString(Object value) throws ParseException {
                                if (value == null || String.valueOf(value).trim().equals("")) {
                                    return null;
                                }
                                return super.valueToString(value);
                            }
                        };
                    }
                    return this.formatter;
                }
            });
            Document doc = instead.getTextField().getDocument();
            if (doc instanceof NumberPlainDocument) {
                ((NumberPlainDocument)doc).setNullable(true);
            }
            this.setEditor(instead);
            this.syncModel();
            this.syncEditor();
        } else if (this.getModel() instanceof SpinnerListModel) {
            this.setModel(new SpinnerListModel(((SpinnerListModel)this.oringinModel).getList()){
                private Object value;
                {
                    this.value = null;
                }

                @Override
                public Object getValue() {
                    return this.value;
                }

                @Override
                public void setValue(Object value) {
                    if (value == null || value instanceof String && ((String)value).trim().equals("")) {
                        this.value = null;
                        return;
                    }
                    this.value = value;
                    super.setValue(value);
                    this.fireStateChanged();
                }
            });
            this.syncModel();
            this.syncEditor();
        } else if (this.getModel() instanceof SpinnerDateModel) {
            this.setModel(new SpinnerDateModel(){
                private Object value = null;

                @Override
                public Object getValue() {
                    return this.value;
                }

                @Override
                public void setValue(Object value) {
                    if (value == null || value instanceof String && ((String)value).trim().equals("")) {
                        if (this.value == value) {
                            return;
                        }
                        this.value = null;
                        this.fireStateChanged();
                        return;
                    }
                    this.value = value;
                    super.setValue(value);
                    this.fireStateChanged();
                }
            });
            JSpinner.DateEditor instead = new JSpinner.DateEditor(this);
            instead.getTextField().setFormatterFactory(new JFormattedTextField.AbstractFormatterFactory(){
                private DateFormatter formatter = null;

                @Override
                public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
                    if (this.formatter == null) {
                        this.formatter = new DateFormatter(){

                            @Override
                            public Object stringToValue(String text) throws ParseException {
                                if (text == null || text.trim().equals("")) {
                                    return null;
                                }
                                return super.stringToValue(text);
                            }

                            @Override
                            public String valueToString(Object value) throws ParseException {
                                if (value == null || String.valueOf(value).trim().equals("")) {
                                    return null;
                                }
                                return super.valueToString(value);
                            }
                        };
                    }
                    return this.formatter;
                }
            });
            this.setEditor(instead);
            this.syncModel();
            this.syncEditor();
        }
    }

    private void syncEditor() {
        if (this.getEditor() instanceof JSpinner.NumberEditor) {
            if (((JSpinner.NumberEditor)this.getEditor()).getTextField().getFormatter() instanceof NumberFormatter && this.editor.getTextField().getFormatter() instanceof NumberFormatter) {
                ((NumberFormatter)((JSpinner.NumberEditor)this.getEditor()).getTextField().getFormatter()).setValueClass(((NumberFormatter)this.editor.getTextField().getFormatter()).getValueClass());
            }
            ((JSpinner.NumberEditor)this.getEditor()).getTextField().setText(this.editor.getTextField().getText());
        } else if (this.getEditor() instanceof JSpinner.ListEditor) {
            ((JSpinner.ListEditor)this.getEditor()).getTextField().setText(this.editor.getTextField().getText());
        } else if (this.getEditor() instanceof JSpinner.DateEditor) {
            ((JSpinner.DateEditor)this.getEditor()).getTextField().setText(this.editor.getTextField().getText());
            if (((JSpinner.DateEditor)this.getEditor()).getTextField().getFormatter() instanceof DateFormatter && ((JSpinner.DateEditor)this.editor).getTextField().getFormatter() instanceof DateFormatter) {
                DateFormatter formatter = (DateFormatter)((JSpinner.DateEditor)this.getEditor()).getTextField().getFormatter();
                DateFormatter oringinFormatter = (DateFormatter)((JSpinner.DateEditor)this.editor).getTextField().getFormatter();
                formatter.setFormat(oringinFormatter.getFormat());
            }
        }
    }

    private void syncModel() {
        if (this.getModel() instanceof SpinnerNumberModel && this.oringinModel instanceof SpinnerNumberModel) {
            SpinnerNumberModel model = (SpinnerNumberModel)this.getModel();
            if (this.oringinModel.getValue() == null || String.valueOf(this.oringinModel.getValue()).trim().equals("")) {
                model.setValue(0);
            } else {
                model.setValue(this.oringinModel.getValue());
            }
            model.setMaximum(((SpinnerNumberModel)this.oringinModel).getMaximum());
            model.setMinimum(((SpinnerNumberModel)this.oringinModel).getMinimum());
            model.setStepSize(((SpinnerNumberModel)this.oringinModel).getStepSize());
        } else if (!(this.getModel() instanceof SpinnerListModel) && this.getModel() instanceof SpinnerDateModel && this.oringinModel instanceof SpinnerDateModel) {
            SpinnerDateModel model = (SpinnerDateModel)this.getModel();
            model.setValue(((SpinnerDateModel)this.oringinModel).getValue());
            model.setCalendarField(((SpinnerDateModel)this.oringinModel).getCalendarField());
            model.setStart(((SpinnerDateModel)this.oringinModel).getStart());
            model.setEnd(((SpinnerDateModel)this.oringinModel).getEnd());
        }
    }

    private static class NumberPlainDocument
    extends PlainDocument {
        private static final long serialVersionUID = 3804985166755525830L;
        ICtrTextDocumentFilter ctrlTextDocumentFilter = null;
        private boolean isFocusing = false;
        private boolean unFiltered = false;
        private boolean isNullable = false;

        public void setNullable(boolean isNullable) {
            this.isNullable = isNullable;
        }

        public boolean isNullable() {
            return this.isNullable;
        }

        public NumberPlainDocument() {
        }

        public NumberPlainDocument(AbstractDocument.Content c) {
            super(c);
        }

        public void setUnFiltered(boolean b) {
            this.unFiltered = b;
        }

        public boolean isUnFiltered() {
            return this.unFiltered;
        }

        @Override
        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (this.unFiltered) {
                super.replace(offset, length, text, attrs);
                return;
            }
            if (this.getCtrTextDocumentFilter() != null && !this.getCtrTextDocumentFilter().isValidateStr(text)) {
                if (this.isNullable) {
                    super.replace(offset, length, text, attrs);
                    return;
                }
                return;
            }
            if (!this.getCtrTextDocumentFilter().isValidLength(this)) {
                return;
            }
            super.replace(offset, length, text, attrs);
        }

        public void replace(int offset, int length, String text, AttributeSet attrs, boolean b) throws BadLocationException {
            if (b) {
                super.replace(offset, length, text, attrs);
            }
        }

        public void setCtrTextDocumentFilter(ICtrTextDocumentFilter newValue) {
            this.ctrlTextDocumentFilter = newValue;
        }

        public ICtrTextDocumentFilter getCtrTextDocumentFilter() {
            return this.ctrlTextDocumentFilter;
        }

        public void setFocusing(boolean newValue) {
            this.isFocusing = newValue;
        }

        public boolean isFocusing() {
            return this.isFocusing;
        }
    }

    private static class NumberTextDocumentFilter
    implements ICtrTextDocumentFilter {
        private String validateStr = "-+.%,";

        @Override
        public boolean isValidLength(Document doc) {
            return true;
        }

        @Override
        public boolean isValidateStr(String str) {
            boolean b = false;
            if (str != null && str.length() > 0) {
                int len = str.length();
                for (int i = 0; i < len; ++i) {
                    char tChar = str.charAt(i);
                    b = Character.isDigit(tChar) || this.validateStr.indexOf(tChar) != -1;
                }
            }
            return b;
        }

        @Override
        public void setValidLength(int len) {
        }

        @Override
        public void setValidateStr(String newValue) {
            if (newValue != null) {
                this.validateStr = newValue;
            }
        }

        @Override
        public String getValidateStr() {
            return this.validateStr;
        }
    }

    protected static class KeyHandler
    implements KeyListener {
        protected KDSpinner spinner;

        public KeyHandler(KDSpinner sp) {
            this.spinner = sp;
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (this.spinner.getErrorInfo().isShowing()) {
                this.spinner.getErrorInfo().setShowing(false);
            }
        }
    }

    protected static class FocusHandler
    implements FocusListener {
        protected KDSpinner spinner;

        public FocusHandler(KDSpinner sp) {
            this.spinner = sp;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.spinner.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (this.spinner.getErrorInfo().isShowing()) {
                this.spinner.getErrorInfo().setShowing(false);
            }
            try {
                ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().commitEdit();
            }
            catch (ParseException e1) {
                this.spinner.requestFocusInWindow();
                this.spinner.getErrorInfo().setArrowHeight(10);
                this.spinner.getErrorInfo().setShowing(true);
            }
            this.spinner.repaint();
        }
    }

    public static class DefaultNumberEditor
    extends JSpinner.NumberEditor {
        private static final long serialVersionUID = -4326766702272291940L;

        public DefaultNumberEditor(JSpinner spinner) {
            this(spinner, new DecimalFormat());
        }

        public DefaultNumberEditor(JSpinner spinner, String decimalFormatPattern) {
            this(spinner, new DecimalFormat(decimalFormatPattern));
        }

        private DefaultNumberEditor(JSpinner spinner, DecimalFormat format) {
            super(spinner);
            if (!(spinner.getModel() instanceof SpinnerNumberModel)) {
                throw new IllegalArgumentException("model not a SpinnerNumberModel");
            }
            format.setGroupingUsed(false);
            JFormattedTextField ftf = this.getTextField();
            ftf.setEditable(true);
            NumberPlainDocument numberDocument = new NumberPlainDocument();
            NumberTextDocumentFilter ctrlTextDocuFilter = new NumberTextDocumentFilter();
            numberDocument.setCtrTextDocumentFilter(ctrlTextDocuFilter);
            ftf.setDocument(numberDocument);
            SpinnerNumberModel model = (SpinnerNumberModel)spinner.getModel();
            DefaultNumberEditorFormatter formatter = new DefaultNumberEditorFormatter(model, format);
            formatter.setOverwriteMode(true);
            DefaultFormatterFactory factory = new DefaultFormatterFactory(formatter);
            ftf.setFormatterFactory(factory);
            ftf.setHorizontalAlignment(4);
            try {
                String maxString = formatter.valueToString(model.getMinimum());
                String minString = formatter.valueToString(model.getMaximum());
                ftf.setColumns(Math.max(maxString.length(), minString.length()));
                format.setMaximumFractionDigits(Math.max(maxString.length(), minString.length()));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }

        @Override
        public DecimalFormat getFormat() {
            return (DecimalFormat)((NumberFormatter)this.getTextField().getFormatter()).getFormat();
        }

        @Override
        public SpinnerNumberModel getModel() {
            return (SpinnerNumberModel)this.getSpinner().getModel();
        }
    }

    private static class DefaultNumberEditorFormatter
    extends NumberFormatter {
        private static final long serialVersionUID = 5280131302175627586L;
        private final SpinnerNumberModel model;

        DefaultNumberEditorFormatter(SpinnerNumberModel model, NumberFormat format) {
            super(format);
            this.model = model;
            if (model.getValue() != null) {
                this.setValueClass(model.getValue().getClass());
            }
        }

        public void setMinimum(Comparable min) {
            this.model.setMinimum(min);
        }

        public Comparable getMinimum() {
            return this.model.getMinimum();
        }

        public void setMaximum(Comparable max) {
            this.model.setMaximum(max);
        }

        public Comparable getMaximum() {
            return this.model.getMaximum();
        }
    }
}

