/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.IKDComponent;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDTextArea;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeBorders;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JScrollBar;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class KDTextAreaCtrl
extends KDScrollPane
implements IKDComponent {
    private static final long serialVersionUID = -3074674137433184026L;
    protected static final Insets MARGIN = new Insets(2, 5, 2, 5);
    protected static final int DEFAULTHEIGHT = 82;
    protected static final int DEFAULTWIDTH = 170;
    public static final int STYLE_VSCROLLBAR_AS_NEEDED = 1;
    public static final int STYLE_VSCROLLBAR_NEVER = 2;
    public static final int STYLE_VSCROLLBAR_ALWAYS = 4;
    public static final int STYLE_HSCROLLBAR_AS_NEEDED = 16;
    public static final int STYLE_HSCROLLBAR_NEVER = 32;
    public static final int STYLE_HSCROLLBAR_ALWAYS = 64;
    protected KDTextArea ta;
    protected TextAreaCtrlFocusHandler listener = new TextAreaCtrlFocusHandler(this);
    protected Object userObject = null;

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    private int getVerticalScrollBarPolicy(int style) {
        if ((style & 1) != 0) {
            return 20;
        }
        if ((style & 2) != 0) {
            return 21;
        }
        if ((style & 4) != 0) {
            return 22;
        }
        return 20;
    }

    private int getHorizontalScrollBarPolicy(int style) {
        if ((style & 0x10) != 0) {
            return 30;
        }
        if ((style & 0x20) != 0) {
            return 31;
        }
        if ((style & 0x40) != 0) {
            return 32;
        }
        return 30;
    }

    protected void init(int style, Document doc, String text, int rows, int columns) {
        this.ta = new KDTextArea(doc, text, rows, columns);
        this.ta.setMargin(MARGIN);
        this.ta.setLineWrap(true);
        this.ta.setWrapStyleWord(true);
        this.ta.addFocusListener(this.listener);
        this.ta.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        this.addFocusListener(this.listener);
        this.setViewportView(this.ta);
        this.setVerticalScrollBarPolicy(this.getVerticalScrollBarPolicy(style));
        this.setHorizontalScrollBarPolicy(this.getHorizontalScrollBarPolicy(style));
        this.setBorder(KingdeeBorders.createEditorBorder());
        JScrollBar bar = this.getHorizontalScrollBar();
        if (bar != null) {
            bar.setFocusable(false);
        }
        if ((bar = this.getVerticalScrollBar()) != null) {
            bar.setFocusable(false);
        }
    }

    public KDTextAreaCtrl(int style) {
        this.init(style, null, null, 0, 0);
    }

    public KDTextAreaCtrl(int style, int rows, int columns) {
        this.init(style, null, null, rows, columns);
    }

    public KDTextAreaCtrl(int style, String text) {
        this.init(style, null, text, 0, 0);
    }

    public KDTextAreaCtrl(int style, String text, int rows, int columns) {
        this.init(style, null, text, rows, columns);
    }

    public KDTextAreaCtrl(int style, Document doc, String text, int rows, int columns) {
        this.init(style, doc, text, rows, columns);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        JScrollBar bar = this.getHorizontalScrollBar();
        if (bar != null) {
            bar.setEnabled(enabled);
        }
        if ((bar = this.getVerticalScrollBar()) != null) {
            bar.setEnabled(enabled);
        }
        this.ta.setEnabled(enabled);
    }

    @Override
    public boolean hasFocus() {
        boolean br = super.hasFocus();
        if (!br) {
            br = this.ta.hasFocus();
        }
        return br;
    }

    public KDTextAreaCtrl() {
        this.init(0, null, null, 0, 0);
    }

    public KDTextAreaCtrl(String text) {
        this.init(0, null, text, 0, 0);
    }

    public KDTextAreaCtrl(int rows, int columns) {
        this.init(0, null, null, rows, columns);
    }

    public KDTextAreaCtrl(String text, int rows, int columns) {
        this.init(0, null, text, rows, columns);
    }

    public KDTextAreaCtrl(Document doc) {
        this.init(0, doc, null, 0, 0);
    }

    public KDTextAreaCtrl(Document doc, String text, int rows, int columns) {
        this.init(0, doc, text, rows, columns);
    }

    public void setTabSize(int size) {
        this.ta.setTabSize(size);
    }

    public int getTabSize() {
        return this.ta.getTabSize();
    }

    public void setLineWrap(boolean wrap) {
        this.ta.setLineWrap(wrap);
    }

    public boolean getLineWrap() {
        return this.ta.getLineWrap();
    }

    public void setWrapStyleWord(boolean word) {
        this.ta.setWrapStyleWord(word);
    }

    public boolean getWrapStyleWord() {
        return this.ta.getWrapStyleWord();
    }

    public int getLineOfOffset(int offset) throws BadLocationException {
        return this.ta.getLineOfOffset(offset);
    }

    public int getLineCount() {
        return this.ta.getLineCount();
    }

    public int getLineStartOffset(int line) throws BadLocationException {
        return this.ta.getLineStartOffset(line);
    }

    public int getLineEndOffset(int line) throws BadLocationException {
        return this.ta.getLineEndOffset(line);
    }

    public void insert(String str, int pos) {
        this.ta.insert(str, pos);
    }

    public void append(String str) {
        this.ta.append(str);
    }

    public void replaceRange(String str, int start, int end) {
        this.ta.replaceRange(str, start, end);
    }

    public int getRows() {
        return this.ta.getRows();
    }

    public void setRows(int rows) {
        this.ta.setRows(rows);
    }

    public int getColumns() {
        return this.ta.getColumns();
    }

    public void setColumns(int columns) {
        this.ta.setColumns(columns);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = new Dimension(170, 82);
        return d;
    }

    public KDTextArea getTextComponent() {
        return this.ta;
    }

    public void setDocument(Document doc) {
        this.ta.setDocument(doc);
    }

    public Document getDocument() {
        return this.ta.getDocument();
    }

    public void replaceSelection(String content) {
        this.ta.replaceSelection(content);
    }

    public String getText(int offs, int len) throws BadLocationException {
        return this.ta.getText(offs, len);
    }

    public void cut() {
        this.ta.cut();
    }

    public void copy() {
        this.ta.copy();
    }

    public void paste() {
        this.ta.paste();
    }

    public void moveCaretPosition(int pos) {
        this.ta.moveCaretPosition(pos);
    }

    public void setCaretPosition(int position) {
        this.ta.setCaretPosition(position);
    }

    public int getCaretPosition() {
        return this.ta.getCaretPosition();
    }

    public void setText(String t) {
        this.ta.setText(t);
    }

    public String getText() {
        return this.ta.getText();
    }

    public String getSelectedText() {
        return this.ta.getSelectedText();
    }

    public int getSelectionStart() {
        return this.ta.getSelectionStart();
    }

    public void setSelectionStart(int selectionStart) {
        this.ta.setSelectionStart(selectionStart);
    }

    public int getSelectionEnd() {
        return this.ta.getSelectionEnd();
    }

    public void setSelectionEnd(int selectionEnd) {
        this.ta.setSelectionEnd(selectionEnd);
    }

    public void select(int selectionStart, int selectionEnd) {
        this.ta.select(selectionStart, selectionEnd);
    }

    public void selectAll() {
        this.ta.selectAll();
    }

    public int getMaxLength() {
        return this.ta.getMaxLength();
    }

    public int getMinLength() {
        return this.ta.getMinLength();
    }

    public void setMaxLength(int len) {
        this.ta.setMaxLength(len);
    }

    public void setMinLength(int len) {
        this.ta.setMinLength(len);
    }

    public boolean isEditable() {
        return this.ta.isEditable();
    }

    public void setEditable(boolean b) {
        this.ta.setEditable(b);
    }

    protected static class TextAreaCtrlFocusHandler
    implements FocusListener {
        protected KDTextAreaCtrl tac;

        public TextAreaCtrlFocusHandler(KDTextAreaCtrl comp) {
            this.tac = comp;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.tac.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.tac.repaint();
        }
    }
}

