/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.swing.IKDComponent;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.StyledDocument;
import javax.swing.undo.UndoManager;
import org.apache.log4j.Logger;

public class KDTextPane
extends JTextPane
implements IKDComponent {
    private static final Logger logger = LogUtil.getPackageLogger(KDTextPane.class);
    private static final long serialVersionUID = -8116003995867279220L;
    private Object userObject = null;
    private Insets customInsets;
    public static final String undoAction = "undo-textpane";
    public static final String redoAction = "redo-textpane";
    public UndoManager manager = null;

    public KDTextPane() {
        this.init();
    }

    public KDTextPane(StyledDocument doc) {
        super(doc);
        this.init();
    }

    private void init() {
        if (this.manager == null) {
            this.manager = new UndoManager();
        }
        this.getDocument().addUndoableEditListener(this.manager);
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        KeyStroke newKeyStroke = KeyStroke.getKeyStroke(90, 2, false);
        inputMap.put(newKeyStroke, undoAction);
        newKeyStroke = KeyStroke.getKeyStroke(89, 2, false);
        inputMap.put(newKeyStroke, redoAction);
        actionMap.put(undoAction, new UndoAction());
        actionMap.put(redoAction, new RedoAction());
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = 2880749790991967215L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (KDTextPane.this.manager.canRedo()) {
                    KDTextPane.this.manager.redo();
                }
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
    }

    public class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = -7947194007944530443L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (KDTextPane.this.manager.canUndo()) {
                    KDTextPane.this.manager.undo();
                }
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
    }
}

