/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import com.kingdee.cosmic.ctrl.swing.KDSeparator;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.plaf.basic.DefaultMenuLayout;

public class SimplePopupMenuLayout
extends DefaultMenuLayout {
    private static final long serialVersionUID = -4014331676083262082L;

    public SimplePopupMenuLayout(Container target, int axis) {
        super(target, axis);
    }

    @Override
    public void layoutContainer(Container target) {
        this.adjustSeparatorVisible(target);
        this.invalidateLayout(target);
        target.setSize(this.preferredLayoutSize(target));
        super.layoutContainer(target);
    }

    private void adjustSeparatorVisible(Container target) {
        if (target instanceof JPopupMenu) {
            Component[] comps = ((JPopupMenu)target).getComponents();
            int preVisibleSeparator = -1;
            int firstVisibleComponent = this.getFirstVisibleComponent(comps);
            int lastVisibleComponent = this.getLastVisibleComponent(comps);
            if (comps.length > 0) {
                for (int i = 0; i < comps.length; ++i) {
                    Component comp = comps[i];
                    if (!(comp instanceof JPopupMenu.Separator) && !(comp instanceof KDSeparator)) continue;
                    if (firstVisibleComponent == -1) {
                        comp.setVisible(false);
                        continue;
                    }
                    if (i < firstVisibleComponent) {
                        comp.setVisible(false);
                        continue;
                    }
                    if (i > lastVisibleComponent) {
                        comp.setVisible(false);
                        continue;
                    }
                    if (this.isPreVisibleCompSeparator(comps, preVisibleSeparator, i)) {
                        comp.setVisible(false);
                        continue;
                    }
                    comp.setVisible(true);
                    preVisibleSeparator = i;
                }
            }
        }
    }

    private boolean isPreVisibleCompSeparator(Component[] comps, int pre, int current) {
        if (pre == -1) {
            return false;
        }
        for (int i = current - 1; i >= pre; --i) {
            JComponent comp = (JComponent)comps[i];
            if (!comp.isVisible() || comp instanceof JPopupMenu.Separator || comp instanceof KDSeparator) continue;
            return false;
        }
        return true;
    }

    private int getFirstVisibleComponent(Component[] comps) {
        for (int i = 0; i < comps.length - 1; ++i) {
            JComponent comp = (JComponent)comps[i];
            if (!comp.isVisible() || comp instanceof JPopupMenu.Separator || comp instanceof KDSeparator) continue;
            return i;
        }
        return -1;
    }

    private int getLastVisibleComponent(Component[] comps) {
        if (this.getFirstVisibleComponent(comps) == -1) {
            return -1;
        }
        for (int i = comps.length - 1; i > 0; --i) {
            JComponent comp = (JComponent)comps[i];
            if (!comp.isVisible() || comp instanceof JPopupMenu.Separator || comp instanceof KDSeparator) continue;
            return i;
        }
        return -1;
    }
}

