/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class StringUtils {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String[] JAVA_KEYWORDS = new String[]{"assert", "abstract", "continue", "for", "new", "switch", "boolean", "default", "goto", "null", "synchronized", "break", "do", "if", "package", "this", "byte", "double", "implements", "private", "threadsafe", "byvalue", "else", "import", "protected", "throw", "case", "extends", "instanceof", "public", "transient", "catch", "false", "int", "return", "true", "char", "final", "interface", "short", "try", "class", "finally", "long", "static", "void", "const", "float", "native", "super", "while", "volatile", "strictfp"};

    public static String[] split(String line, int seperator) {
        int j;
        if (line == null) {
            return null;
        }
        if ((line = line.trim()).length() == 0) {
            return null;
        }
        ArrayList<String> v = new ArrayList<String>(8);
        int i = 0;
        while ((j = line.indexOf(seperator, i)) >= 0) {
            v.add(line.substring(i, j).trim());
            i = j + 1;
        }
        v.add(line.substring(i).trim());
        int size = v.size();
        String[] ps = new String[size];
        for (int k = 0; k < size; ++k) {
            ps[k] = (String)v.get(k);
        }
        return ps;
    }

    public static String[] split(String line, String seperator) {
        int j;
        if (line == null) {
            return null;
        }
        if ((line = line.trim()).length() == 0) {
            return new String[]{""};
        }
        ArrayList<String> v = new ArrayList<String>(8);
        int i = 0;
        while ((j = line.indexOf(seperator, i)) >= 0) {
            v.add(line.substring(i, j).trim());
            i = j + seperator.length();
        }
        v.add(line.substring(i).trim());
        int size = v.size();
        String[] ps = new String[size];
        for (int k = 0; k < size; ++k) {
            ps[k] = (String)v.get(k);
        }
        return ps;
    }

    public static String fixNumber(long n) {
        return StringUtils.fixNumber(n, 8);
    }

    public static String fixNumber(long n, int len) {
        char[] b = new char[len];
        for (int i = 0; i < len; ++i) {
            b[i] = 48;
        }
        return new DecimalFormat(new String(b)).format(n);
    }

    public static String fixNumber(int n) {
        return StringUtils.fixNumber((long)n, 4);
    }

    public static String fixNumber(int n, int len) {
        return StringUtils.fixNumber((long)n, len);
    }

    public static final boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean equals(String s1, String s2) {
        if (StringUtils.isEmpty(s1)) {
            return StringUtils.isEmpty(s2);
        }
        return s1.equals(s2);
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        if (StringUtils.isEmpty(s1)) {
            return StringUtils.isEmpty(s2);
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static String numStr4Java(String s, char c, char c1) {
        if (s == null) {
            return null;
        }
        StringBuilder stringbuffer = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c2 = s.charAt(i);
            if (c2 == c) continue;
            if (c2 == c1) {
                stringbuffer.append('.');
                continue;
            }
            stringbuffer.append(c2);
        }
        return stringbuffer.toString();
    }

    public static String takeCommasFromNumStr(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(44) == -1) {
            return s;
        }
        return StringUtils.numStr4Java(s, ',', '.');
    }

    public static String[] enumeration2StringArray(Enumeration enumeration, int i) {
        int j = 0;
        String[] as = new String[i];
        while (enumeration.hasMoreElements()) {
            as[j++] = (String)enumeration.nextElement();
        }
        return as;
    }

    public static byte[] chars2bytes(char[] ac) {
        byte[] abyte0 = new byte[ac.length * 2];
        int i = 0;
        for (int j = 0; j < ac.length; ++j) {
            char c = ac[j];
            char c1 = ac[j];
            abyte0[i++] = (byte)(c >> 8);
            abyte0[i++] = (byte)c1;
        }
        return abyte0;
    }

    public static char[] bytes2chars(byte[] abyte0) throws Exception {
        if (abyte0.length % 2 != 0) {
            throw new Exception("Cannot convert an odd number of bytes");
        }
        char[] ac = new char[abyte0.length / 2];
        int i = 0;
        for (int j = 0; j < ac.length; ++j) {
            byte byte0 = abyte0[i++];
            byte byte1 = abyte0[i++];
            ac[j] = (char)(byte0 << 8 & 0xFF00 | byte1 & 0xFF);
        }
        return ac;
    }

    public static String padStringWidth(String s, int i) {
        StringBuffer stringbuffer = null;
        if (s != null) {
            int j;
            stringbuffer = new StringBuffer(s);
            stringbuffer.setLength(i);
            for (int l = j = s.length(); l < i; ++l) {
                stringbuffer.setCharAt(l, ' ');
            }
        } else {
            stringbuffer = new StringBuffer(i);
            stringbuffer.setLength(i);
            for (int k = 0; k < i; ++k) {
                stringbuffer.setCharAt(k, ' ');
            }
        }
        return stringbuffer.toString();
    }

    public static String padStringWidth(int i, int j) {
        return StringUtils.padStringWidth(String.valueOf(i), j);
    }

    public static String padStringWidth(float f, int i) {
        return StringUtils.padStringWidth(String.valueOf(f), i);
    }

    public static String padStringWidth(long l, int i) {
        return StringUtils.padStringWidth(String.valueOf(l), i);
    }

    public static String padStringWidth(double d, int i) {
        return StringUtils.padStringWidth(String.valueOf(d), i);
    }

    public static String toHexString(long x, int chars) {
        char[] buf = new char[chars];
        int charPos = chars;
        while (--charPos >= 0) {
            buf[charPos] = hexDigits[(int)(x & 0xFL)];
            x >>>= 4;
        }
        return new String(buf);
    }

    public static String GBToUnicode(String str) {
        try {
            return new String(str.getBytes("8859_1"), "GB2312");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String unicodeToGB(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        try {
            return new String(str.getBytes("GB2312"), "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String cnulls(Object obj) {
        return StringUtils.cnulls(obj, "");
    }

    public static String cnulls(Object obj, String defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        return obj.toString();
    }

    public static String cnulls(String str, String defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        return str;
    }

    public static String cnulls(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public static String formatCurrency(double cy) {
        return NumberFormat.getCurrencyInstance().format(cy);
    }

    public static String formatNumber(double d, int n) {
        StringBuilder pattern = new StringBuilder("#,##0");
        if (n > 0) {
            pattern.append(".");
            for (int i = 0; i < n; ++i) {
                pattern.append("0");
            }
        }
        return new DecimalFormat(pattern.toString()).format(d);
    }

    public static int compareToIgnoreCase(String str1, String str2) {
        return str1.toLowerCase(Locale.ENGLISH).compareTo(str2.toLowerCase(Locale.ENGLISH));
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        return str.toLowerCase(Locale.ENGLISH).endsWith(suffix.toLowerCase(Locale.ENGLISH));
    }

    public static int indexOfIgnoreCase(String str, int find) {
        return str.toLowerCase(Locale.ENGLISH).indexOf(Character.toLowerCase((char)find));
    }

    public static int indexOfIgnoreCase(String str, int find, int start) {
        return str.toLowerCase(Locale.ENGLISH).indexOf(Character.toLowerCase((char)find), start);
    }

    public static int indexOfIgnoreCase(String str, String find) {
        return str.toLowerCase(Locale.ENGLISH).indexOf(find.toLowerCase(Locale.ENGLISH));
    }

    public static int indexOfIgnoreCase(String str, String find, int start) {
        return str.toLowerCase(Locale.ENGLISH).indexOf(find.toLowerCase(Locale.ENGLISH), start);
    }

    public static int lastIndexOfIgnoreCase(String str, int find) {
        return str.toLowerCase(Locale.ENGLISH).lastIndexOf(Character.toLowerCase((char)find));
    }

    public static int lastIndexOfIgnoreCase(String str, int find, int start) {
        return str.toLowerCase(Locale.ENGLISH).lastIndexOf(Character.toLowerCase((char)find), start);
    }

    public static int lastIndexOfIgnoreCase(String str, String find) {
        return str.toLowerCase(Locale.ENGLISH).lastIndexOf(find.toLowerCase(Locale.ENGLISH));
    }

    public static int lastIndexOfIgnoreCase(String str, String find, int start) {
        return str.toLowerCase(Locale.ENGLISH).lastIndexOf(find.toLowerCase(Locale.ENGLISH), start);
    }

    public static int occurencesOf(String str, char ch) {
        char[] s = new char[str.length()];
        str.getChars(0, s.length, s, 0);
        int count = 0;
        for (int i = 0; i < s.length; ++i) {
            if (s[i] != ch) continue;
            ++count;
        }
        return count;
    }

    public static int occurencesOfIgnoreCase(String str, char ch) {
        return StringUtils.occurencesOf(str.toLowerCase(Locale.ENGLISH), Character.toLowerCase(ch));
    }

    public static String replace(String str, String oldChars, String newChars) {
        int pos;
        int len = newChars.length();
        int lastPos = pos = str.indexOf(oldChars);
        while (pos > -1) {
            String firstPart = str.substring(0, pos);
            String lastPart = str.substring(pos + oldChars.length(), str.length());
            str = firstPart + newChars + lastPart;
            lastPos = pos + len;
            pos = str.indexOf(oldChars, lastPos);
        }
        return str;
    }

    public static String replaceIgnoreCase(String str, String oldChars, String newChars) {
        int pos;
        String lowerStr = str.toLowerCase(Locale.ENGLISH);
        int len = newChars.length();
        int lastPos = pos = lowerStr.indexOf(oldChars);
        while (pos > -1) {
            String firstPart = str.substring(0, pos);
            String lastPart = str.substring(pos + oldChars.length(), str.length());
            str = firstPart + newChars + lastPart;
            lastPos = pos + len;
            pos = lowerStr.indexOf(oldChars, lastPos);
        }
        return str;
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return str.toLowerCase(Locale.ENGLISH).startsWith(prefix.toLowerCase(Locale.ENGLISH));
    }

    public static boolean startsWithIgnoreCase(String str, String prefix, int start) {
        return str.toLowerCase(Locale.ENGLISH).startsWith(prefix.toLowerCase(Locale.ENGLISH), start);
    }

    public static String stackToString(Throwable e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return "------\r\n" + sw + "------\r\n";
        }
        catch (Exception e2) {
            return "(bad stack2string) " + e.getMessage();
        }
    }

    public static String stackToString(Exception e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return "------\r\n" + sw + "------\r\n";
        }
        catch (Exception e2) {
            return "(bad stack2string) " + e.getMessage();
        }
    }

    public static String byteArrayToString(byte[] ba) {
        int length = ba.length;
        char[] buf = new char[length * 2];
        int i = 0;
        int j = 0;
        while (i < length) {
            byte k = ba[i++];
            buf[j++] = HEX_DIGITS[k >>> 4 & 0xF];
            buf[j++] = HEX_DIGITS[k & 0xF];
        }
        return new String(buf);
    }

    public static byte[] hexFromString(String hex) {
        int len = hex.length();
        byte[] buf = new byte[(len + 1) / 2];
        int i = 0;
        int j = 0;
        if (len % 2 == 1) {
            buf[j++] = (byte)StringUtils.fromDigit(hex.charAt(i++));
        }
        while (i < len) {
            buf[j++] = (byte)(StringUtils.fromDigit(hex.charAt(i++)) << 4 | StringUtils.fromDigit(hex.charAt(i++)));
        }
        return buf;
    }

    public static int fromDigit(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        throw new IllegalArgumentException("invalid hex digit '" + ch + "'");
    }

    public static String escapeXMLstr(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder output = new StringBuilder();
        int len = input.length();
        for (int i = 0; i < len; ++i) {
            char ch = input.charAt(i);
            if (ch == '&') {
                output.append("&amp;");
                continue;
            }
            if (ch == '<') {
                output.append("&lt;");
                continue;
            }
            if (ch == '>') {
                output.append("&gt;");
                continue;
            }
            if (ch == '\'') {
                output.append("&apos;");
                continue;
            }
            if (ch == '\"') {
                output.append("&quot;");
                continue;
            }
            output.append(ch);
        }
        return output.toString();
    }

    public static String escapeHTMLstr(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder output = new StringBuilder();
        int len = input.length();
        for (int i = 0; i < len; ++i) {
            char ch = input.charAt(i);
            if (ch == '&') {
                output.append("&amp;");
                continue;
            }
            if (ch == '<') {
                output.append("&lt;");
                continue;
            }
            if (ch == '>') {
                output.append("&gt;");
                continue;
            }
            if (ch == '\"') {
                output.append("&quot;");
                continue;
            }
            output.append(ch);
        }
        return output.toString();
    }

    public static String headCharUpperCase(String str) {
        if (str == null || "".equals(str)) {
            return str;
        }
        String headChar = str.substring(0, 1).toUpperCase(Locale.ENGLISH);
        if (str.length() == 1) {
            return headChar;
        }
        return headChar + str.substring(1, str.length());
    }

    public static String objToString(Object obj) {
        try {
            ByteArrayOutputStream byteOS = new ByteArrayOutputStream(2048);
            ObjectOutputStream objectOS = new ObjectOutputStream(byteOS);
            objectOS.writeObject(obj);
            objectOS.flush();
            ByteArrayInputStream byteIN = new ByteArrayInputStream(byteOS.toByteArray());
            ByteArrayOutputStream base64OS = new ByteArrayOutputStream(2048);
            BASE64Encoder encoder = new BASE64Encoder();
            encoder.encodeBuffer((InputStream)byteIN, (OutputStream)base64OS);
            base64OS.flush();
            String base64 = new String(base64OS.toByteArray(), StandardCharsets.UTF_8);
            return base64;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Object strToObject(String str) {
        try {
            ByteArrayInputStream byteIN = new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));
            ByteArrayOutputStream base64OS = new ByteArrayOutputStream(2048);
            BASE64Decoder decoder = new BASE64Decoder();
            decoder.decodeBuffer((InputStream)byteIN, (OutputStream)base64OS);
            base64OS.flush();
            ObjectInputStream objectIN = new ObjectInputStream(new ByteArrayInputStream(base64OS.toByteArray()));
            Object obj = objectIN.readObject();
            return obj;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String left(String str, int n) {
        return str.substring(str.length() - n);
    }

    public static String right(String str, int n) {
        return str.substring(str.length() - n, str.length());
    }

    public static boolean isJavaIdentifier(String s) {
        if (StringUtils.isEmpty(s)) {
            return false;
        }
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isJavaIdentifierPart(chars[i]) && (i != 0 || Character.isJavaIdentifierStart(chars[i]))) continue;
            return false;
        }
        return !Arrays.asList(JAVA_KEYWORDS).contains(s);
    }

    public static boolean isJavaClassName(String name) {
        if (StringUtils.isEmpty(name)) {
            return true;
        }
        if (name.startsWith(" ") || name.startsWith(".") || name.endsWith(" ") || name.endsWith(".")) {
            return false;
        }
        String[] pks = StringUtils.split(name, ".");
        for (int i = 0; i < pks.length; ++i) {
            if (StringUtils.isJavaIdentifier(pks[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isKsqlIdentifierPart(String s) {
        if (!StringUtils.isEmpty(s)) {
            char[] chars = s.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (Character.isJavaIdentifierPart(chars[i])) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isKsqlIdentifier(String s) {
        if (StringUtils.isEmpty(s)) {
            return false;
        }
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isJavaIdentifierPart(chars[i]) && (i != 0 || Character.isJavaIdentifierStart(chars[i])) && (i != 0 || chars[i] != '$')) continue;
            return false;
        }
        return true;
    }

    public static boolean isFileName(String name) {
        return !StringUtils.isEmpty(name) && name.indexOf(60) <= -1 && name.indexOf(42) <= -1 && name.indexOf(47) <= -1 && name.indexOf(58) <= -1 && name.indexOf(63) <= -1 && name.indexOf(92) <= -1 && name.indexOf(34) <= -1;
    }
}

