/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class ToolTipGenerator {
    public static String generate(JTextComponent tc) {
        String str = null;
        Dimension dpre = tc.getPreferredSize();
        Dimension dcur = tc.getSize();
        int h0 = (tc.getFontMetrics(tc.getFont()).getHeight() + 1) / 2;
        if (dpre.width > dcur.width || dpre.height > dcur.height + h0) {
            str = tc.getText();
            Font ft = tc.getFont();
            FontMetrics fm = tc.getFontMetrics(ft);
            str = ToolTipGenerator.format(tc, str, ft, fm);
        }
        return str;
    }

    private static String format(JTextComponent tc, String str, Font ft, FontMetrics fm) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len <= 0) {
            return null;
        }
        int MAXWIDTH = 512;
        StringBuilder src = new StringBuilder(str);
        StringBuffer ret = new StringBuffer();
        ret.append("<html>");
        int end = len;
        int start = 0;
        while (start < end) {
            if (start > 0) {
                ret.append("<br>");
            }
            if (fm.stringWidth(str = src.substring(start, end)) > 512) {
                int min = start;
                int max = end;
                int cur = min;
                while (max > min + 1) {
                    cur = (min + max) / 2;
                    str = src.substring(start, cur);
                    if (fm.stringWidth(str) > 512) {
                        max = cur;
                        continue;
                    }
                    min = cur;
                }
                start = cur;
            } else {
                start = end;
            }
            ret.append(str);
        }
        ret.append("</html>");
        ToolTipGenerator.stringReplaceAll(ret, "\n", "<p>");
        ToolTipGenerator.stringReplaceAll(ret, " ", "&nbsp;");
        StringBuilder replacement = new StringBuilder();
        int count = 4;
        if (tc instanceof JTextArea) {
            count = ((JTextArea)tc).getTabSize();
        }
        for (int i = 0; i < count; ++i) {
            replacement.append("&nbsp;");
        }
        ToolTipGenerator.stringReplaceAll(ret, "\t", replacement.toString());
        return ret.toString();
    }

    private static StringBuffer stringReplaceAll(StringBuffer source, String substring, String replacement) {
        int sublen = substring.length();
        int srclen = source.length();
        int rpllen = replacement.length();
        if (sublen == 0 || srclen < sublen) {
            return source;
        }
        int index = source.indexOf(substring);
        while (index != -1) {
            source = source.replace(index, index + sublen, replacement);
            index = source.indexOf(substring, index + rpllen);
        }
        return source;
    }
}

