/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.calculator;

import com.kingdee.cosmic.ctrl.swing.KDFormattedTextField;
import com.kingdee.cosmic.ctrl.swing.calculator.KDCalculator;
import com.kingdee.cosmic.ctrl.swing.calculator.KDCalculatorModel;
import com.kingdee.cosmic.ctrl.swing.calculator.plaf.KingdeeCalculatorPopupUI;
import com.kingdee.cosmic.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.math.BigDecimal;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class KDCalculatorPopup
extends JComponent
implements ClipboardOwner {
    private static final long serialVersionUID = -8218169637404672893L;
    private static final String uiClassID = "CalculatorPopupUI";
    private KDCalculatorModel cm = new KDCalculatorModel();
    private KDCalculator calculator;
    private KDFormattedTextField display;
    private BigDecimal result;

    public KDCalculatorPopup(KDCalculator calculator) {
        this.calculator = calculator;
        this.display = calculator.getDisplay();
        this.enableInputMethods(false);
        this.result = BigDecimal.valueOf(0.0);
        this.updateUI();
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys(this, KeyStroke.getKeyStroke(10, 0));
    }

    public void setResult(BigDecimal result) {
        this.result = result;
        this.calculator.setValue(result);
    }

    public BigDecimal getResult() {
        return this.result;
    }

    public KDCalculatorModel getModel() {
        return this.cm;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public String getExpressValue() {
        return this.cm.getExpressValue();
    }

    public KDFormattedTextField getDisplay() {
        return this.display;
    }

    @Override
    public KingdeeCalculatorPopupUI getUI() {
        return (KingdeeCalculatorPopupUI)this.ui;
    }

    public void setUI(KingdeeCalculatorPopupUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI((KingdeeCalculatorPopupUI)UIManager.getUI(this));
    }

    public boolean isShowExtraZero() {
        return this.getModel().isShowExtraZero();
    }

    public void setShowExtraZero(boolean showExtraZero) {
        this.getModel().setShowExtraZero(showExtraZero);
    }

    public void setPrecision(int precision) {
        this.setPrecision(precision, false);
    }

    private void setPrecision(int precision, boolean enableChange) {
        if (precision < 0 || precision > 15) {
            throw new ArithmeticException("Precision out of range [0,15]");
        }
        this.getUI().setPrecision(precision, enableChange);
        StringBuilder vr = new StringBuilder();
        vr.append('0');
        if (this.isShowExtraZero() && precision > 0) {
            vr.append('.');
            for (int i = 0; i < precision; ++i) {
                vr.append('0');
            }
        }
        this.getModel().setScale(precision);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    static {
        UIManager.getDefaults().put(uiClassID, "com.kingdee.cosmic.ctrl.swing.calculator.plaf.KingdeeCalculatorPopupUI");
    }
}

