/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.dial;

import com.kingdee.cosmic.ctrl.swing.dial.BasicDial;
import com.kingdee.cosmic.ctrl.swing.dial.DialElement;
import com.kingdee.cosmic.ctrl.swing.dial.DialNeedle;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DialIndicator
extends JLabel
implements DialElement {
    private static final long serialVersionUID = 4424104957897891324L;
    protected Rectangle bounds = new Rectangle(0, 0, 0, 0);
    protected BasicDial dial;
    protected DataChangeHandler dataHandler;
    protected DefaultIndicatorFormatter formatter = new DefaultIndicatorFormatter();

    public void install(BasicDial d) {
        this.dial = d;
        if (this.dataHandler == null) {
            this.dataHandler = new DataChangeHandler();
        }
        this.dial.addChangeListener(this.dataHandler);
    }

    public void dismiss() {
        if (this.dataHandler != null) {
            this.dial.removeChangeListener(this.dataHandler);
        }
    }

    public void update() {
        Graphics g;
        if (this.dial != null && (g = this.dial.getGraphics()) != null) {
            Rectangle rc = this.getBounds();
            this.draw(g, rc, this.dial);
            g.dispose();
        }
    }

    @Override
    public void draw(Graphics g, Rectangle area, JComponent c) {
        String str = this.formatter.valueToString(this.dial);
        this.setText(str);
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform oldTrans = g2.getTransform();
        Rectangle rc = this.getBounds();
        g2.translate(rc.x, rc.y);
        this.paint(g2);
        g2.setTransform(oldTrans);
    }

    public void setFormatter(DefaultIndicatorFormatter fmt) {
        this.formatter = fmt;
    }

    public DefaultIndicatorFormatter getFormatter() {
        return this.formatter;
    }

    public static class DefaultIndicatorFormatter {
        public String valueToString(BasicDial dial) {
            int size = dial.getNeedlesCount();
            DialNeedle ndl = null;
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                ndl = dial.getNeedle(i);
                if (ndl != null) {
                    str.append(ndl.getCaption());
                    str.append(':');
                    str.append(ndl.getValue());
                    str.append(' ');
                    continue;
                }
                str.append(" (null) ");
            }
            return str.toString();
        }
    }

    protected static class DataChangeHandler
    implements ChangeListener {
        protected DataChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
        }
    }
}

