/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.dial;

import com.kingdee.cosmic.ctrl.swing.dial.BasicDial;
import com.kingdee.cosmic.ctrl.swing.dial.DialLegend;
import com.kingdee.cosmic.ctrl.swing.dial.DialPan;
import com.kingdee.cosmic.ctrl.swing.dial.DialScale;
import com.kingdee.cosmic.ctrl.swing.dial.ImageScale;
import com.kingdee.cosmic.ctrl.swing.dial.Legend;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.text.Format;

public class ImageDial
extends BasicDial {
    private static final long serialVersionUID = 3459819918184948462L;
    protected DialPan topPan;
    protected Rectangle topPanRect;

    public DialPan getTopPan() {
        return this.topPan;
    }

    public void setTopPan(DialPan p) {
        this.topPan = p;
    }

    public Rectangle getTopPanRect() {
        return this.topPanRect;
    }

    public void setTopPanRect(Rectangle rectangle) {
        this.topPanRect = rectangle;
    }

    public Legend createKpiLegend(String normal, String warning, String critical, int orient) {
        Legend legend = null;
        DialScale scl = this.getScale(0);
        if (scl instanceof ImageScale) {
            ImageScale kpiscl = (ImageScale)scl;
            legend = DialLegend.createInstance(kpiscl.getNormalPaint(), normal, kpiscl.getWarningPaint(), warning, kpiscl.getCriticalPaint(), critical, orient);
        }
        return legend;
    }

    @Override
    protected void drawTitle(Graphics2D g2) {
        if (this.topPan != null && this.topPanRect != null) {
            Rectangle area = new Rectangle(this.topPanRect.x + this.getInsets().left, this.topPanRect.y + this.getInsets().top, this.topPanRect.width, this.topPanRect.height);
            this.topPan.draw(g2, area, this);
        }
        super.drawTitle(g2);
    }

    @Override
    protected String generateToolTip() {
        DialScale scl = this.getScale(0);
        Format ft = null;
        Object val = null;
        String tip = "";
        if (scl != null) {
            ft = scl.getTickLabelFormat();
        }
        if (ft != null) {
            val = this.getValue();
        }
        if (val != null) {
            tip = ft.format(val);
        }
        return tip;
    }
}

