/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.model;

import com.kingdee.cosmic.ctrl.swing.event.DataChangeEvent;
import com.kingdee.cosmic.ctrl.swing.event.DataChangeListener;
import com.kingdee.cosmic.ctrl.swing.model.IDateTimeModel;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public abstract class AbstractDateTimeModel
implements IDateTimeModel {
    private Date maxDate = null;
    private Date minDate = null;
    private int maxYear = -1;
    private int maxMonth = -1;
    private int maxDay = -1;
    private int maxHour = -1;
    private int maxMinute = -1;
    private int maxMilliSecond = -1;
    private int maxNanos = -1;
    private int minYear = -1;
    private int minMonth = -1;
    private int minDay = -1;
    private int minHour = -1;
    private int minMinute = -1;
    private int minMilliSecond = -1;
    private int minNanos = -1;
    private boolean timeEnable = false;
    private boolean dateEnable = false;
    private boolean milliSecondEnable = false;
    private boolean isEmptyValue = false;
    private boolean fireListener = true;
    private int calendarField = -1;
    private transient DataChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();

    @Override
    public void addChangeListener(DataChangeListener l) {
        this.listenerList.add(DataChangeListener.class, l);
    }

    @Override
    public void removeChangeListener(DataChangeListener l) {
        this.listenerList.remove(DataChangeListener.class, l);
    }

    public DataChangeListener[] getChangeListeners() {
        return (DataChangeListener[])this.listenerList.getListeners(DataChangeListener.class);
    }

    protected void fireDataChanged() {
        if (this.changeEvent == null) {
            this.changeEvent = new DataChangeEvent(this);
        }
        this.changeEvent.setOldValue(this.getValue());
        this.changeEvent.setNewValue(this.getValue());
        this.fireDataChanged(this.changeEvent);
    }

    protected void fireDataChanged(DataChangeEvent e) {
        if (this.fireListener) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != DataChangeListener.class) continue;
                if (e == null) {
                    e = new DataChangeEvent(this);
                    e.setOldValue(this.getValue());
                    e.setNewValue(this.getValue());
                }
                ((DataChangeListener)listeners[i + 1]).dataChanged(e);
            }
        }
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public void setDataChangeListenerFired(boolean fire) {
        this.fireListener = fire;
    }

    public boolean getDataChangeListenerFired() {
        return this.fireListener;
    }

    @Override
    public void setTimeEnable(boolean b) {
        this.timeEnable = b;
    }

    @Override
    public boolean isTimeEnable() {
        return this.timeEnable;
    }

    @Override
    public Date getMaxDateTime() {
        return this.maxDate;
    }

    @Override
    public int getMaxFieldValue(int field) {
        int v = -1;
        switch (field) {
            case 1: {
                v = this.maxYear;
                break;
            }
            case 2: {
                v = this.maxMonth;
                break;
            }
            case 5: {
                v = this.maxDay;
                break;
            }
            case 11: {
                v = this.maxHour;
                break;
            }
            case 12: {
                v = this.maxMinute;
                break;
            }
            case 14: {
                v = this.maxMilliSecond;
                break;
            }
            case 1977: {
                v = this.maxNanos;
                break;
            }
        }
        return v;
    }

    @Override
    public Date getMinDateTime() {
        return this.minDate;
    }

    @Override
    public int getMinFieldValue(int field) {
        int v = -1;
        switch (field) {
            case 1: {
                v = this.minYear;
                break;
            }
            case 2: {
                v = this.minMonth;
                break;
            }
            case 5: {
                v = this.minDay;
                break;
            }
            case 11: {
                v = this.minHour;
                break;
            }
            case 12: {
                v = this.minMinute;
                break;
            }
            case 14: {
                v = this.minMilliSecond;
                break;
            }
            case 1977: {
                v = this.minNanos;
                break;
            }
        }
        return v;
    }

    @Override
    public void setMaxDateTime(Date d) {
        this.maxDate = d;
    }

    @Override
    public void setMaxFieldValue(int field, int max) {
        switch (field) {
            case 1: {
                this.maxYear = max;
                break;
            }
            case 2: {
                this.maxMonth = max;
                break;
            }
            case 5: {
                this.maxDay = max;
                break;
            }
            case 11: {
                this.maxHour = max;
                break;
            }
            case 12: {
                this.maxMinute = max;
                break;
            }
            case 14: {
                this.maxMilliSecond = max;
                break;
            }
            case 1977: {
                this.maxNanos = max;
                break;
            }
        }
    }

    @Override
    public void setMinDateTime(Date d) {
        this.minDate = d;
    }

    @Override
    public void setMinFieldValue(int field, int min) {
        switch (field) {
            case 1: {
                this.minYear = min;
                break;
            }
            case 2: {
                this.minMonth = min;
                break;
            }
            case 5: {
                this.minDay = min;
                break;
            }
            case 11: {
                this.minHour = min;
                break;
            }
            case 12: {
                this.minMinute = min;
                break;
            }
            case 14: {
                this.minMilliSecond = min;
                break;
            }
            case 1977: {
                this.minNanos = min;
                break;
            }
        }
    }

    protected boolean calendarFieldOK(int calendarField) {
        switch (calendarField) {
            case 1: 
            case 2: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 1977: {
                return true;
            }
        }
        return false;
    }

    protected int getValueOfField(Calendar value, int f) {
        if (value == null) {
            return -1;
        }
        int v = -1;
        switch (f) {
            case 1: {
                v = value.get(1);
                break;
            }
            case 2: {
                v = value.get(2) + 1;
                break;
            }
            case 5: {
                v = value.get(5);
                break;
            }
            case 11: {
                v = value.get(11);
                break;
            }
            case 12: {
                v = value.get(12);
                break;
            }
            case 13: {
                v = value.get(13);
                break;
            }
            case 14: {
                v = value.get(14);
                break;
            }
            case 1977: {
                v = new Timestamp(value.getTime().getTime()).getNanos();
                break;
            }
            default: {
                throw new IllegalArgumentException("field value is illegal.");
            }
        }
        return v;
    }

    protected boolean setValueOfField(Calendar value, int f, int v) {
        if (value == null) {
            return false;
        }
        int old = value.get(f);
        boolean b = true;
        if (old == v) {
            return false;
        }
        switch (f) {
            case 1: 
            case 2: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                value.set(f, v);
                break;
            }
            case 1977: {
                Timestamp tt = new Timestamp(value.getTime().getTime());
                tt.setNanos(v);
                value.setTime(new Date(tt.getTime()));
                break;
            }
            default: {
                b = false;
            }
        }
        return b;
    }

    public void setCalendarField(int f) {
        if (!this.calendarFieldOK(f)) {
            throw new IllegalArgumentException("invalid calendarField");
        }
        this.calendarField = f;
    }

    public int getCalendarField() {
        return this.calendarField;
    }

    protected boolean isMaxMinScope(int f, int value) {
        switch (f) {
            case 1: {
                if (value <= 3000 && value >= 1000) break;
                return false;
            }
            case 2: {
                if (value <= 12 && value >= 0) break;
                return false;
            }
            case 5: {
                if (value <= 31 && value >= 0) break;
                return false;
            }
            case 11: {
                if (value <= 24 && value >= 0) break;
                return false;
            }
            case 12: 
            case 13: {
                if (value <= 60 && value >= 0) break;
                return false;
            }
        }
        int maxV = this.getMaxFieldValue(f);
        int minV = this.getMinFieldValue(f);
        if (maxV == -1 && minV == -1) {
            return true;
        }
        if (maxV != -1 && minV != -1) {
            if (maxV >= minV && value <= maxV && value >= minV) {
                return true;
            }
            return maxV < minV;
        }
        if (maxV == -1 && value >= minV) {
            return true;
        }
        return minV == -1 && value <= maxV;
    }

    @Override
    public boolean isDateEnable() {
        return this.dateEnable;
    }

    @Override
    public void setDateEnable(boolean b) {
        this.dateEnable = b;
    }

    @Override
    public void setMilliSecondEnable(boolean b) {
        this.milliSecondEnable = b;
    }

    @Override
    public boolean isMillisecondEnable() {
        return this.milliSecondEnable;
    }

    @Override
    public boolean isEmptyValue() {
        return this.isEmptyValue;
    }

    @Override
    public void setEmptyValue(boolean b) {
        this.isEmptyValue = b;
    }
}

