/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.model;

import com.kingdee.cosmic.ctrl.swing.event.DataChangeEvent;
import com.kingdee.cosmic.ctrl.swing.model.AbstractCurrencyEditorModel;
import java.math.BigDecimal;

public class CurrencyEditorModel
extends AbstractCurrencyEditorModel {
    private BigDecimal value;
    private boolean negative;

    @Override
    public void setValue(BigDecimal value) {
        if (this.value == null && value == null) {
            return;
        }
        if (this.value != null && this.value.compareTo(value) == 0) {
            return;
        }
        if (value != null && value.signum() < 0) {
            this.negative = true;
            value = value.negate();
        }
        BigDecimal oldValue = this.value;
        this.value = value;
        this.fireModelChanged(new DataChangeEvent("modelChanged", value, oldValue));
    }

    @Override
    public BigDecimal getValue() {
        if (this.value != null && this.negative) {
            return this.value.negate();
        }
        return this.value;
    }

    @Override
    public boolean isNegative() {
        return this.negative;
    }

    @Override
    public void setNegative(boolean negative) {
        this.negative = negative;
    }
}

