/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.model;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import com.kingdee.cosmic.ctrl.swing.KDInfoTip;
import com.kingdee.cosmic.ctrl.swing.event.InfoTipModelChangeEvent;
import com.kingdee.cosmic.ctrl.swing.model.AbstractInfoTipModel;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class InfoTipModel
extends AbstractInfoTipModel
implements Serializable {
    private static final long serialVersionUID = 3045660510157687603L;
    private KDInfoTip c;
    private transient float maxRenderWidth = 250.0f;
    private Color bgColor = new Color(255, 255, 225, 200);
    private Font ft = new Font(CtrlCommonMessages.getMLS((String)"yahei", (String)"\u5fae\u8f6f\u96c5\u9ed1"), 0, 10);
    private String tip;
    private String oldtip = "";

    public InfoTipModel(KDInfoTip c) {
        this.c = c;
    }

    @Override
    public void setBackgroundColor(Color bgColor) {
        Color oldColor = this.bgColor;
        this.bgColor = bgColor;
        if (this.c.isShowing()) {
            this.fireModelChanged(new InfoTipModelChangeEvent(this, oldColor, bgColor));
        }
    }

    @Override
    public Color getBackgroundColor() {
        return this.bgColor;
    }

    @Override
    public void setText(String tip) {
        if (this.c.getType() == 1) {
            if (tip == null || tip.equals("") || this.oldtip.equals(tip)) {
                return;
            }
            this.oldtip = this.tip;
            this.tip = tip;
            if (this.c.isShowing()) {
                this.fireModelChanged(new InfoTipModelChangeEvent(this, this.oldtip, this.tip));
            }
            this.oldtip = tip;
        } else {
            if (tip == null || tip.equals("") || this.oldtip.equals(tip)) {
                return;
            }
            this.oldtip = this.tip;
            this.tip = this.c.getType() == 0 ? this.formatToHtml(tip) : tip;
            View v = BasicHTML.createHTMLView(this.c, this.tip);
            this.c.putClientProperty("view", v);
            if (this.c.isShowing()) {
                this.fireModelChanged(new InfoTipModelChangeEvent(this, this.oldtip, tip));
            }
            this.oldtip = tip;
        }
    }

    @Override
    public String getText() {
        return this.tip;
    }

    @Override
    public Font getFont() {
        if (this.c.getType() == 1) {
            return new Font(CtrlCommonMessages.getMLS((String)"yahei", (String)"\u5fae\u8f6f\u96c5\u9ed1"), 0, 12);
        }
        return this.ft;
    }

    @Override
    public void setMaxRenderWidth(float maxWidth) {
        if (this.c.getType() == 1) {
            this.maxRenderWidth = maxWidth;
            return;
        }
        if (maxWidth < 250.0f) {
            return;
        }
        float oldWidth = this.maxRenderWidth;
        this.maxRenderWidth = maxWidth;
        View v = BasicHTML.createHTMLView(this.c, this.tip);
        v.setSize(maxWidth, 0.0f);
        this.c.putClientProperty("view", v);
        if (this.c.isShowing()) {
            this.fireModelChanged(new InfoTipModelChangeEvent(this, new Float(oldWidth), new Float(this.maxRenderWidth)));
        }
    }

    @Override
    public float getMaxRenderWidth() {
        return this.maxRenderWidth;
    }

    private String formatToHtml(String str) {
        StringBuffer src = new StringBuffer(str);
        StringBuilder ret = new StringBuilder();
        ret.append("<html><font face='").append(this.ft.getFamily()).append("' style='font-size:").append(this.ft.getSize()).append("px;'>");
        String[] source = new String[]{"\n", "\t"};
        String[] target = new String[]{"<br>", "&nbsp;&nbsp;"};
        for (int i = 0; i < source.length; ++i) {
            int index = src.indexOf(source[i]);
            while (index != -1) {
                src.replace(index, index + 1, target[i]);
                index = src.indexOf(source[i], index + 1);
            }
        }
        ret.append(src);
        ret.append("</font></html>");
        return ret.toString();
    }
}

