/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.palette;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDEditorPane;
import com.kingdee.cosmic.ctrl.swing.KDFrame;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDMenu;
import com.kingdee.cosmic.ctrl.swing.KDMenuBar;
import com.kingdee.cosmic.ctrl.swing.KDMenuItem;
import com.kingdee.cosmic.ctrl.swing.KDOptionPane;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDSlider;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.common.i18n.CtrlSwingMessages;
import com.kingdee.cosmic.ctrl.swing.palette.PaletteThread;
import com.kingdee.cosmic.ctrl.swing.plaf.IndividualizedThemeStore;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class PaletteFrame
extends KDFrame {
    private static final Logger logger = LogUtil.getPackageLogger(PaletteFrame.class);
    private KDLabel hueLabel;
    private KDSlider hue;
    private KDLabel saturationLabel;
    private KDSlider saturation;
    private KDLabel brightnessLabel;
    private KDSlider brightness;
    private ImageCanvas imageCanvas;
    private KDPanel sliderPanel;
    private BufferedImage image;
    private PaletteThread pixelManipulationThread;
    private KDButton apply = new KDButton(CtrlSwingMessages.getMLS("applyButton_Text", "wrong"));
    private KDButton save = new KDButton(CtrlSwingMessages.getMLS("saveButton_Text", "wrong"));
    private KDButton recover = new KDButton(CtrlSwingMessages.getMLS("recoverButton_Text", "wrong"));
    private ActionListener applyAction;
    private ActionListener saveAction;
    private ActionListener recoverAction;
    private String policyText = "<html><div align='center'><font size='12' color='red'><strong>" + CtrlSwingMessages.getMLS("limitedToEngineers", "\u9650\u5de5\u7a0b\u5e08\u4f7f\u7528") + "</strong></font></div><br>&nbsp;&nbsp;&nbsp;&nbsp;" + CtrlSwingMessages.getMLS("thisToolIsEASSkinsEngineerTesting", "\u672c\u5de5\u5177\u4e3aEAS\u6362\u80a4\u529f\u80fd\u7684\u5de5\u7a0b\u5e08\u6d4b\u8bd5\u5165\u53e3\u3002\u8be5\u529f\u80fd\u5c06\u5728EAS\u540e\u7eed\u7248\u672c\u4e2d\u4f5c\u4e3a\u6807\u51c6\u4ea7\u54c1\u53d1\u5e03\u3002") + "<br>&nbsp;&nbsp;&nbsp;&nbsp;" + CtrlSwingMessages.getMLS("ifYouHavePersonalizedSkinsNeedPleaseFollowAdvice", "\u5982\u60a8\u5728\u8fd9\u4e2a\u7248\u672c\u786e\u6709\u4e2a\u6027\u5316\u6362\u80a4\u7684\u9700\u6c42\uff0c\u8bf7\u9075\u4ece\u8f6f\u4ef6\u5b9e\u65bd\u4eba\u5458\u7684\u5efa\u8bae\u81ea\u7531\u4f7f\u7528\u672c\u6a21\u5757\u3002") + CtrlSwingMessages.getMLS("weGuaranteeStrictlyTestedAndWillNotDamageYourSystem", "\u6211\u4eec\u4fdd\u8bc1\u8be5\u5b50\u7cfb\u7edf\u7ecf\u8fc7\u4e86\u4e25\u683c\u7684\u6d4b\u8bd5\uff0c\u4e0d\u4f1a\u5bf9\u60a8\u548c\u4f60\u7684\u8f6f\u4ef6\u7cfb\u7edf\u9020\u6210\u4efb\u4f55\u635f\u5bb3\u3002\u4f46\u7531\u4e8e\u8be5\u529f\u80fd\u4e0d\u662fEAS\u5f53\u524d\u7248\u672c\u7684\u6807\u51c6\u6a21\u5757,\u6211\u4eec\u5c06\u4e0d\u4e3a\u672c\u7248\u672c\u7684\u8fd9\u79cd\u5e94\u7528\u63d0\u4f9b\u4efb\u4f55\u6f5c\u5728\u95ee\u9898\u7684\u6280\u672f\u652f\u6301\uff0c\u76f4\u5230\u60a8\u5347\u7ea7\u5230\u6b63\u786e\u7684\u7248\u672c\u3002") + "<br><div align='center'><font size='12' color='red'><strong>For Engineers Only</strong></font></div><br>&nbsp;&nbsp;&nbsp;&nbsp;This beta-version tool is the engineer's test entrance for EAS's skin transformation. It will officially arrive at EAS System in the follow-up version.<br>&nbsp;&nbsp;&nbsp;&nbsp;If you do have some requirement to change EAS's color series in this version, please follow implementant engineer's suggestion and  help yourself to use it. We can insure that sub system has passed the industrial-level test, and won't do any harm to you and your software system. But for the reason that the function isn't a standard module in the current version, we won't support that kind of use for any potential bug util you update to the right version.<br><br><div align='right'>Project Manager: Fu Xiuhu<br>UI Designer: Wang Jing; Tan Shan<br>Graphics Engineer: David Song; Pian Yao</div></html>";
    private KDPanel glassPane = new KDPanel(new BorderLayout()){

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(new Color(200, 200, 200, 200));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            super.paintComponent(g);
        }
    };

    public PaletteFrame() {
        this.init();
        this.initSliderArea();
        this.initBars();
        this.initGlassPane();
    }

    private void initGlassPane() {
        this.glassPane.setOpaque(false);
        this.glassPane.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        final KDEditorPane policy = new KDEditorPane("text/html", this.policyText);
        policy.setOpaque(false);
        policy.setEditable(false);
        final KDWorkButton agree = new KDWorkButton(CtrlSwingMessages.getMLS("agreeButton_Text", "wrong"));
        agree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaletteFrame.this.glassPane.setVisible(false);
            }
        });
        final KDWorkButton refuse = new KDWorkButton(CtrlSwingMessages.getMLS("refuseButton_Text", "wrong"));
        refuse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaletteFrame.this.setVisible(false);
                PaletteFrame.this.dispose();
            }
        });
        this.glassPane.add(policy);
        this.glassPane.add(agree);
        this.glassPane.add(refuse);
        this.glassPane.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void layoutContainer(Container parent) {
                policy.setBounds(20, 0, 600, 520);
                agree.setBounds(250, 550, 40, 20);
                refuse.setBounds(350, 550, 40, 20);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return null;
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return null;
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }
        });
        this.glassPane.setFocusTraversalKeysEnabled(false);
        this.glassPane.setFocusCycleRoot(true);
        this.setGlassPane(this.glassPane);
        this.glassPane.setVisible(true);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.glassPane.requestFocusInWindow();
        } else {
            this.pixelManipulationThread.stopGentlly();
        }
    }

    private void init() {
        this.setResizable(false);
        this.applyAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndividualizedThemeStore.tryOn((int)PaletteFrame.this.hue.getValue(), (int)PaletteFrame.this.saturation.getValue(), (int)PaletteFrame.this.brightness.getValue());
                KDOptionPane.showMessageDialog(PaletteFrame.this, CtrlSwingMessages.getMLS("apply_Message", "wrong"));
            }
        };
        this.saveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndividualizedThemeStore.haveIt();
                KDOptionPane.showMessageDialog(PaletteFrame.this, CtrlSwingMessages.getMLS("save_Message", "wrong"));
            }
        };
        this.recoverAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = System.getProperty("EAS_HOME") + "/client/deploy/client/individualizedtheme.properties";
                File toBeDelete = new File(FilenameUtils.normalize((String)path));
                if (toBeDelete.exists() && !toBeDelete.delete()) {
                    logger.warn((Object)(toBeDelete.getName() + "\u6587\u4ef6\u5220\u9664\u5931\u8d25"));
                }
                KDOptionPane.showMessageDialog(PaletteFrame.this, CtrlSwingMessages.getMLS("recover_Message", "wrong"));
            }
        };
        this.setTitle(CtrlSwingMessages.getMLS("windowTitle", "wrong"));
        this.setSize(650, 720);
        this.imageCanvas = new ImageCanvas();
        this.sliderPanel = new KDPanel();
        this.sliderPanel.setPreferredSize(new Dimension(400, 200));
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)this.imageCanvas, "Center");
        c.add((Component)this.sliderPanel, "South");
        this.sliderPanel.setLayout(null);
        this.pixelManipulationThread = new PaletteThread(this.imageCanvas);
        this.pixelManipulationThread.start();
        this.openFile();
    }

    private void initSliderArea() {
        this.hueLabel = new KDLabel(CtrlSwingMessages.getMLS("hueLabel_Text", "wrong"));
        this.saturationLabel = new KDLabel(CtrlSwingMessages.getMLS("saturationLabel_Text", "wrong"));
        this.brightnessLabel = new KDLabel(CtrlSwingMessages.getMLS("brightnessLabel_Text", "wrong"));
        this.hue = new KDSlider(-180, 180, 0);
        this.saturation = new KDSlider(-100, 100, 0);
        this.brightness = new KDSlider(-100, 100, 0);
        this.hue.setPaintTicks(true);
        this.hue.setMajorTickSpacing(40);
        this.hue.setMinorTickSpacing(5);
        this.hue.setPaintLabels(true);
        this.hue.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider slider = (JSlider)e.getSource();
                if (!PaletteFrame.this.pixelManipulationThread.isAlive()) {
                    PaletteFrame.this.pixelManipulationThread = new PaletteThread(PaletteFrame.this.imageCanvas);
                    PaletteFrame.this.pixelManipulationThread.start();
                    PaletteFrame.this.pixelManipulationThread.setImage(PaletteFrame.this.image, false);
                }
                PaletteFrame.this.pixelManipulationThread.setDeltaHue(slider.getValue());
            }
        });
        this.saturation.setPaintTicks(true);
        this.saturation.setMajorTickSpacing(40);
        this.saturation.setMinorTickSpacing(5);
        this.saturation.setPaintLabels(true);
        this.saturation.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider slider = (JSlider)e.getSource();
                if (!PaletteFrame.this.pixelManipulationThread.isAlive()) {
                    PaletteFrame.this.pixelManipulationThread = new PaletteThread(PaletteFrame.this.imageCanvas);
                    PaletteFrame.this.pixelManipulationThread.start();
                    PaletteFrame.this.pixelManipulationThread.setImage(PaletteFrame.this.image, false);
                }
                PaletteFrame.this.pixelManipulationThread.setDeltaSaturation(slider.getValue());
            }
        });
        this.brightness.setPaintTicks(true);
        this.brightness.setMajorTickSpacing(40);
        this.brightness.setMinorTickSpacing(5);
        this.brightness.setPaintLabels(true);
        this.brightness.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider slider = (JSlider)e.getSource();
                if (!PaletteFrame.this.pixelManipulationThread.isAlive()) {
                    PaletteFrame.this.pixelManipulationThread = new PaletteThread(PaletteFrame.this.imageCanvas);
                    PaletteFrame.this.pixelManipulationThread.start();
                    PaletteFrame.this.pixelManipulationThread.setImage(PaletteFrame.this.image, false);
                }
                PaletteFrame.this.pixelManipulationThread.setDeltaBrightness(slider.getValue());
            }
        });
        this.apply.addActionListener(this.applyAction);
        this.save.addActionListener(this.saveAction);
        this.recover.addActionListener(this.recoverAction);
        this.hueLabel.setBounds(30, 15, 80, 20);
        this.hue.setBounds(110, 0, 500, 40);
        this.hue.setOpaque(false);
        this.sliderPanel.add(this.hueLabel);
        this.sliderPanel.add(this.hue);
        this.saturationLabel.setBounds(30, 65, 80, 20);
        this.saturation.setBounds(110, 50, 500, 40);
        this.saturation.setOpaque(false);
        this.sliderPanel.add(this.saturationLabel);
        this.sliderPanel.add(this.saturation);
        this.brightnessLabel.setBounds(30, 105, 80, 20);
        this.brightness.setBounds(110, 100, 500, 40);
        this.brightness.setOpaque(false);
        this.sliderPanel.add(this.brightnessLabel);
        this.sliderPanel.add(this.brightness);
        JSeparator s = new JSeparator(0);
        s.setBounds(0, 155, 650, 5);
        this.sliderPanel.add(s);
        this.apply.setBounds(380, 170, 40, 20);
        this.save.setBounds(460, 170, 40, 20);
        this.recover.setBounds(540, 170, 40, 20);
        this.sliderPanel.add(this.apply);
        this.sliderPanel.add(this.save);
        this.sliderPanel.add(this.recover);
    }

    private void initBars() {
        KDMenu fileMenu = new KDMenu(CtrlSwingMessages.getMLS("topMenu_Text", "Menu"));
        KDMenuItem openItem = new KDMenuItem(CtrlSwingMessages.getMLS("applyButton_Text", "Apply"));
        openItem.addActionListener(this.applyAction);
        fileMenu.add(openItem);
        KDMenuItem saveItem = new KDMenuItem(CtrlSwingMessages.getMLS("saveButton_Text", "Save"));
        saveItem.addActionListener(this.saveAction);
        fileMenu.add(saveItem);
        KDMenuItem recoverItem = new KDMenuItem(CtrlSwingMessages.getMLS("recoverButton_Text", "Recover"));
        recoverItem.addActionListener(this.recoverAction);
        fileMenu.add(recoverItem);
        KDMenuBar menuBar = new KDMenuBar();
        menuBar.add(fileMenu);
        this.setJMenuBar(menuBar);
    }

    public void openFile() {
        try {
            this.image = ImageIO.read(this.getClass().getResource("IndividualizingPic.png"));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Failed to open image file.", "critical fail", 2);
            return;
        }
        this.pixelManipulationThread.setImage(this.image, true);
    }

    class ImageCanvas
    extends KDPanel {
        private int imageX;
        private int imageY;
        private int imageW;
        private int imageH;
        private int blockWidth;

        ImageCanvas() {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (PaletteFrame.this.image != null) {
                g.setColor(Color.white);
                g.fillRect(40, 35, 560, 385);
                g.drawImage(PaletteFrame.this.image, this.imageX, this.imageY, this.imageW, this.imageH, null);
            }
        }

        void paintBlockNo(int blockNo) {
            this.repaint(this.imageX + this.blockWidth * blockNo, this.imageY, this.blockWidth, this.imageH);
        }

        void setBlockCount(float blockCount) {
            this.blockWidth = (int)((float)this.imageW / blockCount);
        }

        @Override
        public void doLayout() {
            PaletteFrame.this.imageCanvas.computeImageArea();
            super.doLayout();
        }

        private void computeImageArea() {
            if (PaletteFrame.this.image != null) {
                int imageWidth = PaletteFrame.this.image.getWidth();
                int imageHeight = PaletteFrame.this.image.getHeight();
                int imagePanelWidth = PaletteFrame.this.imageCanvas.getWidth();
                int imagePanelHeight = PaletteFrame.this.imageCanvas.getHeight();
                float tempX = (imagePanelWidth - imageWidth) / 2;
                float tempY = (imagePanelHeight - imageHeight) / 2;
                if (tempX < 0.0f && tempY > 0.0f) {
                    float scaleFactor = 1.0f + tempX * 2.0f / (float)imageWidth;
                    this.imageX = 0;
                    this.imageY = (int)(((float)imagePanelHeight - (float)imageHeight * scaleFactor) / 2.0f);
                    this.imageW = (int)((float)imageWidth * scaleFactor);
                    this.imageH = (int)((float)imageHeight * scaleFactor);
                } else if (tempX > 0.0f && tempY < 0.0f) {
                    float scaleFactor = 1.0f + tempY * 2.0f / (float)imageHeight;
                    this.imageX = (int)(((float)imagePanelWidth - (float)imageWidth * scaleFactor) / 2.0f);
                    this.imageY = 0;
                    this.imageW = (int)((float)imageWidth * scaleFactor);
                    this.imageH = (int)((float)imageHeight * scaleFactor);
                } else if (tempX < 0.0f && tempY < 0.0f) {
                    float scaleFactor = tempX < tempY ? 1.0f + tempX * 2.0f / (float)imageWidth : 1.0f + tempY * 2.0f / (float)imageHeight;
                    this.imageX = (int)(((float)imagePanelWidth - (float)imageWidth * scaleFactor) / 2.0f);
                    this.imageY = (int)(((float)imagePanelHeight - (float)imageHeight * scaleFactor) / 2.0f);
                    this.imageW = (int)((float)imageWidth * scaleFactor);
                    this.imageH = (int)((float)imageHeight * scaleFactor);
                } else {
                    this.imageX = (int)tempX;
                    this.imageY = (int)tempY;
                    this.imageW = imageWidth;
                    this.imageH = imageHeight;
                }
            }
        }
    }
}

