/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeRadioButtonUI;
import com.kingdee.cosmic.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;

public class KingdeeCheckBoxUI
extends KingdeeRadioButtonUI {
    private static KingdeeCheckBoxUI checkboxUI = new KingdeeCheckBoxUI();
    private static String propertyPrefix = "CheckBox.";
    private boolean defaults_initialized = false;

    public static ComponentUI createUI(JComponent b) {
        return checkboxUI;
    }

    @Override
    public String getPropertyPrefix() {
        return propertyPrefix;
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (!this.defaults_initialized) {
            this.icon = UIManager.getIcon(this.getPropertyPrefix() + "icon");
            this.defaults_initialized = true;
        }
        this.setTravelsalKeys(b);
    }

    private void setTravelsalKeys(AbstractButton b) {
        CtrlSwingUtilities.addManagingFocusForwardTraversalKeys(b, KeyStroke.getKeyStroke(39, 0));
        CtrlSwingUtilities.addManagingFocusBackwardTraversalKeys(b, KeyStroke.getKeyStroke(37, 0));
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.defaults_initialized = false;
    }

    @Override
    protected void installKeyboardActions(AbstractButton b) {
        super.installKeyboardActions(b);
        b.getInputMap(0).put(KeyStroke.getKeyStroke(107, 0), "selectCheckBox");
        b.getActionMap().put("selectCheckBox", new CheckBoxAction(true, b));
        b.getInputMap(0).put(KeyStroke.getKeyStroke(109, 0), "unselectCheckBox");
        b.getActionMap().put("unselectCheckBox", new CheckBoxAction(false, b));
    }

    @Override
    protected void installListeners(AbstractButton b) {
        BasicButtonListener listener = this.createButtonListener(b);
        if (listener != null) {
            b.putClientProperty(this, listener);
            b.addMouseListener(listener);
            b.addMouseMotionListener(listener);
            b.addFocusListener(listener);
            b.addPropertyChangeListener(listener);
            b.addChangeListener(listener);
        }
    }

    public void setReadOnly(KDCheckBox b, boolean readOnly) {
        if (readOnly) {
            b.getActionMap().put("selectCheckBox", null);
            b.getActionMap().put("unselectCheckBox", null);
            BasicButtonListener bbl = (BasicButtonListener)b.getClientProperty(this);
            if (bbl != null) {
                b.removeMouseListener(bbl);
                b.removeMouseMotionListener(bbl);
                b.removePropertyChangeListener(bbl);
                b.removeChangeListener(bbl);
                bbl.uninstallKeyboardActions(b);
            }
            b.removeKeyListener(this.listener);
        } else {
            b.getActionMap().put("selectCheckBox", new CheckBoxAction(true, b));
            b.getActionMap().put("unselectCheckBox", new CheckBoxAction(false, b));
            BasicButtonListener bbl = (BasicButtonListener)b.getClientProperty(this);
            if (bbl != null) {
                b.addMouseListener(bbl);
                b.addMouseMotionListener(bbl);
                b.addPropertyChangeListener(bbl);
                b.addChangeListener(bbl);
                bbl.installKeyboardActions(b);
            }
            b.addKeyListener(this.listener);
        }
    }

    private static class CheckBoxAction
    extends AbstractAction {
        private static final long serialVersionUID = -3000074767490751015L;
        private boolean toBeSelected;
        private AbstractButton b;

        public CheckBoxAction(boolean toBeSelected, AbstractButton b) {
            this.toBeSelected = toBeSelected;
            this.b = b;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ButtonModel model = this.b.getModel();
            if (this.toBeSelected) {
                model.setSelected(true);
            } else {
                model.setSelected(false);
            }
        }
    }
}

